/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive;

import jakarta.validation.Validator;
import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.Map;
import org.springframework.beans.BeanUtils;
import org.springframework.core.MethodParameter;
import org.springframework.core.ReactiveAdapterRegistry;
import org.springframework.core.ResolvableType;
import org.springframework.lang.Nullable;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.validation.DataBinder;
import org.springframework.validation.SmartValidator;
import org.springframework.validation.support.BindingAwareConcurrentModel;
import org.springframework.web.bind.WebDataBinder;
import org.springframework.web.bind.support.BindParamNameResolver;
import org.springframework.web.bind.support.WebBindingInitializer;
import org.springframework.web.bind.support.WebExchangeDataBinder;
import org.springframework.web.server.ServerWebExchange;

public class BindingContext {
    @Nullable
    private final WebBindingInitializer initializer;
    private final Model model = new BindingAwareConcurrentModel();
    private boolean methodValidationApplicable;
    private final ReactiveAdapterRegistry reactiveAdapterRegistry;

    public BindingContext() {
        this(null);
    }

    public BindingContext(@Nullable WebBindingInitializer initializer) {
        this(initializer, ReactiveAdapterRegistry.getSharedInstance());
    }

    public BindingContext(@Nullable WebBindingInitializer initializer, ReactiveAdapterRegistry registry) {
        this.initializer = initializer;
        this.reactiveAdapterRegistry = registry;
    }

    public Model getModel() {
        return this.model;
    }

    public void setMethodValidationApplicable(boolean methodValidationApplicable) {
        this.methodValidationApplicable = methodValidationApplicable;
    }

    public WebExchangeDataBinder createDataBinder(ServerWebExchange exchange2, @Nullable Object target, String name) {
        return this.createDataBinder(exchange2, target, name, null);
    }

    public WebExchangeDataBinder createDataBinder(ServerWebExchange exchange2, String name) {
        return this.createDataBinder(exchange2, null, name, null);
    }

    public WebExchangeDataBinder createDataBinder(ServerWebExchange exchange2, @Nullable Object target, String name, @Nullable ResolvableType targetType) {
        Object object;
        WebExchangeDataBinder dataBinder = this.createBinderInstance(target, name);
        dataBinder.setNameResolver((DataBinder.NameResolver)new BindParamNameResolver());
        if (target == null && targetType != null) {
            dataBinder.setTargetType(targetType);
        }
        if (this.initializer != null) {
            this.initializer.initBinder((WebDataBinder)dataBinder);
        }
        dataBinder = this.initDataBinder(dataBinder, exchange2);
        if (this.methodValidationApplicable && targetType != null && (object = targetType.getSource()) instanceof MethodParameter) {
            MethodParameter parameter = (MethodParameter)object;
            MethodValidationInitializer.initBinder((DataBinder)dataBinder, parameter);
        }
        return dataBinder;
    }

    protected WebExchangeDataBinder createBinderInstance(@Nullable Object target, String name) {
        return new WebExchangeDataBinder(target, name);
    }

    protected WebExchangeDataBinder initDataBinder(WebExchangeDataBinder binder, ServerWebExchange exchange2) {
        return binder;
    }

    public void updateModel(ServerWebExchange exchange2) {
        Map model = this.getModel().asMap();
        for (Map.Entry entry : model.entrySet()) {
            Object value;
            String name = (String)entry.getKey();
            if (!this.isBindingCandidate(name, value = entry.getValue()) || model.containsKey(BindingResult.MODEL_KEY_PREFIX + name)) continue;
            WebExchangeDataBinder binder = this.createDataBinder(exchange2, value, name);
            model.put(BindingResult.MODEL_KEY_PREFIX + name, binder.getBindingResult());
        }
    }

    private boolean isBindingCandidate(String name, @Nullable Object value) {
        return !name.startsWith(BindingResult.MODEL_KEY_PREFIX) && value != null && !value.getClass().isArray() && !(value instanceof Collection) && !(value instanceof Map) && this.reactiveAdapterRegistry.getAdapter(null, value) == null && !BeanUtils.isSimpleValueType(value.getClass());
    }

    private static class MethodValidationInitializer {
        private MethodValidationInitializer() {
        }

        public static void initBinder(DataBinder binder, MethodParameter parameter) {
            if (ReactiveAdapterRegistry.getSharedInstance().getAdapter(parameter.getParameterType()) == null) {
                for (Annotation annotation : parameter.getParameterAnnotations()) {
                    if (!annotation.annotationType().getName().equals("jakarta.validation.Valid")) continue;
                    binder.setExcludedValidators(v -> {
                        SmartValidator sv;
                        return v instanceof Validator || v instanceof SmartValidator && (sv = (SmartValidator)v).unwrap(Validator.class) != null;
                    });
                }
            }
        }
    }
}

