/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.saml2.provider.service.authentication;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.xml.namespace.QName;
import net.shibboleth.utilities.java.support.xml.ParserPool;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.opensaml.core.config.ConfigurationService;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.config.XMLObjectProviderRegistry;
import org.opensaml.core.xml.schema.XSAny;
import org.opensaml.core.xml.schema.XSBoolean;
import org.opensaml.core.xml.schema.XSBooleanValue;
import org.opensaml.core.xml.schema.XSDateTime;
import org.opensaml.core.xml.schema.XSInteger;
import org.opensaml.core.xml.schema.XSString;
import org.opensaml.core.xml.schema.XSURI;
import org.opensaml.saml.common.assertion.ValidationContext;
import org.opensaml.saml.common.assertion.ValidationResult;
import org.opensaml.saml.saml2.assertion.ConditionValidator;
import org.opensaml.saml.saml2.assertion.SAML20AssertionValidator;
import org.opensaml.saml.saml2.assertion.StatementValidator;
import org.opensaml.saml.saml2.assertion.SubjectConfirmationValidator;
import org.opensaml.saml.saml2.assertion.impl.AudienceRestrictionConditionValidator;
import org.opensaml.saml.saml2.assertion.impl.BearerSubjectConfirmationValidator;
import org.opensaml.saml.saml2.assertion.impl.DelegationRestrictionConditionValidator;
import org.opensaml.saml.saml2.assertion.impl.ProxyRestrictionConditionValidator;
import org.opensaml.saml.saml2.core.Assertion;
import org.opensaml.saml.saml2.core.Attribute;
import org.opensaml.saml.saml2.core.AttributeStatement;
import org.opensaml.saml.saml2.core.AuthnRequest;
import org.opensaml.saml.saml2.core.AuthnStatement;
import org.opensaml.saml.saml2.core.Condition;
import org.opensaml.saml.saml2.core.OneTimeUse;
import org.opensaml.saml.saml2.core.Response;
import org.opensaml.saml.saml2.core.StatusCode;
import org.opensaml.saml.saml2.core.StatusResponseType;
import org.opensaml.saml.saml2.core.SubjectConfirmation;
import org.opensaml.saml.saml2.core.SubjectConfirmationData;
import org.opensaml.saml.saml2.core.impl.AuthnRequestUnmarshaller;
import org.opensaml.saml.saml2.core.impl.ResponseUnmarshaller;
import org.opensaml.saml.security.impl.SAMLSignatureProfileValidator;
import org.opensaml.xmlsec.signature.support.SignaturePrevalidator;
import org.opensaml.xmlsec.signature.support.SignatureTrustEngine;
import org.springframework.core.convert.converter.Converter;
import org.springframework.core.log.LogMessage;
import org.springframework.security.authentication.AbstractAuthenticationToken;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.authority.AuthorityUtils;
import org.springframework.security.saml2.Saml2Exception;
import org.springframework.security.saml2.core.OpenSamlInitializationService;
import org.springframework.security.saml2.core.Saml2Error;
import org.springframework.security.saml2.core.Saml2ResponseValidatorResult;
import org.springframework.security.saml2.provider.service.authentication.AbstractSaml2AuthenticationRequest;
import org.springframework.security.saml2.provider.service.authentication.DefaultSaml2AuthenticatedPrincipal;
import org.springframework.security.saml2.provider.service.authentication.OpenSamlDecryptionUtils;
import org.springframework.security.saml2.provider.service.authentication.OpenSamlVerificationUtils;
import org.springframework.security.saml2.provider.service.authentication.Saml2Authentication;
import org.springframework.security.saml2.provider.service.authentication.Saml2AuthenticationException;
import org.springframework.security.saml2.provider.service.authentication.Saml2AuthenticationToken;
import org.springframework.security.saml2.provider.service.registration.RelyingPartyRegistration;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.StringUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public final class OpenSaml4AuthenticationProvider
implements AuthenticationProvider {
    private final Log logger = LogFactory.getLog(this.getClass());
    private final ResponseUnmarshaller responseUnmarshaller;
    private static final AuthnRequestUnmarshaller authnRequestUnmarshaller;
    private final ParserPool parserPool;
    private final Converter<ResponseToken, Saml2ResponseValidatorResult> responseSignatureValidator = this.createDefaultResponseSignatureValidator();
    private Consumer<ResponseToken> responseElementsDecrypter = this.createDefaultResponseElementsDecrypter();
    private Converter<ResponseToken, Saml2ResponseValidatorResult> responseValidator = OpenSaml4AuthenticationProvider.createDefaultResponseValidator();
    private final Converter<AssertionToken, Saml2ResponseValidatorResult> assertionSignatureValidator = this.createDefaultAssertionSignatureValidator();
    private Consumer<AssertionToken> assertionElementsDecrypter = this.createDefaultAssertionElementsDecrypter();
    private Converter<AssertionToken, Saml2ResponseValidatorResult> assertionValidator = OpenSaml4AuthenticationProvider.createDefaultAssertionValidator();
    private Converter<ResponseToken, ? extends AbstractAuthenticationToken> responseAuthenticationConverter = OpenSaml4AuthenticationProvider.createDefaultResponseAuthenticationConverter();
    private static final Set<String> includeChildStatusCodes;

    public OpenSaml4AuthenticationProvider() {
        XMLObjectProviderRegistry registry = (XMLObjectProviderRegistry)ConfigurationService.get(XMLObjectProviderRegistry.class);
        this.responseUnmarshaller = (ResponseUnmarshaller)registry.getUnmarshallerFactory().getUnmarshaller(Response.DEFAULT_ELEMENT_NAME);
        this.parserPool = registry.getParserPool();
    }

    public void setResponseElementsDecrypter(Consumer<ResponseToken> responseElementsDecrypter) {
        Assert.notNull(responseElementsDecrypter, (String)"responseElementsDecrypter cannot be null");
        this.responseElementsDecrypter = responseElementsDecrypter;
    }

    public void setResponseValidator(Converter<ResponseToken, Saml2ResponseValidatorResult> responseValidator) {
        Assert.notNull(responseValidator, (String)"responseValidator cannot be null");
        this.responseValidator = responseValidator;
    }

    public void setAssertionValidator(Converter<AssertionToken, Saml2ResponseValidatorResult> assertionValidator) {
        Assert.notNull(assertionValidator, (String)"assertionValidator cannot be null");
        this.assertionValidator = assertionValidator;
    }

    public void setAssertionElementsDecrypter(Consumer<AssertionToken> assertionDecrypter) {
        Assert.notNull(assertionDecrypter, (String)"assertionDecrypter cannot be null");
        this.assertionElementsDecrypter = assertionDecrypter;
    }

    public void setResponseAuthenticationConverter(Converter<ResponseToken, ? extends AbstractAuthenticationToken> responseAuthenticationConverter) {
        Assert.notNull(responseAuthenticationConverter, (String)"responseAuthenticationConverter cannot be null");
        this.responseAuthenticationConverter = responseAuthenticationConverter;
    }

    public static Converter<ResponseToken, Saml2ResponseValidatorResult> createDefaultResponseValidator() {
        return responseToken -> {
            Response response = responseToken.getResponse();
            Saml2AuthenticationToken token = responseToken.getToken();
            Saml2ResponseValidatorResult result = Saml2ResponseValidatorResult.success();
            List<String> statusCodes = OpenSaml4AuthenticationProvider.getStatusCodes(response);
            if (!OpenSaml4AuthenticationProvider.isSuccess(statusCodes)) {
                for (String statusCode : statusCodes) {
                    String message = String.format("Invalid status [%s] for SAML response [%s]", statusCode, response.getID());
                    result = result.concat(new Saml2Error("invalid_response", message));
                }
            }
            String inResponseTo = response.getInResponseTo();
            result = result.concat(OpenSaml4AuthenticationProvider.validateInResponseTo(token.getAuthenticationRequest(), inResponseTo));
            String issuer = response.getIssuer().getValue();
            String destination = response.getDestination();
            String location = token.getRelyingPartyRegistration().getAssertionConsumerServiceLocation();
            if (StringUtils.hasText((String)destination) && !destination.equals(location)) {
                String message = "Invalid destination [" + destination + "] for SAML response [" + response.getID() + "]";
                result = result.concat(new Saml2Error("invalid_destination", message));
            }
            String assertingPartyEntityId = token.getRelyingPartyRegistration().getAssertingPartyDetails().getEntityId();
            if (!StringUtils.hasText((String)issuer) || !issuer.equals(assertingPartyEntityId)) {
                String message = String.format("Invalid issuer [%s] for SAML response [%s]", issuer, response.getID());
                result = result.concat(new Saml2Error("invalid_issuer", message));
            }
            if (response.getAssertions().isEmpty()) {
                result = result.concat(new Saml2Error("malformed_response_data", "No assertions found in response."));
            }
            return result;
        };
    }

    private static List<String> getStatusCodes(Response response) {
        if (response.getStatus() == null) {
            return List.of("urn:oasis:names:tc:SAML:2.0:status:Success");
        }
        if (response.getStatus().getStatusCode() == null) {
            return List.of("urn:oasis:names:tc:SAML:2.0:status:Success");
        }
        StatusCode parentStatusCode = response.getStatus().getStatusCode();
        String parentStatusCodeValue = parentStatusCode.getValue();
        if (!includeChildStatusCodes.contains(parentStatusCodeValue)) {
            return List.of(parentStatusCodeValue);
        }
        StatusCode childStatusCode = parentStatusCode.getStatusCode();
        if (childStatusCode == null) {
            return List.of(parentStatusCodeValue);
        }
        String childStatusCodeValue = childStatusCode.getValue();
        if (childStatusCodeValue == null) {
            return List.of(parentStatusCodeValue);
        }
        return List.of(parentStatusCodeValue, childStatusCodeValue);
    }

    private static boolean isSuccess(List<String> statusCodes) {
        if (statusCodes.size() != 1) {
            return false;
        }
        String statusCode = statusCodes.get(0);
        return "urn:oasis:names:tc:SAML:2.0:status:Success".equals(statusCode);
    }

    private static Saml2ResponseValidatorResult validateInResponseTo(AbstractSaml2AuthenticationRequest storedRequest, String inResponseTo) {
        if (!StringUtils.hasText((String)inResponseTo)) {
            return Saml2ResponseValidatorResult.success();
        }
        if (storedRequest == null) {
            String message = "The response contained an InResponseTo attribute [" + inResponseTo + "] but no saved authentication request was found";
            return Saml2ResponseValidatorResult.failure(new Saml2Error("invalid_in_response_to", message));
        }
        if (!inResponseTo.equals(storedRequest.getId())) {
            String message = "The InResponseTo attribute [" + inResponseTo + "] does not match the ID of the authentication request [" + storedRequest.getId() + "]";
            return Saml2ResponseValidatorResult.failure(new Saml2Error("invalid_in_response_to", message));
        }
        return Saml2ResponseValidatorResult.success();
    }

    public static Converter<AssertionToken, Saml2ResponseValidatorResult> createDefaultAssertionValidator() {
        return OpenSaml4AuthenticationProvider.createDefaultAssertionValidatorWithParameters(params -> params.put("saml2.ClockSkew", Duration.ofMinutes(5L)));
    }

    @Deprecated
    public static Converter<AssertionToken, Saml2ResponseValidatorResult> createDefaultAssertionValidator(Converter<AssertionToken, ValidationContext> contextConverter) {
        return OpenSaml4AuthenticationProvider.createAssertionValidator("invalid_assertion", (Converter<AssertionToken, SAML20AssertionValidator>)((Converter)assertionToken -> SAML20AssertionValidators.attributeValidator), contextConverter);
    }

    public static Converter<AssertionToken, Saml2ResponseValidatorResult> createDefaultAssertionValidatorWithParameters(Consumer<Map<String, Object>> validationContextParameters) {
        return OpenSaml4AuthenticationProvider.createAssertionValidator("invalid_assertion", (Converter<AssertionToken, SAML20AssertionValidator>)((Converter)assertionToken -> SAML20AssertionValidators.attributeValidator), (Converter<AssertionToken, ValidationContext>)((Converter)assertionToken -> OpenSaml4AuthenticationProvider.createValidationContext(assertionToken, validationContextParameters)));
    }

    public static Converter<ResponseToken, Saml2Authentication> createDefaultResponseAuthenticationConverter() {
        return responseToken -> {
            Response response = responseToken.response;
            Saml2AuthenticationToken token = responseToken.token;
            Assertion assertion = (Assertion)CollectionUtils.firstElement((List)response.getAssertions());
            String username = assertion.getSubject().getNameID().getValue();
            Map<String, List<Object>> attributes = OpenSaml4AuthenticationProvider.getAssertionAttributes(assertion);
            List<String> sessionIndexes = OpenSaml4AuthenticationProvider.getSessionIndexes(assertion);
            DefaultSaml2AuthenticatedPrincipal principal = new DefaultSaml2AuthenticatedPrincipal(username, attributes, sessionIndexes);
            String registrationId = responseToken.token.getRelyingPartyRegistration().getRegistrationId();
            principal.setRelyingPartyRegistrationId(registrationId);
            return new Saml2Authentication(principal, token.getSaml2Response(), AuthorityUtils.createAuthorityList((String[])new String[]{"ROLE_USER"}));
        };
    }

    public Authentication authenticate(Authentication authentication) throws AuthenticationException {
        try {
            Saml2AuthenticationToken token = (Saml2AuthenticationToken)authentication;
            String serializedResponse = token.getSaml2Response();
            Response response = this.parseResponse(serializedResponse);
            this.process(token, response);
            AbstractAuthenticationToken authenticationResponse = (AbstractAuthenticationToken)this.responseAuthenticationConverter.convert((Object)new ResponseToken(response, token));
            if (authenticationResponse != null) {
                authenticationResponse.setDetails(authentication.getDetails());
            }
            return authenticationResponse;
        }
        catch (Saml2AuthenticationException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw OpenSaml4AuthenticationProvider.createAuthenticationException("internal_validation_error", ex.getMessage(), ex);
        }
    }

    public boolean supports(Class<?> authentication) {
        return authentication != null && Saml2AuthenticationToken.class.isAssignableFrom(authentication);
    }

    private Response parseResponse(String response) throws Saml2Exception, Saml2AuthenticationException {
        try {
            Document document = this.parserPool.parse((InputStream)new ByteArrayInputStream(response.getBytes(StandardCharsets.UTF_8)));
            Element element = document.getDocumentElement();
            return (Response)this.responseUnmarshaller.unmarshall(element);
        }
        catch (Exception ex) {
            throw OpenSaml4AuthenticationProvider.createAuthenticationException("malformed_response_data", ex.getMessage(), ex);
        }
    }

    private void process(Saml2AuthenticationToken token, Response response) {
        Assertion firstAssertion;
        String issuer = response.getIssuer().getValue();
        this.logger.debug((Object)LogMessage.format((String)"Processing SAML response from %s", (Object)issuer));
        boolean responseSigned = response.isSigned();
        ResponseToken responseToken = new ResponseToken(response, token);
        Saml2ResponseValidatorResult result = (Saml2ResponseValidatorResult)this.responseSignatureValidator.convert((Object)responseToken);
        if (responseSigned) {
            this.responseElementsDecrypter.accept(responseToken);
        } else if (!response.getEncryptedAssertions().isEmpty()) {
            result = result.concat(new Saml2Error("invalid_signature", "Did not decrypt response [" + response.getID() + "] since it is not signed"));
        }
        result = result.concat((Saml2ResponseValidatorResult)this.responseValidator.convert((Object)responseToken));
        boolean allAssertionsSigned = true;
        for (Assertion assertion : response.getAssertions()) {
            AssertionToken assertionToken = new AssertionToken(assertion, token);
            result = result.concat((Saml2ResponseValidatorResult)this.assertionSignatureValidator.convert((Object)assertionToken));
            boolean bl = allAssertionsSigned = allAssertionsSigned && assertion.isSigned();
            if (responseSigned || assertion.isSigned()) {
                this.assertionElementsDecrypter.accept(new AssertionToken(assertion, token));
            }
            result = result.concat((Saml2ResponseValidatorResult)this.assertionValidator.convert((Object)assertionToken));
        }
        if (!responseSigned && !allAssertionsSigned) {
            String description = "Either the response or one of the assertions is unsigned. Please either sign the response or all of the assertions.";
            result = result.concat(new Saml2Error("invalid_signature", description));
        }
        if ((firstAssertion = (Assertion)CollectionUtils.firstElement((List)response.getAssertions())) != null && !this.hasName(firstAssertion)) {
            Saml2Error error = new Saml2Error("subject_not_found", "Assertion [" + firstAssertion.getID() + "] is missing a subject");
            result = result.concat(error);
        }
        if (result.hasErrors()) {
            Collection<Saml2Error> errors = result.getErrors();
            if (this.logger.isTraceEnabled()) {
                this.logger.debug((Object)("Found " + errors.size() + " validation errors in SAML response [" + response.getID() + "]: " + errors));
            } else if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Found " + errors.size() + " validation errors in SAML response [" + response.getID() + "]"));
            }
            Saml2Error first = errors.iterator().next();
            throw OpenSaml4AuthenticationProvider.createAuthenticationException(first.getErrorCode(), first.getDescription(), null);
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Successfully processed SAML Response [" + response.getID() + "]"));
        }
    }

    private Converter<ResponseToken, Saml2ResponseValidatorResult> createDefaultResponseSignatureValidator() {
        return responseToken -> {
            Response response = responseToken.getResponse();
            RelyingPartyRegistration registration = responseToken.getToken().getRelyingPartyRegistration();
            if (response.isSigned()) {
                return OpenSamlVerificationUtils.verifySignature((StatusResponseType)response, registration).post(response.getSignature());
            }
            return Saml2ResponseValidatorResult.success();
        };
    }

    private Consumer<ResponseToken> createDefaultResponseElementsDecrypter() {
        return responseToken -> {
            Response response = responseToken.getResponse();
            RelyingPartyRegistration registration = responseToken.getToken().getRelyingPartyRegistration();
            try {
                OpenSamlDecryptionUtils.decryptResponseElements(response, registration);
            }
            catch (Exception ex) {
                throw OpenSaml4AuthenticationProvider.createAuthenticationException("decryption_error", ex.getMessage(), ex);
            }
        };
    }

    private Converter<AssertionToken, Saml2ResponseValidatorResult> createDefaultAssertionSignatureValidator() {
        return OpenSaml4AuthenticationProvider.createAssertionValidator("invalid_signature", (Converter<AssertionToken, SAML20AssertionValidator>)((Converter)assertionToken -> {
            RelyingPartyRegistration registration = assertionToken.getToken().getRelyingPartyRegistration();
            SignatureTrustEngine engine = OpenSamlVerificationUtils.trustEngine(registration);
            return SAML20AssertionValidators.createSignatureValidator(engine);
        }), (Converter<AssertionToken, ValidationContext>)((Converter)assertionToken -> new ValidationContext(Collections.singletonMap("saml2.SignatureRequired", false))));
    }

    private Consumer<AssertionToken> createDefaultAssertionElementsDecrypter() {
        return assertionToken -> {
            Assertion assertion = assertionToken.getAssertion();
            RelyingPartyRegistration registration = assertionToken.getToken().getRelyingPartyRegistration();
            try {
                OpenSamlDecryptionUtils.decryptAssertionElements(assertion, registration);
            }
            catch (Exception ex) {
                throw OpenSaml4AuthenticationProvider.createAuthenticationException("decryption_error", ex.getMessage(), ex);
            }
        };
    }

    private boolean hasName(Assertion assertion) {
        if (assertion == null) {
            return false;
        }
        if (assertion.getSubject() == null) {
            return false;
        }
        if (assertion.getSubject().getNameID() == null) {
            return false;
        }
        return assertion.getSubject().getNameID().getValue() != null;
    }

    private static Map<String, List<Object>> getAssertionAttributes(Assertion assertion) {
        LinkedMultiValueMap attributeMap = new LinkedMultiValueMap();
        for (AttributeStatement attributeStatement : assertion.getAttributeStatements()) {
            for (Attribute attribute : attributeStatement.getAttributes()) {
                ArrayList<Object> attributeValues = new ArrayList<Object>();
                for (XMLObject xmlObject : attribute.getAttributeValues()) {
                    Object attributeValue = OpenSaml4AuthenticationProvider.getXmlObjectValue(xmlObject);
                    if (attributeValue == null) continue;
                    attributeValues.add(attributeValue);
                }
                attributeMap.addAll((Object)attribute.getName(), attributeValues);
            }
        }
        return new LinkedHashMap<String, List<Object>>((Map<String, List<Object>>)attributeMap);
    }

    private static List<String> getSessionIndexes(Assertion assertion) {
        ArrayList<String> sessionIndexes = new ArrayList<String>();
        for (AuthnStatement statement : assertion.getAuthnStatements()) {
            sessionIndexes.add(statement.getSessionIndex());
        }
        return sessionIndexes;
    }

    private static Object getXmlObjectValue(XMLObject xmlObject) {
        if (xmlObject instanceof XSAny) {
            return ((XSAny)xmlObject).getTextContent();
        }
        if (xmlObject instanceof XSString) {
            return ((XSString)xmlObject).getValue();
        }
        if (xmlObject instanceof XSInteger) {
            return ((XSInteger)xmlObject).getValue();
        }
        if (xmlObject instanceof XSURI) {
            return ((XSURI)xmlObject).getURI();
        }
        if (xmlObject instanceof XSBoolean) {
            XSBooleanValue xsBooleanValue = ((XSBoolean)xmlObject).getValue();
            return xsBooleanValue != null ? xsBooleanValue.getValue() : null;
        }
        if (xmlObject instanceof XSDateTime) {
            return ((XSDateTime)xmlObject).getValue();
        }
        return xmlObject;
    }

    private static Saml2AuthenticationException createAuthenticationException(String code, String message, Exception cause) {
        return new Saml2AuthenticationException(new Saml2Error(code, message), cause);
    }

    private static Converter<AssertionToken, Saml2ResponseValidatorResult> createAssertionValidator(String errorCode, Converter<AssertionToken, SAML20AssertionValidator> validatorConverter, Converter<AssertionToken, ValidationContext> contextConverter) {
        return assertionToken -> {
            Assertion assertion = assertionToken.assertion;
            SAML20AssertionValidator validator = (SAML20AssertionValidator)validatorConverter.convert(assertionToken);
            ValidationContext context = (ValidationContext)contextConverter.convert(assertionToken);
            try {
                ValidationResult result = validator.validate(assertion, context);
                if (result == ValidationResult.VALID) {
                    return Saml2ResponseValidatorResult.success();
                }
            }
            catch (Exception ex) {
                String message = String.format("Invalid assertion [%s] for SAML response [%s]: %s", assertion.getID(), ((Response)assertion.getParent()).getID(), ex.getMessage());
                return Saml2ResponseValidatorResult.failure(new Saml2Error(errorCode, message));
            }
            String message = String.format("Invalid assertion [%s] for SAML response [%s]: %s", assertion.getID(), ((Response)assertion.getParent()).getID(), context.getValidationFailureMessage());
            return Saml2ResponseValidatorResult.failure(new Saml2Error(errorCode, message));
        };
    }

    private static ValidationContext createValidationContext(AssertionToken assertionToken, Consumer<Map<String, Object>> paramsConsumer) {
        Saml2AuthenticationToken token = assertionToken.token;
        RelyingPartyRegistration relyingPartyRegistration = token.getRelyingPartyRegistration();
        String audience = relyingPartyRegistration.getEntityId();
        String recipient = relyingPartyRegistration.getAssertionConsumerServiceLocation();
        String assertingPartyEntityId = relyingPartyRegistration.getAssertingPartyDetails().getEntityId();
        HashMap<String, Object> params = new HashMap<String, Object>();
        Assertion assertion = assertionToken.getAssertion();
        if (OpenSaml4AuthenticationProvider.assertionContainsInResponseTo(assertion)) {
            String requestId = OpenSaml4AuthenticationProvider.getAuthnRequestId(token.getAuthenticationRequest());
            params.put("saml2.SubjectConfirmation.ValidInResponseTo", requestId);
        }
        params.put("saml2.Conditions.ValidAudiences", Collections.singleton(audience));
        params.put("saml2.SubjectConfirmation.ValidRecipients", Collections.singleton(recipient));
        params.put("saml2.ValidIssuers", Collections.singleton(assertingPartyEntityId));
        paramsConsumer.accept(params);
        return new ValidationContext(params);
    }

    private static boolean assertionContainsInResponseTo(Assertion assertion) {
        if (assertion.getSubject() == null) {
            return false;
        }
        for (SubjectConfirmation confirmation : assertion.getSubject().getSubjectConfirmations()) {
            SubjectConfirmationData confirmationData = confirmation.getSubjectConfirmationData();
            if (confirmationData == null || !StringUtils.hasText((String)confirmationData.getInResponseTo())) continue;
            return true;
        }
        return false;
    }

    private static String getAuthnRequestId(AbstractSaml2AuthenticationRequest serialized) {
        return serialized != null ? serialized.getId() : null;
    }

    static {
        OpenSamlInitializationService.initialize();
        XMLObjectProviderRegistry registry = (XMLObjectProviderRegistry)ConfigurationService.get(XMLObjectProviderRegistry.class);
        authnRequestUnmarshaller = (AuthnRequestUnmarshaller)registry.getUnmarshallerFactory().getUnmarshaller(AuthnRequest.DEFAULT_ELEMENT_NAME);
        includeChildStatusCodes = new HashSet<String>(Arrays.asList("urn:oasis:names:tc:SAML:2.0:status:Requester", "urn:oasis:names:tc:SAML:2.0:status:Responder", "urn:oasis:names:tc:SAML:2.0:status:VersionMismatch"));
    }

    public static class ResponseToken {
        private final Saml2AuthenticationToken token;
        private final Response response;

        ResponseToken(Response response, Saml2AuthenticationToken token) {
            this.token = token;
            this.response = response;
        }

        public Response getResponse() {
            return this.response;
        }

        public Saml2AuthenticationToken getToken() {
            return this.token;
        }
    }

    public static class AssertionToken {
        private final Saml2AuthenticationToken token;
        private final Assertion assertion;

        AssertionToken(Assertion assertion, Saml2AuthenticationToken token) {
            this.token = token;
            this.assertion = assertion;
        }

        public Assertion getAssertion() {
            return this.assertion;
        }

        public Saml2AuthenticationToken getToken() {
            return this.token;
        }
    }

    private static class SAML20AssertionValidators {
        private static final Collection<ConditionValidator> conditions = new ArrayList<ConditionValidator>();
        private static final Collection<SubjectConfirmationValidator> subjects = new ArrayList<SubjectConfirmationValidator>();
        private static final Collection<StatementValidator> statements = new ArrayList<StatementValidator>();
        private static final SignaturePrevalidator validator = new SAMLSignatureProfileValidator();
        private static final SAML20AssertionValidator attributeValidator;

        private SAML20AssertionValidators() {
        }

        static SAML20AssertionValidator createSignatureValidator(SignatureTrustEngine engine) {
            return new SAML20AssertionValidator(new ArrayList(), new ArrayList(), new ArrayList(), null, engine, validator){

                @Nonnull
                protected ValidationResult validateConditions(Assertion assertion, ValidationContext context) {
                    return ValidationResult.VALID;
                }

                @Nonnull
                protected ValidationResult validateSubjectConfirmation(Assertion assertion, ValidationContext context) {
                    return ValidationResult.VALID;
                }

                @Nonnull
                protected ValidationResult validateStatements(Assertion assertion, ValidationContext context) {
                    return ValidationResult.VALID;
                }

                protected ValidationResult validateIssuer(Assertion assertion, ValidationContext context) {
                    return ValidationResult.VALID;
                }
            };
        }

        static {
            conditions.add((ConditionValidator)new AudienceRestrictionConditionValidator());
            conditions.add((ConditionValidator)new DelegationRestrictionConditionValidator());
            conditions.add(new ConditionValidator(){

                @Nonnull
                public QName getServicedCondition() {
                    return OneTimeUse.DEFAULT_ELEMENT_NAME;
                }

                @Nonnull
                public ValidationResult validate(Condition condition, Assertion assertion, ValidationContext context) {
                    return ValidationResult.VALID;
                }
            });
            conditions.add((ConditionValidator)new ProxyRestrictionConditionValidator());
            subjects.add((SubjectConfirmationValidator)new BearerSubjectConfirmationValidator(){

                protected ValidationResult validateAddress(SubjectConfirmation confirmation, Assertion assertion, ValidationContext context, boolean required) {
                    return ValidationResult.VALID;
                }
            });
            attributeValidator = new SAML20AssertionValidator(conditions, subjects, statements, null, null, null){

                @Nonnull
                protected ValidationResult validateSignature(Assertion token, ValidationContext context) {
                    return ValidationResult.VALID;
                }
            };
        }
    }
}

