/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.server.resource.web.authentication;

import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.core.log.LogMessage;
import org.springframework.security.authentication.AuthenticationDetailsSource;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.AuthenticationManagerResolver;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.context.SecurityContextHolderStrategy;
import org.springframework.security.oauth2.core.ClaimAccessor;
import org.springframework.security.oauth2.core.OAuth2AuthenticationException;
import org.springframework.security.oauth2.core.OAuth2Error;
import org.springframework.security.oauth2.server.resource.BearerTokenError;
import org.springframework.security.oauth2.server.resource.BearerTokenErrors;
import org.springframework.security.oauth2.server.resource.authentication.AbstractOAuth2TokenAuthenticationToken;
import org.springframework.security.oauth2.server.resource.web.BearerTokenAuthenticationEntryPoint;
import org.springframework.security.oauth2.server.resource.web.BearerTokenResolver;
import org.springframework.security.oauth2.server.resource.web.authentication.BearerTokenAuthenticationConverter;
import org.springframework.security.web.AuthenticationEntryPoint;
import org.springframework.security.web.authentication.AuthenticationConverter;
import org.springframework.security.web.authentication.AuthenticationEntryPointFailureHandler;
import org.springframework.security.web.authentication.AuthenticationFailureHandler;
import org.springframework.security.web.context.RequestAttributeSecurityContextRepository;
import org.springframework.security.web.context.SecurityContextRepository;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.filter.OncePerRequestFilter;

public class BearerTokenAuthenticationFilter
extends OncePerRequestFilter {
    private final AuthenticationManagerResolver<HttpServletRequest> authenticationManagerResolver;
    private final AuthenticationConverter authenticationConverter;
    private SecurityContextHolderStrategy securityContextHolderStrategy = SecurityContextHolder.getContextHolderStrategy();
    private AuthenticationEntryPoint authenticationEntryPoint = new BearerTokenAuthenticationEntryPoint();
    private AuthenticationFailureHandler authenticationFailureHandler = new AuthenticationEntryPointFailureHandler((request, response, exception) -> this.authenticationEntryPoint.commence(request, response, exception));
    private SecurityContextRepository securityContextRepository = new RequestAttributeSecurityContextRepository();

    public BearerTokenAuthenticationFilter(AuthenticationManagerResolver<HttpServletRequest> authenticationManagerResolver) {
        this(authenticationManagerResolver, (AuthenticationConverter)new BearerTokenAuthenticationConverter());
    }

    public BearerTokenAuthenticationFilter(AuthenticationManager authenticationManager) {
        this(authenticationManager, (AuthenticationConverter)new BearerTokenAuthenticationConverter());
    }

    public BearerTokenAuthenticationFilter(AuthenticationManager authenticationManager, AuthenticationConverter authenticationConverter) {
        Assert.notNull((Object)authenticationManager, (String)"authenticationManager cannot be null");
        Assert.notNull((Object)authenticationConverter, (String)"authenticationConverter cannot be null");
        this.authenticationManagerResolver = authentication -> authenticationManager;
        this.authenticationConverter = authenticationConverter;
    }

    public BearerTokenAuthenticationFilter(AuthenticationManagerResolver<HttpServletRequest> authenticationManagerResolver, AuthenticationConverter authenticationConverter) {
        Assert.notNull(authenticationManagerResolver, (String)"authenticationManagerResolver cannot be null");
        Assert.notNull((Object)authenticationConverter, (String)"authenticationConverter cannot be null");
        this.authenticationManagerResolver = authenticationManagerResolver;
        this.authenticationConverter = authenticationConverter;
    }

    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        Authentication authenticationRequest;
        try {
            authenticationRequest = this.authenticationConverter.convert(request);
        }
        catch (OAuth2AuthenticationException invalid) {
            this.logger.trace((Object)"Sending to authentication entry point since failed to resolve bearer token", (Throwable)invalid);
            this.authenticationEntryPoint.commence(request, response, (AuthenticationException)((Object)invalid));
            return;
        }
        if (authenticationRequest == null) {
            this.logger.trace((Object)"Did not process request since did not find bearer token");
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
            return;
        }
        try {
            AuthenticationManager authenticationManager = this.authenticationManagerResolver.resolve((Object)request);
            Authentication authenticationResult = authenticationManager.authenticate(authenticationRequest);
            if (BearerTokenAuthenticationFilter.isDPoPBoundAccessToken(authenticationResult)) {
                BearerTokenError error = BearerTokenErrors.invalidToken("Invalid bearer token");
                throw new OAuth2AuthenticationException((OAuth2Error)error);
            }
            Authentication current = this.securityContextHolderStrategy.getContext().getAuthentication();
            if (current != null && current.isAuthenticated() && BearerTokenAuthenticationFilter.declaresToBuilder(authenticationResult)) {
                authenticationResult = authenticationResult.toBuilder().authorities(a -> {
                    Set newAuthorities = a.stream().map(GrantedAuthority::getAuthority).collect(Collectors.toUnmodifiableSet());
                    for (GrantedAuthority currentAuthority : current.getAuthorities()) {
                        if (newAuthorities.contains(currentAuthority.getAuthority())) continue;
                        a.add(currentAuthority);
                    }
                }).build();
            }
            SecurityContext context = this.securityContextHolderStrategy.createEmptyContext();
            context.setAuthentication(authenticationResult);
            this.securityContextHolderStrategy.setContext(context);
            this.securityContextRepository.saveContext(context, request, response);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)LogMessage.format((String)"Set SecurityContextHolder to %s", (Object)authenticationResult));
            }
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
        }
        catch (AuthenticationException failed) {
            this.securityContextHolderStrategy.clearContext();
            this.logger.trace((Object)"Failed to process authentication request", (Throwable)failed);
            this.authenticationFailureHandler.onAuthenticationFailure(request, response, failed);
        }
    }

    private static boolean declaresToBuilder(Authentication authentication) {
        for (Method method : authentication.getClass().getDeclaredMethods()) {
            if (!method.getName().equals("toBuilder") || method.getParameterTypes().length != 0) continue;
            return true;
        }
        return false;
    }

    public void setSecurityContextHolderStrategy(SecurityContextHolderStrategy securityContextHolderStrategy) {
        Assert.notNull((Object)securityContextHolderStrategy, (String)"securityContextHolderStrategy cannot be null");
        this.securityContextHolderStrategy = securityContextHolderStrategy;
    }

    public void setSecurityContextRepository(SecurityContextRepository securityContextRepository) {
        Assert.notNull((Object)securityContextRepository, (String)"securityContextRepository cannot be null");
        this.securityContextRepository = securityContextRepository;
    }

    @Deprecated
    public void setBearerTokenResolver(BearerTokenResolver bearerTokenResolver) {
        Assert.notNull((Object)bearerTokenResolver, (String)"bearerTokenResolver cannot be null");
        AuthenticationConverter authenticationConverter = this.authenticationConverter;
        if (!(authenticationConverter instanceof BearerTokenAuthenticationConverter)) {
            throw new IllegalArgumentException("You cannot both specify an AuthenticationConverter and a BearerTokenResolver.");
        }
        BearerTokenAuthenticationConverter converter = (BearerTokenAuthenticationConverter)authenticationConverter;
        converter.setBearerTokenResolver(bearerTokenResolver);
    }

    public void setAuthenticationEntryPoint(AuthenticationEntryPoint authenticationEntryPoint) {
        Assert.notNull((Object)authenticationEntryPoint, (String)"authenticationEntryPoint cannot be null");
        this.authenticationEntryPoint = authenticationEntryPoint;
    }

    public void setAuthenticationFailureHandler(AuthenticationFailureHandler authenticationFailureHandler) {
        Assert.notNull((Object)authenticationFailureHandler, (String)"authenticationFailureHandler cannot be null");
        this.authenticationFailureHandler = authenticationFailureHandler;
    }

    @Deprecated
    public void setAuthenticationDetailsSource(AuthenticationDetailsSource<HttpServletRequest, ?> authenticationDetailsSource) {
        Assert.notNull(authenticationDetailsSource, (String)"authenticationDetailsSource cannot be null");
        AuthenticationConverter authenticationConverter = this.authenticationConverter;
        if (!(authenticationConverter instanceof BearerTokenAuthenticationConverter)) {
            throw new IllegalArgumentException("You cannot specify both an AuthenticationConverter and an AuthenticationDetailsSource");
        }
        BearerTokenAuthenticationConverter converter = (BearerTokenAuthenticationConverter)authenticationConverter;
        converter.setAuthenticationDetailsSource(authenticationDetailsSource);
    }

    private static boolean isDPoPBoundAccessToken(Authentication authentication) {
        if (!(authentication instanceof AbstractOAuth2TokenAuthenticationToken)) {
            return false;
        }
        AbstractOAuth2TokenAuthenticationToken accessTokenAuthentication = (AbstractOAuth2TokenAuthenticationToken)authentication;
        ClaimAccessor accessTokenClaims = accessTokenAuthentication::getTokenAttributes;
        String jwkThumbprintClaim = null;
        Map confirmationMethodClaim = accessTokenClaims.getClaimAsMap("cnf");
        if (!CollectionUtils.isEmpty((Map)confirmationMethodClaim) && confirmationMethodClaim.containsKey("jkt")) {
            jwkThumbprintClaim = (String)confirmationMethodClaim.get("jkt");
        }
        return StringUtils.hasText(jwkThumbprintClaim);
    }
}

