/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.jwt;

import com.nimbusds.jose.Algorithm;
import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.crypto.impl.ECDSA;
import com.nimbusds.jose.jwk.Curve;
import com.nimbusds.jose.jwk.ECKey;
import com.nimbusds.jose.jwk.KeyOperation;
import com.nimbusds.jose.jwk.KeyUse;
import com.nimbusds.jose.jwk.OctetSequenceKey;
import com.nimbusds.jose.jwk.RSAKey;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.ECPublicKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.ECParameterSpec;
import java.util.Date;
import java.util.Set;
import javax.crypto.SecretKey;

final class JWKS {
    private JWKS() {
    }

    static OctetSequenceKey.Builder signing(SecretKey key) throws JOSEException {
        Date issued = new Date();
        return new OctetSequenceKey.Builder(key).keyOperations(Set.of(KeyOperation.SIGN)).keyUse(KeyUse.SIGNATURE).algorithm((Algorithm)JWSAlgorithm.HS256).keyIDFromThumbprint().issueTime(issued).notBeforeTime(issued);
    }

    static ECKey.Builder signingWithEc(ECPublicKey pub, ECPrivateKey key) throws JOSEException {
        Date issued = new Date();
        Curve curve = Curve.forECParameterSpec((ECParameterSpec)pub.getParams());
        JWSAlgorithm algorithm = JWKS.computeAlgorithm(curve);
        return new ECKey.Builder(curve, pub).privateKey(key).keyOperations(Set.of(KeyOperation.SIGN)).keyUse(KeyUse.SIGNATURE).algorithm((Algorithm)algorithm).keyIDFromThumbprint().issueTime(issued).notBeforeTime(issued);
    }

    private static JWSAlgorithm computeAlgorithm(Curve curve) {
        try {
            return ECDSA.resolveAlgorithm((Curve)curve);
        }
        catch (JOSEException ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    static RSAKey.Builder signingWithRsa(RSAPublicKey pub, RSAPrivateKey key) throws JOSEException {
        Date issued = new Date();
        return new RSAKey.Builder(pub).privateKey(key).keyUse(KeyUse.SIGNATURE).keyOperations(Set.of(KeyOperation.SIGN)).algorithm((Algorithm)JWSAlgorithm.RS256).keyIDFromThumbprint().issueTime(issued).notBeforeTime(issued);
    }
}

