/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.config.http;

import jakarta.servlet.http.HttpServletRequest;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeanMetadataElement;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanReference;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.parsing.BeanComponentDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.beans.factory.support.ManagedMap;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.security.authentication.AnonymousAuthenticationProvider;
import org.springframework.security.authentication.RememberMeAuthenticationProvider;
import org.springframework.security.config.http.FormLoginBeanDefinitionParser;
import org.springframework.security.config.http.LogoutBeanDefinitionParser;
import org.springframework.security.config.http.OAuth2AuthorizedClientManagerRegistrar;
import org.springframework.security.config.http.OAuth2ClientBeanDefinitionParser;
import org.springframework.security.config.http.OAuth2ClientWebMvcSecurityPostProcessor;
import org.springframework.security.config.http.OAuth2LoginBeanDefinitionParser;
import org.springframework.security.config.http.OAuth2ResourceServerBeanDefinitionParser;
import org.springframework.security.config.http.OrderDecorator;
import org.springframework.security.config.http.RememberMeBeanDefinitionParser;
import org.springframework.security.config.http.Saml2LoginBeanDefinitionParser;
import org.springframework.security.config.http.Saml2LogoutBeanDefinitionParser;
import org.springframework.security.config.http.SecurityFilters;
import org.springframework.security.config.http.SessionCreationPolicy;
import org.springframework.security.config.http.UserDetailsServiceFactoryBean;
import org.springframework.security.core.authority.AuthorityUtils;
import org.springframework.security.core.authority.mapping.SimpleAttributes2GrantedAuthoritiesMapper;
import org.springframework.security.core.authority.mapping.SimpleMappableAttributesRetriever;
import org.springframework.security.web.access.AccessDeniedHandlerImpl;
import org.springframework.security.web.access.ExceptionTranslationFilter;
import org.springframework.security.web.access.RequestMatcherDelegatingAccessDeniedHandler;
import org.springframework.security.web.authentication.AnonymousAuthenticationFilter;
import org.springframework.security.web.authentication.DelegatingAuthenticationEntryPoint;
import org.springframework.security.web.authentication.Http403ForbiddenEntryPoint;
import org.springframework.security.web.authentication.logout.SecurityContextLogoutHandler;
import org.springframework.security.web.authentication.preauth.PreAuthenticatedAuthenticationProvider;
import org.springframework.security.web.authentication.preauth.PreAuthenticatedGrantedAuthoritiesUserDetailsService;
import org.springframework.security.web.authentication.preauth.j2ee.J2eeBasedPreAuthenticatedWebAuthenticationDetailsSource;
import org.springframework.security.web.authentication.preauth.j2ee.J2eePreAuthenticatedProcessingFilter;
import org.springframework.security.web.authentication.preauth.x509.SubjectDnX509PrincipalExtractor;
import org.springframework.security.web.authentication.preauth.x509.X509AuthenticationFilter;
import org.springframework.security.web.authentication.ui.DefaultLoginPageGeneratingFilter;
import org.springframework.security.web.authentication.ui.DefaultLogoutPageGeneratingFilter;
import org.springframework.security.web.authentication.ui.DefaultResourcesFilter;
import org.springframework.security.web.authentication.www.BasicAuthenticationEntryPoint;
import org.springframework.security.web.authentication.www.BasicAuthenticationFilter;
import org.springframework.security.web.csrf.CsrfToken;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

final class AuthenticationConfigBuilder {
    private final Log logger = LogFactory.getLog(this.getClass());
    private static final boolean webMvcPresent;
    private static final String ATT_REALM = "realm";
    private static final String DEF_REALM = "Realm";
    static final String AUTHENTICATION_PROCESSING_FILTER_CLASS = "org.springframework.security.web.authentication.UsernamePasswordAuthenticationFilter";
    static final String ATT_AUTH_DETAILS_SOURCE_REF = "authentication-details-source-ref";
    private static final String ATT_AUTO_CONFIG = "auto-config";
    private static final String ATT_ACCESS_DENIED_ERROR_PAGE = "error-page";
    private static final String ATT_ENTRY_POINT_REF = "entry-point-ref";
    private static final String ATT_USER_SERVICE_REF = "user-service-ref";
    private static final String ATT_KEY = "key";
    private static final String ATT_MAPPABLE_ROLES = "mappable-roles";
    private final Element httpElt;
    private final ParserContext pc;
    private final boolean autoConfig;
    private final boolean allowSessionCreation;
    private RootBeanDefinition anonymousFilter;
    private BeanReference anonymousProviderRef;
    private BeanDefinition rememberMeFilter;
    private String rememberMeServicesId;
    private BeanReference rememberMeProviderRef;
    private BeanDefinition basicFilter;
    private RuntimeBeanReference basicEntryPoint;
    private BeanDefinition formEntryPoint;
    private String formFilterId = null;
    private BeanDefinition x509Filter;
    private BeanReference x509ProviderRef;
    private BeanDefinition jeeFilter;
    private BeanReference jeeProviderRef;
    private RootBeanDefinition preAuthEntryPoint;
    private BeanMetadataElement mainEntryPoint;
    private BeanMetadataElement accessDeniedHandler;
    private BeanDefinition bearerTokenAuthenticationFilter;
    private BeanDefinition logoutFilter;
    private ManagedList logoutHandlers;
    private BeanMetadataElement logoutSuccessHandler;
    private BeanDefinition loginPageGenerationFilter;
    private BeanDefinition logoutPageGenerationFilter;
    private BeanDefinition defaultResourcesFilter;
    private BeanDefinition etf;
    private final BeanReference requestCache;
    private final BeanReference portMapper;
    private final BeanReference portResolver;
    private final BeanMetadataElement csrfLogoutHandler;
    private String loginProcessingUrl;
    private String formLoginPage;
    private boolean oauth2LoginEnabled;
    private boolean defaultAuthorizedClientRepositoryRegistered;
    private String oauth2LoginFilterId;
    private BeanDefinition oauth2AuthorizationRequestRedirectFilter;
    private BeanDefinition oauth2LoginEntryPoint;
    private BeanReference oauth2LoginAuthenticationProviderRef;
    private BeanReference oauth2LoginOidcAuthenticationProviderRef;
    private BeanDefinition oauth2LoginLinks;
    private BeanDefinition saml2AuthenticationUrlToProviderName;
    private BeanDefinition saml2AuthorizationRequestFilter;
    private String saml2AuthenticationFilterId;
    private String saml2AuthenticationRequestFilterId;
    private String saml2LogoutFilterId;
    private String saml2LogoutRequestFilterId;
    private String saml2LogoutResponseFilterId;
    private boolean oauth2ClientEnabled;
    private BeanDefinition authorizationRequestRedirectFilter;
    private BeanDefinition authorizationCodeGrantFilter;
    private BeanReference authorizationCodeAuthenticationProviderRef;
    private final List<BeanReference> authenticationProviders = new ManagedList();
    private final Map<BeanDefinition, BeanMetadataElement> defaultDeniedHandlerMappings = new ManagedMap();
    private final Map<BeanDefinition, BeanMetadataElement> defaultEntryPointMappings = new ManagedMap();
    private final List<BeanDefinition> csrfIgnoreRequestMatchers = new ManagedList();

    AuthenticationConfigBuilder(Element element, boolean forceAutoConfig, ParserContext pc, SessionCreationPolicy sessionPolicy, BeanReference requestCache, BeanReference authenticationManager, BeanMetadataElement authenticationFilterSecurityContextHolderStrategyRef, BeanReference authenticationFilterSecurityContextRepositoryRef, BeanReference sessionStrategy, BeanReference portMapper, BeanReference portResolver, BeanMetadataElement csrfLogoutHandler) {
        this.httpElt = element;
        this.pc = pc;
        this.requestCache = requestCache;
        this.autoConfig = forceAutoConfig | "true".equals(element.getAttribute(ATT_AUTO_CONFIG));
        this.allowSessionCreation = sessionPolicy != SessionCreationPolicy.NEVER && sessionPolicy != SessionCreationPolicy.STATELESS;
        this.portMapper = portMapper;
        this.portResolver = portResolver;
        this.csrfLogoutHandler = csrfLogoutHandler;
        this.createAnonymousFilter(authenticationFilterSecurityContextHolderStrategyRef);
        this.createRememberMeFilter(authenticationManager, authenticationFilterSecurityContextHolderStrategyRef);
        this.createBasicFilter(authenticationManager, authenticationFilterSecurityContextHolderStrategyRef);
        this.createBearerTokenAuthenticationFilter(authenticationManager, authenticationFilterSecurityContextHolderStrategyRef);
        this.createFormLoginFilter(sessionStrategy, authenticationManager, authenticationFilterSecurityContextHolderStrategyRef, authenticationFilterSecurityContextRepositoryRef);
        this.createOAuth2ClientFilters(sessionStrategy, requestCache, authenticationManager, authenticationFilterSecurityContextRepositoryRef, authenticationFilterSecurityContextHolderStrategyRef);
        this.createSaml2LoginFilter(authenticationManager, authenticationFilterSecurityContextRepositoryRef);
        this.createX509Filter(authenticationManager, authenticationFilterSecurityContextHolderStrategyRef);
        this.createJeeFilter(authenticationManager, authenticationFilterSecurityContextHolderStrategyRef);
        this.createLogoutFilter(authenticationFilterSecurityContextHolderStrategyRef);
        this.createSaml2LogoutFilter(authenticationFilterSecurityContextHolderStrategyRef);
        this.createLoginPageFilterIfNeeded();
        this.createUserDetailsServiceFactory();
        this.createExceptionTranslationFilter(authenticationFilterSecurityContextHolderStrategyRef);
    }

    void createRememberMeFilter(BeanReference authenticationManager, BeanMetadataElement authenticationFilterSecurityContextHolderStrategyRef) {
        Element rememberMeElt = DomUtils.getChildElementByTagName((Element)this.httpElt, (String)"remember-me");
        if (rememberMeElt != null) {
            String key = rememberMeElt.getAttribute(ATT_KEY);
            if (!StringUtils.hasText((String)key)) {
                key = this.createKey();
            }
            RememberMeBeanDefinitionParser rememberMeParser = new RememberMeBeanDefinitionParser(key, authenticationManager, authenticationFilterSecurityContextHolderStrategyRef);
            this.rememberMeFilter = rememberMeParser.parse(rememberMeElt, this.pc);
            this.rememberMeServicesId = rememberMeParser.getRememberMeServicesId();
            this.createRememberMeProvider(key);
        }
    }

    private void createRememberMeProvider(String key) {
        RootBeanDefinition provider = new RootBeanDefinition(RememberMeAuthenticationProvider.class);
        provider.setSource(this.rememberMeFilter.getSource());
        provider.getConstructorArgumentValues().addGenericArgumentValue((Object)key);
        String id = this.pc.getReaderContext().generateBeanName((BeanDefinition)provider);
        this.pc.registerBeanComponent(new BeanComponentDefinition((BeanDefinition)provider, id));
        this.rememberMeProviderRef = new RuntimeBeanReference(id);
    }

    void createFormLoginFilter(BeanReference sessionStrategy, BeanReference authManager, BeanMetadataElement authenticationFilterSecurityContextHolderStrategyRef, BeanReference authenticationFilterSecurityContextRepositoryRef) {
        Element formLoginElt = DomUtils.getChildElementByTagName((Element)this.httpElt, (String)"form-login");
        RootBeanDefinition formFilter = null;
        if (formLoginElt != null || this.autoConfig) {
            FormLoginBeanDefinitionParser parser = new FormLoginBeanDefinitionParser("/login", "POST", AUTHENTICATION_PROCESSING_FILTER_CLASS, this.requestCache, sessionStrategy, this.allowSessionCreation, this.portMapper, this.portResolver);
            parser.parse(formLoginElt, this.pc);
            formFilter = parser.getFilterBean();
            this.formEntryPoint = parser.getEntryPointBean();
            this.loginProcessingUrl = parser.getLoginProcessingUrl();
            this.formLoginPage = parser.getLoginPage();
        }
        if (formFilter != null) {
            formFilter.getPropertyValues().addPropertyValue("allowSessionCreation", (Object)this.allowSessionCreation);
            formFilter.getPropertyValues().addPropertyValue("authenticationManager", (Object)authManager);
            if (authenticationFilterSecurityContextRepositoryRef != null) {
                formFilter.getPropertyValues().addPropertyValue("securityContextRepository", (Object)authenticationFilterSecurityContextRepositoryRef);
            }
            formFilter.getPropertyValues().addPropertyValue("securityContextHolderStrategy", (Object)authenticationFilterSecurityContextHolderStrategyRef);
            this.formFilterId = this.pc.getReaderContext().generateBeanName((BeanDefinition)formFilter);
            this.pc.registerBeanComponent(new BeanComponentDefinition((BeanDefinition)formFilter, this.formFilterId));
            this.injectRememberMeServicesRef(formFilter, this.rememberMeServicesId);
        }
    }

    void createOAuth2ClientFilters(BeanReference sessionStrategy, BeanReference requestCache, BeanReference authenticationManager, BeanReference authenticationFilterSecurityContextRepositoryRef, BeanMetadataElement authenticationFilterSecurityContextHolderStrategy) {
        this.createOAuth2LoginFilter(sessionStrategy, authenticationManager, authenticationFilterSecurityContextRepositoryRef, authenticationFilterSecurityContextHolderStrategy);
        this.createOAuth2ClientFilter(requestCache, authenticationManager, authenticationFilterSecurityContextRepositoryRef, authenticationFilterSecurityContextHolderStrategy);
        this.registerOAuth2ClientPostProcessors();
    }

    void createOAuth2LoginFilter(BeanReference sessionStrategy, BeanReference authManager, BeanReference authenticationFilterSecurityContextRepositoryRef, BeanMetadataElement authenticationFilterSecurityContextHolderStrategy) {
        Element oauth2LoginElt = DomUtils.getChildElementByTagName((Element)this.httpElt, (String)"oauth2-login");
        if (oauth2LoginElt == null) {
            return;
        }
        this.oauth2LoginEnabled = true;
        OAuth2LoginBeanDefinitionParser parser = new OAuth2LoginBeanDefinitionParser(this.requestCache, this.portMapper, this.portResolver, sessionStrategy, this.allowSessionCreation, authenticationFilterSecurityContextHolderStrategy);
        BeanDefinition oauth2LoginFilterBean = parser.parse(oauth2LoginElt, this.pc);
        BeanDefinition defaultAuthorizedClientRepository = parser.getDefaultAuthorizedClientRepository();
        this.registerDefaultAuthorizedClientRepositoryIfNecessary(defaultAuthorizedClientRepository);
        oauth2LoginFilterBean.getPropertyValues().addPropertyValue("authenticationManager", (Object)authManager);
        if (authenticationFilterSecurityContextRepositoryRef != null) {
            oauth2LoginFilterBean.getPropertyValues().addPropertyValue("securityContextRepository", (Object)authenticationFilterSecurityContextRepositoryRef);
        }
        BeanDefinition oauth2LoginAuthProvider = parser.getOAuth2LoginAuthenticationProvider();
        this.oauth2AuthorizationRequestRedirectFilter = parser.getOAuth2AuthorizationRequestRedirectFilter();
        this.oauth2LoginEntryPoint = parser.getOAuth2LoginAuthenticationEntryPoint();
        String oauth2LoginAuthProviderId = this.pc.getReaderContext().generateBeanName(oauth2LoginAuthProvider);
        this.oauth2LoginFilterId = this.pc.getReaderContext().generateBeanName(oauth2LoginFilterBean);
        String oauth2AuthorizationRequestRedirectFilterId = this.pc.getReaderContext().generateBeanName(this.oauth2AuthorizationRequestRedirectFilter);
        this.oauth2LoginLinks = parser.getOAuth2LoginLinks();
        this.pc.registerBeanComponent(new BeanComponentDefinition(oauth2LoginFilterBean, this.oauth2LoginFilterId));
        this.pc.registerBeanComponent(new BeanComponentDefinition(this.oauth2AuthorizationRequestRedirectFilter, oauth2AuthorizationRequestRedirectFilterId));
        this.pc.registerBeanComponent(new BeanComponentDefinition(oauth2LoginAuthProvider, oauth2LoginAuthProviderId));
        this.oauth2LoginAuthenticationProviderRef = new RuntimeBeanReference(oauth2LoginAuthProviderId);
        BeanDefinition oauth2LoginOidcAuthProvider = parser.getOAuth2LoginOidcAuthenticationProvider();
        String oauth2LoginOidcAuthProviderId = this.pc.getReaderContext().generateBeanName(oauth2LoginOidcAuthProvider);
        this.pc.registerBeanComponent(new BeanComponentDefinition(oauth2LoginOidcAuthProvider, oauth2LoginOidcAuthProviderId));
        this.oauth2LoginOidcAuthenticationProviderRef = new RuntimeBeanReference(oauth2LoginOidcAuthProviderId);
    }

    void createOAuth2ClientFilter(BeanReference requestCache, BeanReference authenticationManager, BeanReference authenticationFilterSecurityContextRepositoryRef, BeanMetadataElement authenticationFilterSecurityContextHolderStrategy) {
        Element oauth2ClientElt = DomUtils.getChildElementByTagName((Element)this.httpElt, (String)"oauth2-client");
        if (oauth2ClientElt == null) {
            return;
        }
        this.oauth2ClientEnabled = true;
        OAuth2ClientBeanDefinitionParser parser = new OAuth2ClientBeanDefinitionParser(requestCache, authenticationManager, authenticationFilterSecurityContextRepositoryRef, authenticationFilterSecurityContextHolderStrategy);
        parser.parse(oauth2ClientElt, this.pc);
        BeanDefinition defaultAuthorizedClientRepository = parser.getDefaultAuthorizedClientRepository();
        this.registerDefaultAuthorizedClientRepositoryIfNecessary(defaultAuthorizedClientRepository);
        this.authorizationRequestRedirectFilter = parser.getAuthorizationRequestRedirectFilter();
        String authorizationRequestRedirectFilterId = this.pc.getReaderContext().generateBeanName(this.authorizationRequestRedirectFilter);
        this.pc.registerBeanComponent(new BeanComponentDefinition(this.authorizationRequestRedirectFilter, authorizationRequestRedirectFilterId));
        this.authorizationCodeGrantFilter = parser.getAuthorizationCodeGrantFilter();
        String authorizationCodeGrantFilterId = this.pc.getReaderContext().generateBeanName(this.authorizationCodeGrantFilter);
        this.pc.registerBeanComponent(new BeanComponentDefinition(this.authorizationCodeGrantFilter, authorizationCodeGrantFilterId));
        BeanDefinition authorizationCodeAuthenticationProvider = parser.getAuthorizationCodeAuthenticationProvider();
        String authorizationCodeAuthenticationProviderId = this.pc.getReaderContext().generateBeanName(authorizationCodeAuthenticationProvider);
        this.pc.registerBeanComponent(new BeanComponentDefinition(authorizationCodeAuthenticationProvider, authorizationCodeAuthenticationProviderId));
        this.authorizationCodeAuthenticationProviderRef = new RuntimeBeanReference(authorizationCodeAuthenticationProviderId);
    }

    void registerDefaultAuthorizedClientRepositoryIfNecessary(BeanDefinition defaultAuthorizedClientRepository) {
        if (!this.defaultAuthorizedClientRepositoryRegistered && defaultAuthorizedClientRepository != null) {
            String authorizedClientRepositoryId = this.pc.getReaderContext().generateBeanName(defaultAuthorizedClientRepository);
            this.pc.registerBeanComponent(new BeanComponentDefinition(defaultAuthorizedClientRepository, authorizedClientRepositoryId));
            this.defaultAuthorizedClientRepositoryRegistered = true;
        }
    }

    private void registerOAuth2ClientPostProcessors() {
        if (!this.oauth2LoginEnabled && !this.oauth2ClientEnabled) {
            return;
        }
        if (webMvcPresent) {
            this.pc.getReaderContext().registerWithGeneratedName((BeanDefinition)new RootBeanDefinition(OAuth2ClientWebMvcSecurityPostProcessor.class));
        }
        this.pc.getReaderContext().getRegistry().registerBeanDefinition("authorizedClientManagerRegistrar", (BeanDefinition)new RootBeanDefinition(OAuth2AuthorizedClientManagerRegistrar.class));
    }

    private void createSaml2LoginFilter(BeanReference authenticationManager, BeanReference authenticationFilterSecurityContextRepositoryRef) {
        Element saml2LoginElt = DomUtils.getChildElementByTagName((Element)this.httpElt, (String)"saml2-login");
        if (saml2LoginElt == null) {
            return;
        }
        Saml2LoginBeanDefinitionParser parser = new Saml2LoginBeanDefinitionParser(this.csrfIgnoreRequestMatchers, this.portMapper, this.portResolver, this.requestCache, this.allowSessionCreation, authenticationManager, authenticationFilterSecurityContextRepositoryRef, this.authenticationProviders, this.defaultEntryPointMappings);
        BeanDefinition saml2WebSsoAuthenticationFilter = parser.parse(saml2LoginElt, this.pc);
        this.saml2AuthorizationRequestFilter = parser.getSaml2WebSsoAuthenticationRequestFilter();
        this.saml2AuthenticationFilterId = this.pc.getReaderContext().generateBeanName(saml2WebSsoAuthenticationFilter);
        this.saml2AuthenticationRequestFilterId = this.pc.getReaderContext().generateBeanName(this.saml2AuthorizationRequestFilter);
        this.saml2AuthenticationUrlToProviderName = parser.getSaml2AuthenticationUrlToProviderName();
        this.pc.registerBeanComponent(new BeanComponentDefinition(saml2WebSsoAuthenticationFilter, this.saml2AuthenticationFilterId));
        this.pc.registerBeanComponent(new BeanComponentDefinition(this.saml2AuthorizationRequestFilter, this.saml2AuthenticationRequestFilterId));
    }

    private void injectRememberMeServicesRef(RootBeanDefinition bean, String rememberMeServicesId) {
        if (rememberMeServicesId != null) {
            bean.getPropertyValues().addPropertyValue("rememberMeServices", (Object)new RuntimeBeanReference(rememberMeServicesId));
        }
    }

    void createBasicFilter(BeanReference authManager, BeanMetadataElement authenticationFilterSecurityContextHolderStrategyRef) {
        Element basicAuthElt = DomUtils.getChildElementByTagName((Element)this.httpElt, (String)"http-basic");
        if (basicAuthElt == null && !this.autoConfig) {
            return;
        }
        String realm = this.httpElt.getAttribute(ATT_REALM);
        if (!StringUtils.hasText((String)realm)) {
            realm = DEF_REALM;
        }
        BeanDefinitionBuilder filterBuilder = BeanDefinitionBuilder.rootBeanDefinition(BasicAuthenticationFilter.class);
        if (basicAuthElt != null) {
            if (StringUtils.hasText((String)basicAuthElt.getAttribute(ATT_ENTRY_POINT_REF))) {
                this.basicEntryPoint = new RuntimeBeanReference(basicAuthElt.getAttribute(ATT_ENTRY_POINT_REF));
            }
            this.injectAuthenticationDetailsSource(basicAuthElt, filterBuilder);
        }
        if (this.basicEntryPoint == null) {
            RootBeanDefinition entryPoint = new RootBeanDefinition(BasicAuthenticationEntryPoint.class);
            entryPoint.setSource(this.pc.extractSource((Object)this.httpElt));
            entryPoint.getPropertyValues().addPropertyValue("realmName", (Object)realm);
            String entryPointId = this.pc.getReaderContext().generateBeanName((BeanDefinition)entryPoint);
            this.pc.registerBeanComponent(new BeanComponentDefinition((BeanDefinition)entryPoint, entryPointId));
            this.basicEntryPoint = new RuntimeBeanReference(entryPointId);
        }
        filterBuilder.addConstructorArgValue((Object)authManager);
        filterBuilder.addConstructorArgValue((Object)this.basicEntryPoint);
        filterBuilder.addPropertyValue("securityContextHolderStrategy", (Object)authenticationFilterSecurityContextHolderStrategyRef);
        this.basicFilter = filterBuilder.getBeanDefinition();
    }

    void createBearerTokenAuthenticationFilter(BeanReference authManager, BeanMetadataElement authenticationFilterSecurityContextHolderStrategyRef) {
        Element resourceServerElt = DomUtils.getChildElementByTagName((Element)this.httpElt, (String)"oauth2-resource-server");
        if (resourceServerElt == null) {
            return;
        }
        OAuth2ResourceServerBeanDefinitionParser resourceServerBuilder = new OAuth2ResourceServerBeanDefinitionParser(authManager, this.authenticationProviders, this.defaultEntryPointMappings, this.defaultDeniedHandlerMappings, this.csrfIgnoreRequestMatchers, authenticationFilterSecurityContextHolderStrategyRef);
        this.bearerTokenAuthenticationFilter = resourceServerBuilder.parse(resourceServerElt, this.pc);
    }

    void createX509Filter(BeanReference authManager, BeanMetadataElement authenticationFilterSecurityContextHolderStrategyRef) {
        Element x509Elt = DomUtils.getChildElementByTagName((Element)this.httpElt, (String)"x509");
        RootBeanDefinition filter = null;
        if (x509Elt != null) {
            BeanDefinitionBuilder filterBuilder = BeanDefinitionBuilder.rootBeanDefinition(X509AuthenticationFilter.class);
            filterBuilder.getRawBeanDefinition().setSource(this.pc.extractSource((Object)x509Elt));
            filterBuilder.addPropertyValue("authenticationManager", (Object)authManager);
            filterBuilder.addPropertyValue("securityContextHolderStrategy", (Object)authenticationFilterSecurityContextHolderStrategyRef);
            String principalExtractorRef = x509Elt.getAttribute("principal-extractor-ref");
            String subjectPrincipalRegex = x509Elt.getAttribute("subject-principal-regex");
            boolean hasPrincipalExtractorRef = StringUtils.hasText((String)principalExtractorRef);
            boolean hasSubjectPrincipalRegex = StringUtils.hasText((String)subjectPrincipalRegex);
            if (hasPrincipalExtractorRef && hasSubjectPrincipalRegex) {
                this.pc.getReaderContext().error("The attribute 'principal-extractor-ref' cannot be used together with the 'subject-principal-regex' attribute within <x509>", this.pc.extractSource((Object)x509Elt));
            }
            if (hasPrincipalExtractorRef) {
                RuntimeBeanReference principalExtractor = new RuntimeBeanReference(principalExtractorRef);
                filterBuilder.addPropertyValue("principalExtractor", (Object)principalExtractor);
            }
            if (hasSubjectPrincipalRegex) {
                BeanDefinitionBuilder extractor = BeanDefinitionBuilder.rootBeanDefinition(SubjectDnX509PrincipalExtractor.class);
                extractor.addPropertyValue("subjectDnRegex", (Object)subjectPrincipalRegex);
                filterBuilder.addPropertyValue("principalExtractor", (Object)extractor.getBeanDefinition());
            }
            this.injectAuthenticationDetailsSource(x509Elt, filterBuilder);
            filter = (RootBeanDefinition)filterBuilder.getBeanDefinition();
            this.createPrauthEntryPoint(x509Elt);
            this.createX509Provider();
        }
        this.x509Filter = filter;
    }

    private void injectAuthenticationDetailsSource(Element elt, BeanDefinitionBuilder filterBuilder) {
        String authDetailsSourceRef = elt.getAttribute(ATT_AUTH_DETAILS_SOURCE_REF);
        if (StringUtils.hasText((String)authDetailsSourceRef)) {
            filterBuilder.addPropertyReference("authenticationDetailsSource", authDetailsSourceRef);
        }
    }

    private void createX509Provider() {
        Element x509Elt = DomUtils.getChildElementByTagName((Element)this.httpElt, (String)"x509");
        RootBeanDefinition provider = new RootBeanDefinition(PreAuthenticatedAuthenticationProvider.class);
        RootBeanDefinition uds = new RootBeanDefinition();
        uds.setFactoryBeanName("org.springframework.security.userDetailsServiceFactory");
        uds.setFactoryMethodName("authenticationUserDetailsService");
        uds.getConstructorArgumentValues().addGenericArgumentValue((Object)x509Elt.getAttribute(ATT_USER_SERVICE_REF));
        provider.getPropertyValues().addPropertyValue("preAuthenticatedUserDetailsService", (Object)uds);
        this.x509ProviderRef = new RuntimeBeanReference(this.pc.getReaderContext().registerWithGeneratedName((BeanDefinition)provider));
    }

    private void createPrauthEntryPoint(Element source) {
        if (this.preAuthEntryPoint == null) {
            this.preAuthEntryPoint = new RootBeanDefinition(Http403ForbiddenEntryPoint.class);
            this.preAuthEntryPoint.setSource(this.pc.extractSource((Object)source));
        }
    }

    void createJeeFilter(BeanReference authManager, BeanMetadataElement authenticationFilterSecurityContextHolderStrategyRef) {
        Element jeeElt = DomUtils.getChildElementByTagName((Element)this.httpElt, (String)"jee");
        RootBeanDefinition filter = null;
        if (jeeElt != null) {
            BeanDefinitionBuilder filterBuilder = BeanDefinitionBuilder.rootBeanDefinition(J2eePreAuthenticatedProcessingFilter.class);
            filterBuilder.getRawBeanDefinition().setSource(this.pc.extractSource((Object)jeeElt));
            filterBuilder.addPropertyValue("authenticationManager", (Object)authManager);
            filterBuilder.addPropertyValue("securityContextHolderStrategy", (Object)authenticationFilterSecurityContextHolderStrategyRef);
            BeanDefinitionBuilder adsBldr = BeanDefinitionBuilder.rootBeanDefinition(J2eeBasedPreAuthenticatedWebAuthenticationDetailsSource.class);
            adsBldr.addPropertyValue("userRoles2GrantedAuthoritiesMapper", (Object)new RootBeanDefinition(SimpleAttributes2GrantedAuthoritiesMapper.class));
            String roles = jeeElt.getAttribute(ATT_MAPPABLE_ROLES);
            Assert.hasLength((String)roles, (String)"roles is expected to have length");
            BeanDefinitionBuilder rolesBuilder = BeanDefinitionBuilder.rootBeanDefinition(StringUtils.class);
            rolesBuilder.addConstructorArgValue((Object)roles);
            rolesBuilder.setFactoryMethod("commaDelimitedListToSet");
            RootBeanDefinition mappableRolesRetriever = new RootBeanDefinition(SimpleMappableAttributesRetriever.class);
            mappableRolesRetriever.getPropertyValues().addPropertyValue("mappableAttributes", (Object)rolesBuilder.getBeanDefinition());
            adsBldr.addPropertyValue("mappableRolesRetriever", (Object)mappableRolesRetriever);
            filterBuilder.addPropertyValue("authenticationDetailsSource", (Object)adsBldr.getBeanDefinition());
            filter = (RootBeanDefinition)filterBuilder.getBeanDefinition();
            this.createPrauthEntryPoint(jeeElt);
            this.createJeeProvider();
        }
        this.jeeFilter = filter;
    }

    private void createJeeProvider() {
        RootBeanDefinition uds;
        Element jeeElt = DomUtils.getChildElementByTagName((Element)this.httpElt, (String)"jee");
        RootBeanDefinition provider = new RootBeanDefinition(PreAuthenticatedAuthenticationProvider.class);
        if (StringUtils.hasText((String)jeeElt.getAttribute(ATT_USER_SERVICE_REF))) {
            uds = new RootBeanDefinition();
            uds.setFactoryBeanName("org.springframework.security.userDetailsServiceFactory");
            uds.setFactoryMethodName("authenticationUserDetailsService");
            uds.getConstructorArgumentValues().addGenericArgumentValue((Object)jeeElt.getAttribute(ATT_USER_SERVICE_REF));
        } else {
            uds = new RootBeanDefinition(PreAuthenticatedGrantedAuthoritiesUserDetailsService.class);
        }
        provider.getPropertyValues().addPropertyValue("preAuthenticatedUserDetailsService", (Object)uds);
        this.jeeProviderRef = new RuntimeBeanReference(this.pc.getReaderContext().registerWithGeneratedName((BeanDefinition)provider));
    }

    void createLoginPageFilterIfNeeded() {
        boolean needLoginPage;
        boolean bl = needLoginPage = this.formFilterId != null || this.oauth2LoginFilterId != null;
        if (needLoginPage && this.formLoginPage == null) {
            this.logger.info((Object)"No login page configured. The default internal one will be used. Use the 'login-page' attribute to set the URL of the login page.");
            BeanDefinitionBuilder loginPageFilter = BeanDefinitionBuilder.rootBeanDefinition(DefaultLoginPageGeneratingFilter.class);
            loginPageFilter.addPropertyValue("resolveHiddenInputs", (Object)new CsrfTokenHiddenInputFunction());
            BeanDefinitionBuilder logoutPageFilter = BeanDefinitionBuilder.rootBeanDefinition(DefaultLogoutPageGeneratingFilter.class);
            logoutPageFilter.addPropertyValue("resolveHiddenInputs", (Object)new CsrfTokenHiddenInputFunction());
            if (this.formFilterId != null) {
                loginPageFilter.addConstructorArgReference(this.formFilterId);
                loginPageFilter.addPropertyValue("authenticationUrl", (Object)this.loginProcessingUrl);
            }
            if (this.oauth2LoginFilterId != null) {
                loginPageFilter.addPropertyValue("Oauth2LoginEnabled", (Object)true);
                loginPageFilter.addPropertyValue("Oauth2AuthenticationUrlToClientName", (Object)this.oauth2LoginLinks);
            }
            if (this.saml2AuthenticationFilterId != null) {
                loginPageFilter.addPropertyValue("saml2LoginEnabled", (Object)true);
                loginPageFilter.addPropertyValue("saml2AuthenticationUrlToProviderName", (Object)this.saml2AuthenticationUrlToProviderName);
            }
            this.loginPageGenerationFilter = loginPageFilter.getBeanDefinition();
            this.logoutPageGenerationFilter = logoutPageFilter.getBeanDefinition();
            this.defaultResourcesFilter = BeanDefinitionBuilder.rootBeanDefinition(DefaultResourcesFilter.class).setFactoryMethod("css").getBeanDefinition();
        }
    }

    void createLogoutFilter(BeanMetadataElement authenticationFilterSecurityContextHolderStrategyRef) {
        Element logoutElt = DomUtils.getChildElementByTagName((Element)this.httpElt, (String)"logout");
        if (logoutElt != null || this.autoConfig) {
            String formLoginPage = this.formLoginPage;
            if (formLoginPage == null) {
                formLoginPage = "/login";
            }
            LogoutBeanDefinitionParser logoutParser = new LogoutBeanDefinitionParser(formLoginPage, this.rememberMeServicesId, this.csrfLogoutHandler, authenticationFilterSecurityContextHolderStrategyRef);
            this.logoutFilter = logoutParser.parse(logoutElt, this.pc);
            this.logoutHandlers = logoutParser.getLogoutHandlers();
            this.logoutSuccessHandler = logoutParser.getLogoutSuccessHandler();
        }
    }

    private void createSaml2LogoutFilter(BeanMetadataElement authenticationFilterSecurityContextHolderStrategyRef) {
        Element saml2LogoutElt = DomUtils.getChildElementByTagName((Element)this.httpElt, (String)"saml2-logout");
        if (saml2LogoutElt == null) {
            return;
        }
        Saml2LogoutBeanDefinitionParser parser = new Saml2LogoutBeanDefinitionParser((ManagedList<BeanMetadataElement>)this.logoutHandlers, this.logoutSuccessHandler, authenticationFilterSecurityContextHolderStrategyRef);
        parser.parse(saml2LogoutElt, this.pc);
        BeanDefinition saml2LogoutFilter = parser.getLogoutFilter();
        BeanDefinition saml2LogoutRequestFilter = parser.getLogoutRequestFilter();
        BeanDefinition saml2LogoutResponseFilter = parser.getLogoutResponseFilter();
        this.saml2LogoutFilterId = this.pc.getReaderContext().generateBeanName(saml2LogoutFilter);
        this.saml2LogoutRequestFilterId = this.pc.getReaderContext().generateBeanName(saml2LogoutRequestFilter);
        this.saml2LogoutResponseFilterId = this.pc.getReaderContext().generateBeanName(saml2LogoutResponseFilter);
        this.pc.registerBeanComponent(new BeanComponentDefinition(saml2LogoutFilter, this.saml2LogoutFilterId));
        this.pc.registerBeanComponent(new BeanComponentDefinition(saml2LogoutRequestFilter, this.saml2LogoutRequestFilterId));
        this.pc.registerBeanComponent(new BeanComponentDefinition(saml2LogoutResponseFilter, this.saml2LogoutResponseFilterId));
    }

    ManagedList getLogoutHandlers() {
        if (this.logoutHandlers == null && this.rememberMeProviderRef != null) {
            this.logoutHandlers = new ManagedList();
            if (this.csrfLogoutHandler != null) {
                this.logoutHandlers.add((Object)this.csrfLogoutHandler);
            }
            this.logoutHandlers.add((Object)new RuntimeBeanReference(this.rememberMeServicesId));
            this.logoutHandlers.add((Object)new RootBeanDefinition(SecurityContextLogoutHandler.class));
        }
        return this.logoutHandlers;
    }

    BeanMetadataElement getEntryPointBean() {
        return this.mainEntryPoint;
    }

    BeanMetadataElement getAccessDeniedHandlerBean() {
        return this.accessDeniedHandler;
    }

    List<BeanDefinition> getCsrfIgnoreRequestMatchers() {
        return this.csrfIgnoreRequestMatchers;
    }

    void createAnonymousFilter(BeanMetadataElement authenticationFilterSecurityContextHolderStrategyRef) {
        Element anonymousElt = DomUtils.getChildElementByTagName((Element)this.httpElt, (String)"anonymous");
        if (anonymousElt != null && "false".equals(anonymousElt.getAttribute("enabled"))) {
            return;
        }
        String grantedAuthority = null;
        String username = null;
        String key = null;
        Object source = this.pc.extractSource((Object)this.httpElt);
        if (anonymousElt != null) {
            grantedAuthority = anonymousElt.getAttribute("granted-authority");
            username = anonymousElt.getAttribute("username");
            key = anonymousElt.getAttribute(ATT_KEY);
            source = this.pc.extractSource((Object)anonymousElt);
        }
        if (!StringUtils.hasText(grantedAuthority)) {
            grantedAuthority = "ROLE_ANONYMOUS";
        }
        if (!StringUtils.hasText(username)) {
            username = "anonymousUser";
        }
        if (!StringUtils.hasText(key)) {
            key = this.createKey();
        }
        this.anonymousFilter = new RootBeanDefinition(AnonymousAuthenticationFilter.class);
        this.anonymousFilter.getConstructorArgumentValues().addIndexedArgumentValue(0, (Object)key);
        this.anonymousFilter.getConstructorArgumentValues().addIndexedArgumentValue(1, (Object)username);
        this.anonymousFilter.getConstructorArgumentValues().addIndexedArgumentValue(2, (Object)AuthorityUtils.commaSeparatedStringToAuthorityList((String)grantedAuthority));
        this.anonymousFilter.getPropertyValues().addPropertyValue("securityContextHolderStrategy", (Object)authenticationFilterSecurityContextHolderStrategyRef);
        this.anonymousFilter.setSource(source);
        RootBeanDefinition anonymousProviderBean = new RootBeanDefinition(AnonymousAuthenticationProvider.class);
        anonymousProviderBean.getConstructorArgumentValues().addIndexedArgumentValue(0, (Object)key);
        anonymousProviderBean.setSource(this.anonymousFilter.getSource());
        String id = this.pc.getReaderContext().generateBeanName((BeanDefinition)anonymousProviderBean);
        this.pc.registerBeanComponent(new BeanComponentDefinition((BeanDefinition)anonymousProviderBean, id));
        this.anonymousProviderRef = new RuntimeBeanReference(id);
    }

    private String createKey() {
        SecureRandom random = new SecureRandom();
        return Long.toString(random.nextLong());
    }

    void createExceptionTranslationFilter(BeanMetadataElement authenticationFilterSecurityContextHolderStrategyRef) {
        BeanDefinitionBuilder etfBuilder = BeanDefinitionBuilder.rootBeanDefinition(ExceptionTranslationFilter.class);
        this.accessDeniedHandler = this.createAccessDeniedHandler(this.httpElt, this.pc);
        etfBuilder.addPropertyValue("accessDeniedHandler", (Object)this.accessDeniedHandler);
        Assert.state((this.requestCache != null ? 1 : 0) != 0, (String)"No request cache found");
        this.mainEntryPoint = this.selectEntryPoint();
        etfBuilder.addConstructorArgValue((Object)this.mainEntryPoint);
        etfBuilder.addConstructorArgValue((Object)this.requestCache);
        etfBuilder.addPropertyValue("securityContextHolderStrategy", (Object)authenticationFilterSecurityContextHolderStrategyRef);
        this.etf = etfBuilder.getBeanDefinition();
    }

    private BeanMetadataElement createAccessDeniedHandler(Element element, ParserContext pc) {
        Element accessDeniedElt = DomUtils.getChildElementByTagName((Element)element, (String)"access-denied-handler");
        BeanDefinitionBuilder accessDeniedHandler = BeanDefinitionBuilder.rootBeanDefinition(AccessDeniedHandlerImpl.class);
        if (accessDeniedElt != null) {
            String errorPage = accessDeniedElt.getAttribute(ATT_ACCESS_DENIED_ERROR_PAGE);
            String ref = accessDeniedElt.getAttribute("ref");
            if (StringUtils.hasText((String)errorPage)) {
                if (StringUtils.hasText((String)ref)) {
                    pc.getReaderContext().error("The attribute error-page cannot be used together with the 'ref' attribute within <access-denied-handler>", pc.extractSource((Object)accessDeniedElt));
                }
                accessDeniedHandler.addPropertyValue("errorPage", (Object)errorPage);
                return accessDeniedHandler.getBeanDefinition();
            }
            if (StringUtils.hasText((String)ref)) {
                return new RuntimeBeanReference(ref);
            }
        }
        if (this.defaultDeniedHandlerMappings.isEmpty()) {
            return accessDeniedHandler.getBeanDefinition();
        }
        if (this.defaultDeniedHandlerMappings.size() == 1) {
            return this.defaultDeniedHandlerMappings.values().iterator().next();
        }
        accessDeniedHandler = BeanDefinitionBuilder.rootBeanDefinition(RequestMatcherDelegatingAccessDeniedHandler.class);
        accessDeniedHandler.addConstructorArgValue(this.defaultDeniedHandlerMappings);
        accessDeniedHandler.addConstructorArgValue((Object)BeanDefinitionBuilder.rootBeanDefinition(AccessDeniedHandlerImpl.class));
        return accessDeniedHandler.getBeanDefinition();
    }

    private BeanMetadataElement selectEntryPoint() {
        String customEntryPoint = this.httpElt.getAttribute(ATT_ENTRY_POINT_REF);
        if (StringUtils.hasText((String)customEntryPoint)) {
            return new RuntimeBeanReference(customEntryPoint);
        }
        if (!this.defaultEntryPointMappings.isEmpty()) {
            if (this.defaultEntryPointMappings.size() == 1) {
                return this.defaultEntryPointMappings.values().iterator().next();
            }
            BeanDefinitionBuilder delegatingEntryPoint = BeanDefinitionBuilder.rootBeanDefinition(DelegatingAuthenticationEntryPoint.class);
            delegatingEntryPoint.addConstructorArgValue(this.defaultEntryPointMappings);
            return delegatingEntryPoint.getBeanDefinition();
        }
        Element basicAuthElt = DomUtils.getChildElementByTagName((Element)this.httpElt, (String)"http-basic");
        Element formLoginElt = DomUtils.getChildElementByTagName((Element)this.httpElt, (String)"form-login");
        if (basicAuthElt != null && formLoginElt == null && this.oauth2LoginEntryPoint == null) {
            return this.basicEntryPoint;
        }
        if (this.formFilterId != null) {
            if (formLoginElt != null && this.oauth2LoginEntryPoint != null) {
                return this.formEntryPoint;
            }
            if (this.oauth2LoginEntryPoint == null) {
                return this.formEntryPoint;
            }
        }
        if (this.preAuthEntryPoint != null) {
            return this.preAuthEntryPoint;
        }
        if (this.oauth2LoginEntryPoint != null) {
            return this.oauth2LoginEntryPoint;
        }
        this.pc.getReaderContext().error("No AuthenticationEntryPoint could be established. Please make sure you have a login mechanism configured through the namespace (such as form-login) or specify a custom AuthenticationEntryPoint with the 'entry-point-ref' attribute ", this.pc.extractSource((Object)this.httpElt));
        return null;
    }

    private void createUserDetailsServiceFactory() {
        if (this.pc.getRegistry().containsBeanDefinition("org.springframework.security.userDetailsServiceFactory")) {
            return;
        }
        RootBeanDefinition bean = new RootBeanDefinition(UserDetailsServiceFactoryBean.class);
        bean.setRole(2);
        this.pc.registerBeanComponent(new BeanComponentDefinition((BeanDefinition)bean, "org.springframework.security.userDetailsServiceFactory"));
    }

    List<OrderDecorator> getFilters() {
        ArrayList<OrderDecorator> filters = new ArrayList<OrderDecorator>();
        if (this.anonymousFilter != null) {
            filters.add(new OrderDecorator((BeanMetadataElement)this.anonymousFilter, SecurityFilters.ANONYMOUS_FILTER));
        }
        if (this.rememberMeFilter != null) {
            filters.add(new OrderDecorator((BeanMetadataElement)this.rememberMeFilter, SecurityFilters.REMEMBER_ME_FILTER));
        }
        if (this.logoutFilter != null) {
            filters.add(new OrderDecorator((BeanMetadataElement)this.logoutFilter, SecurityFilters.LOGOUT_FILTER));
        }
        if (this.x509Filter != null) {
            filters.add(new OrderDecorator((BeanMetadataElement)this.x509Filter, SecurityFilters.X509_FILTER));
        }
        if (this.jeeFilter != null) {
            filters.add(new OrderDecorator((BeanMetadataElement)this.jeeFilter, SecurityFilters.PRE_AUTH_FILTER));
        }
        if (this.formFilterId != null) {
            filters.add(new OrderDecorator((BeanMetadataElement)new RuntimeBeanReference(this.formFilterId), SecurityFilters.FORM_LOGIN_FILTER));
        }
        if (this.oauth2LoginFilterId != null) {
            filters.add(new OrderDecorator((BeanMetadataElement)new RuntimeBeanReference(this.oauth2LoginFilterId), SecurityFilters.OAUTH2_LOGIN_FILTER));
            filters.add(new OrderDecorator((BeanMetadataElement)this.oauth2AuthorizationRequestRedirectFilter, SecurityFilters.OAUTH2_AUTHORIZATION_REQUEST_FILTER));
        }
        if (this.loginPageGenerationFilter != null) {
            filters.add(new OrderDecorator((BeanMetadataElement)this.loginPageGenerationFilter, SecurityFilters.LOGIN_PAGE_FILTER));
            filters.add(new OrderDecorator((BeanMetadataElement)this.logoutPageGenerationFilter, SecurityFilters.LOGOUT_PAGE_FILTER));
        }
        if (this.defaultResourcesFilter != null) {
            filters.add(new OrderDecorator((BeanMetadataElement)this.defaultResourcesFilter, SecurityFilters.DEFAULT_RESOURCES_FILTER));
        }
        if (this.basicFilter != null) {
            filters.add(new OrderDecorator((BeanMetadataElement)this.basicFilter, SecurityFilters.BASIC_AUTH_FILTER));
        }
        if (this.bearerTokenAuthenticationFilter != null) {
            filters.add(new OrderDecorator((BeanMetadataElement)this.bearerTokenAuthenticationFilter, SecurityFilters.BEARER_TOKEN_AUTH_FILTER));
        }
        if (this.authorizationCodeGrantFilter != null) {
            filters.add(new OrderDecorator((BeanMetadataElement)this.authorizationRequestRedirectFilter, SecurityFilters.OAUTH2_AUTHORIZATION_REQUEST_FILTER.getOrder() + 1));
            filters.add(new OrderDecorator((BeanMetadataElement)this.authorizationCodeGrantFilter, SecurityFilters.OAUTH2_AUTHORIZATION_CODE_GRANT_FILTER));
        }
        if (this.saml2AuthenticationFilterId != null) {
            filters.add(new OrderDecorator((BeanMetadataElement)new RuntimeBeanReference(this.saml2AuthenticationFilterId), SecurityFilters.SAML2_AUTHENTICATION_FILTER));
            filters.add(new OrderDecorator((BeanMetadataElement)new RuntimeBeanReference(this.saml2AuthenticationRequestFilterId), SecurityFilters.SAML2_AUTHENTICATION_REQUEST_FILTER));
        }
        if (this.saml2LogoutFilterId != null) {
            filters.add(new OrderDecorator((BeanMetadataElement)new RuntimeBeanReference(this.saml2LogoutFilterId), SecurityFilters.SAML2_LOGOUT_FILTER));
            filters.add(new OrderDecorator((BeanMetadataElement)new RuntimeBeanReference(this.saml2LogoutRequestFilterId), SecurityFilters.SAML2_LOGOUT_REQUEST_FILTER));
            filters.add(new OrderDecorator((BeanMetadataElement)new RuntimeBeanReference(this.saml2LogoutResponseFilterId), SecurityFilters.SAML2_LOGOUT_RESPONSE_FILTER));
        }
        filters.add(new OrderDecorator((BeanMetadataElement)this.etf, SecurityFilters.EXCEPTION_TRANSLATION_FILTER));
        return filters;
    }

    List<BeanReference> getProviders() {
        ArrayList<BeanReference> providers = new ArrayList<BeanReference>();
        if (this.anonymousProviderRef != null) {
            providers.add(this.anonymousProviderRef);
        }
        if (this.rememberMeProviderRef != null) {
            providers.add(this.rememberMeProviderRef);
        }
        if (this.x509ProviderRef != null) {
            providers.add(this.x509ProviderRef);
        }
        if (this.jeeProviderRef != null) {
            providers.add(this.jeeProviderRef);
        }
        if (this.oauth2LoginAuthenticationProviderRef != null) {
            providers.add(this.oauth2LoginAuthenticationProviderRef);
        }
        if (this.oauth2LoginOidcAuthenticationProviderRef != null) {
            providers.add(this.oauth2LoginOidcAuthenticationProviderRef);
        }
        if (this.authorizationCodeAuthenticationProviderRef != null) {
            providers.add(this.authorizationCodeAuthenticationProviderRef);
        }
        providers.addAll(this.authenticationProviders);
        return providers;
    }

    static {
        ClassLoader classLoader = AuthenticationConfigBuilder.class.getClassLoader();
        webMvcPresent = ClassUtils.isPresent((String)"org.springframework.web.servlet.DispatcherServlet", (ClassLoader)classLoader);
    }

    private static class CsrfTokenHiddenInputFunction
    implements Function<HttpServletRequest, Map<String, String>> {
        private CsrfTokenHiddenInputFunction() {
        }

        @Override
        public Map<String, String> apply(HttpServletRequest request) {
            CsrfToken token = (CsrfToken)request.getAttribute(CsrfToken.class.getName());
            if (token == null) {
                return Collections.emptyMap();
            }
            return Collections.singletonMap(token.getParameterName(), token.getToken());
        }
    }
}

