/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.config.annotation.web.reactive;

import java.util.Map;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Scope;
import org.springframework.context.expression.BeanFactoryResolver;
import org.springframework.core.ReactiveAdapterRegistry;
import org.springframework.expression.BeanResolver;
import org.springframework.security.authentication.ReactiveAuthenticationManager;
import org.springframework.security.authentication.UserDetailsRepositoryReactiveAuthenticationManager;
import org.springframework.security.authentication.password.ReactiveCompromisedPasswordChecker;
import org.springframework.security.config.Customizer;
import org.springframework.security.config.ObjectPostProcessor;
import org.springframework.security.config.web.server.ServerHttpSecurity;
import org.springframework.security.core.annotation.AnnotationTemplateExpressionDefaults;
import org.springframework.security.core.userdetails.ReactiveUserDetailsPasswordService;
import org.springframework.security.core.userdetails.ReactiveUserDetailsService;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.security.web.reactive.result.method.annotation.AuthenticationPrincipalArgumentResolver;
import org.springframework.security.web.reactive.result.method.annotation.CurrentSecurityContextArgumentResolver;
import org.springframework.web.reactive.config.WebFluxConfigurer;
import org.springframework.web.reactive.result.method.HandlerMethodArgumentResolver;
import org.springframework.web.reactive.result.method.annotation.ArgumentResolverConfigurer;

@Configuration(proxyBeanMethods=false)
class ServerHttpSecurityConfiguration {
    private static final String BEAN_NAME_PREFIX = "org.springframework.security.config.annotation.web.reactive.HttpSecurityConfiguration.";
    private static final String HTTPSECURITY_BEAN_NAME = "org.springframework.security.config.annotation.web.reactive.HttpSecurityConfiguration.httpSecurity";
    private ReactiveAdapterRegistry adapterRegistry = new ReactiveAdapterRegistry();
    private ReactiveAuthenticationManager authenticationManager;
    private ReactiveUserDetailsService reactiveUserDetailsService;
    private PasswordEncoder passwordEncoder;
    private ReactiveUserDetailsPasswordService userDetailsPasswordService;
    private ReactiveCompromisedPasswordChecker compromisedPasswordChecker;
    private ObjectPostProcessor<ReactiveAuthenticationManager> postProcessor = ObjectPostProcessor.identity();
    @Autowired(required=false)
    private BeanFactory beanFactory;

    ServerHttpSecurityConfiguration() {
    }

    @Autowired(required=false)
    void setAdapterRegistry(ReactiveAdapterRegistry adapterRegistry) {
        this.adapterRegistry = adapterRegistry;
    }

    @Autowired(required=false)
    void setAuthenticationManager(ReactiveAuthenticationManager authenticationManager) {
        this.authenticationManager = authenticationManager;
    }

    @Autowired(required=false)
    void setReactiveUserDetailsService(ReactiveUserDetailsService reactiveUserDetailsService) {
        this.reactiveUserDetailsService = reactiveUserDetailsService;
    }

    @Autowired(required=false)
    void setPasswordEncoder(PasswordEncoder passwordEncoder) {
        this.passwordEncoder = passwordEncoder;
    }

    @Autowired(required=false)
    void setUserDetailsPasswordService(ReactiveUserDetailsPasswordService userDetailsPasswordService) {
        this.userDetailsPasswordService = userDetailsPasswordService;
    }

    @Autowired(required=false)
    void setAuthenticationManagerPostProcessor(Map<String, ObjectPostProcessor<ReactiveAuthenticationManager>> postProcessors) {
        if (postProcessors.size() == 1) {
            this.postProcessor = postProcessors.values().iterator().next();
        }
        this.postProcessor = postProcessors.get("reactiveAuthenticationManagerPostProcessor");
    }

    @Autowired(required=false)
    void setCompromisedPasswordChecker(ReactiveCompromisedPasswordChecker compromisedPasswordChecker) {
        this.compromisedPasswordChecker = compromisedPasswordChecker;
    }

    @Bean
    static WebFluxConfigurer authenticationPrincipalArgumentResolverConfigurer(final ObjectProvider<AuthenticationPrincipalArgumentResolver> authenticationPrincipalArgumentResolver, final ObjectProvider<CurrentSecurityContextArgumentResolver> currentSecurityContextArgumentResolvers) {
        return new WebFluxConfigurer(){

            public void configureArgumentResolvers(ArgumentResolverConfigurer configurer) {
                configurer.addCustomResolver(new HandlerMethodArgumentResolver[]{(HandlerMethodArgumentResolver)authenticationPrincipalArgumentResolver.getObject(), (HandlerMethodArgumentResolver)currentSecurityContextArgumentResolvers.getObject()});
            }
        };
    }

    @Bean
    AuthenticationPrincipalArgumentResolver authenticationPrincipalArgumentResolver(ObjectProvider<AnnotationTemplateExpressionDefaults> templateDefaults) {
        AuthenticationPrincipalArgumentResolver resolver = new AuthenticationPrincipalArgumentResolver(this.adapterRegistry);
        if (this.beanFactory != null) {
            resolver.setBeanResolver((BeanResolver)new BeanFactoryResolver(this.beanFactory));
        }
        templateDefaults.ifAvailable(arg_0 -> ((AuthenticationPrincipalArgumentResolver)resolver).setTemplateDefaults(arg_0));
        return resolver;
    }

    @Bean
    CurrentSecurityContextArgumentResolver reactiveCurrentSecurityContextArgumentResolver(ObjectProvider<AnnotationTemplateExpressionDefaults> templateDefaults) {
        CurrentSecurityContextArgumentResolver resolver = new CurrentSecurityContextArgumentResolver(this.adapterRegistry);
        if (this.beanFactory != null) {
            resolver.setBeanResolver((BeanResolver)new BeanFactoryResolver(this.beanFactory));
        }
        templateDefaults.ifAvailable(arg_0 -> ((CurrentSecurityContextArgumentResolver)resolver).setTemplateDefaults(arg_0));
        return resolver;
    }

    @Bean(value={"org.springframework.security.config.annotation.web.reactive.HttpSecurityConfiguration.httpSecurity"})
    @Scope(value="prototype")
    ServerHttpSecurity httpSecurity() {
        ContextAwareServerHttpSecurity http = new ContextAwareServerHttpSecurity();
        return http.authenticationManager(this.authenticationManager()).headers(Customizer.withDefaults()).logout(Customizer.withDefaults());
    }

    private ReactiveAuthenticationManager authenticationManager() {
        if (this.authenticationManager != null) {
            return this.authenticationManager;
        }
        if (this.reactiveUserDetailsService != null) {
            UserDetailsRepositoryReactiveAuthenticationManager manager = new UserDetailsRepositoryReactiveAuthenticationManager(this.reactiveUserDetailsService);
            if (this.passwordEncoder != null) {
                manager.setPasswordEncoder(this.passwordEncoder);
            }
            manager.setUserDetailsPasswordService(this.userDetailsPasswordService);
            manager.setCompromisedPasswordChecker(this.compromisedPasswordChecker);
            return (ReactiveAuthenticationManager)this.postProcessor.postProcess(manager);
        }
        return null;
    }

    private static class ContextAwareServerHttpSecurity
    extends ServerHttpSecurity
    implements ApplicationContextAware {
        private ContextAwareServerHttpSecurity() {
        }

        @Override
        public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
            super.setApplicationContext(applicationContext);
        }
    }
}

