/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.connection;

import org.jspecify.annotations.Nullable;
import org.springframework.data.redis.connection.NamedNode;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public class RedisNode
implements NamedNode {
    public static final int DEFAULT_PORT = 6379;
    public static final int DEFAULT_SENTINEL_PORT = 26379;
    @Nullable String id;
    @Nullable String name;
    @Nullable String host;
    int port;
    @Nullable NodeType type;
    @Nullable String masterId;

    public RedisNode(String host, int port) {
        Assert.notNull((Object)host, (String)"host must not be null");
        this.host = host;
        this.port = port;
    }

    protected RedisNode() {
    }

    private RedisNode(RedisNode redisNode) {
        this.id = redisNode.id;
        this.name = redisNode.name;
        this.host = redisNode.host;
        this.port = redisNode.port;
        this.type = redisNode.type;
        this.masterId = redisNode.masterId;
    }

    public static RedisNode fromString(String hostPortString) {
        return RedisNode.fromString(hostPortString, 6379);
    }

    public static RedisNode fromString(String hostPortString, int defaultPort) {
        String host;
        Assert.notNull((Object)hostPortString, (String)"HostAndPort must not be null");
        String portString = null;
        if (hostPortString.startsWith("[")) {
            String[] hostAndPort = RedisNode.getHostAndPortFromBracketedHost(hostPortString);
            host = hostAndPort[0];
            portString = hostAndPort[1];
        } else {
            int colonPos = hostPortString.indexOf(58);
            if (colonPos >= 0 && hostPortString.indexOf(58, colonPos + 1) == -1) {
                host = hostPortString.substring(0, colonPos);
                portString = hostPortString.substring(colonPos + 1);
            } else {
                int lastColonIndex = hostPortString.lastIndexOf(58);
                if (lastColonIndex > hostPortString.indexOf(93)) {
                    host = hostPortString.substring(0, lastColonIndex);
                    portString = hostPortString.substring(lastColonIndex + 1);
                } else {
                    host = hostPortString;
                }
            }
        }
        int port = defaultPort;
        if (StringUtils.hasText((String)portString)) {
            try {
                port = Integer.parseInt(portString);
            }
            catch (RuntimeException ignore) {
                throw new IllegalArgumentException("Unparseable port number: %s".formatted(hostPortString));
            }
        }
        if (!RedisNode.isValidPort(port)) {
            throw new IllegalArgumentException("Port number out of range: %s".formatted(hostPortString));
        }
        return new RedisNode(host, port);
    }

    private static String[] getHostAndPortFromBracketedHost(String hostPortString) {
        if (hostPortString.charAt(0) != '[') {
            throw new IllegalArgumentException("Bracketed host-port string must start with a bracket: %s".formatted(hostPortString));
        }
        int colonIndex = hostPortString.indexOf(58);
        int closeBracketIndex = hostPortString.lastIndexOf(93);
        if (colonIndex <= -1 || closeBracketIndex <= colonIndex) {
            throw new IllegalArgumentException("Invalid bracketed host/port: %s".formatted(hostPortString));
        }
        String host = hostPortString.substring(1, closeBracketIndex);
        if (closeBracketIndex + 1 == hostPortString.length()) {
            return new String[]{host, ""};
        }
        if (hostPortString.charAt(closeBracketIndex + 1) != ':') {
            throw new IllegalArgumentException("Only a colon may follow a close bracket: %s".formatted(hostPortString));
        }
        for (int i = closeBracketIndex + 2; i < hostPortString.length(); ++i) {
            if (Character.isDigit(hostPortString.charAt(i))) continue;
            throw new IllegalArgumentException("Port must be numeric: %s".formatted(hostPortString));
        }
        return new String[]{host, hostPortString.substring(closeBracketIndex + 2)};
    }

    public @Nullable String getHost() {
        return this.host;
    }

    public String getRequiredHost() {
        String host = this.getHost();
        if (host == null) {
            throw new IllegalStateException("No host associated with this Redis Node");
        }
        return host;
    }

    public boolean hasValidHost() {
        return StringUtils.hasText((String)this.host);
    }

    public @Nullable Integer getPort() {
        return this.port;
    }

    public int getPortOr(int defaultPort) {
        Integer port = this.getPort();
        return port == null ? defaultPort : port;
    }

    public int getRequiredPort() {
        Integer port = this.getPort();
        if (port == null) {
            throw new IllegalStateException("No port associated with this Redis Node");
        }
        return port;
    }

    public String asString() {
        if (this.host != null && this.host.contains(":")) {
            return "[" + this.host + "]:" + this.port;
        }
        return this.host + ":" + this.port;
    }

    @Override
    public @Nullable String getName() {
        return this.name;
    }

    public void setName(@Nullable String name) {
        this.name = name;
    }

    public @Nullable String getMasterId() {
        return this.masterId;
    }

    public @Nullable String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public @Nullable NodeType getType() {
        return this.type;
    }

    public boolean isMaster() {
        return ObjectUtils.nullSafeEquals((Object)((Object)NodeType.MASTER), (Object)((Object)this.getType()));
    }

    public boolean isReplica() {
        return ObjectUtils.nullSafeEquals((Object)((Object)NodeType.REPLICA), (Object)((Object)this.getType()));
    }

    public static RedisNodeBuilder newRedisNode() {
        return new RedisNodeBuilder();
    }

    public String toString() {
        return this.asString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + ObjectUtils.nullSafeHashCode((Object)this.host);
        result = 31 * result + ObjectUtils.nullSafeHashCode((Object)this.port);
        return result;
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !(obj instanceof RedisNode)) {
            return false;
        }
        RedisNode other = (RedisNode)obj;
        if (!ObjectUtils.nullSafeEquals((Object)this.host, (Object)other.host)) {
            return false;
        }
        if (!ObjectUtils.nullSafeEquals((Object)this.port, (Object)other.port)) {
            return false;
        }
        return ObjectUtils.nullSafeEquals((Object)this.name, (Object)other.name);
    }

    private static boolean isValidPort(int port) {
        return port >= 0 && port <= 65535;
    }

    public static enum NodeType {
        MASTER,
        REPLICA;

    }

    public static class RedisNodeBuilder {
        private RedisNode node = new RedisNode();

        public RedisNodeBuilder withName(String name) {
            this.node.name = name;
            return this;
        }

        public RedisNodeBuilder listeningAt(String host, int port) {
            Assert.notNull((Object)host, (String)"Hostname must not be null");
            this.node.host = host;
            this.node.port = port;
            return this;
        }

        public RedisNodeBuilder withId(String id) {
            this.node.id = id;
            return this;
        }

        public RedisNodeBuilder promotedAs(NodeType type) {
            this.node.type = type;
            return this;
        }

        public RedisNodeBuilder replicaOf(String masterId) {
            this.node.masterId = masterId;
            return this;
        }

        public RedisNode build() {
            return new RedisNode(this.node);
        }
    }
}

