/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.util;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jspecify.annotations.Nullable;
import org.springframework.core.KotlinDetector;
import org.springframework.core.MethodParameter;
import org.springframework.core.ResolvableType;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.data.util.KotlinReflectionUtils;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.ReflectionUtils;

public final class ReflectionUtils {
    private ReflectionUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    public static boolean hasParameterOfType(Method method, Class<?> type) {
        return Arrays.asList(method.getParameterTypes()).contains(type);
    }

    public static boolean hasParameterAssignableToType(Method method, Class<?> type) {
        for (Class<?> parameterType : method.getParameterTypes()) {
            if (!type.isAssignableFrom(parameterType)) continue;
            return true;
        }
        return false;
    }

    public static int getParameterCount(Method method, Predicate<Class<?>> predicate) {
        return (int)Arrays.stream(method.getParameterTypes()).filter(predicate).count();
    }

    public static boolean isVoid(Class<?> type) {
        if (ClassUtils.isVoidType(type)) {
            return true;
        }
        return type.getName().equals("kotlin.Unit");
    }

    public static @Nullable Field findField(Class<?> type, final ReflectionUtils.FieldFilter filter) {
        return ReflectionUtils.findField(type, new DescribedFieldFilter(){

            public boolean matches(Field field) {
                return filter.matches(field);
            }

            @Override
            public String getDescription() {
                return String.format("FieldFilter %s", filter.toString());
            }
        }, false);
    }

    public static @Nullable Field findField(Class<?> type, DescribedFieldFilter filter) {
        return ReflectionUtils.findField(type, filter, true);
    }

    public static @Nullable Field findField(Class<?> type, DescribedFieldFilter filter, boolean enforceUniqueness) {
        Assert.notNull(type, (String)"Type must not be null");
        Assert.notNull((Object)filter, (String)"Filter must not be null");
        Field foundField = null;
        for (Class<?> targetClass = type; targetClass != Object.class; targetClass = targetClass.getSuperclass()) {
            for (Field field : targetClass.getDeclaredFields()) {
                if (!filter.matches(field)) continue;
                if (!enforceUniqueness) {
                    return field;
                }
                if (foundField != null) {
                    throw new IllegalStateException(filter.getDescription());
                }
                foundField = field;
            }
        }
        return foundField;
    }

    public static Field getRequiredField(Class<?> type, String name) {
        Field result = org.springframework.util.ReflectionUtils.findField(type, (String)name);
        if (result == null) {
            throw new IllegalArgumentException(String.format("Unable to find field %s on %s", name, type));
        }
        return result;
    }

    public static void setField(Field field, Object target, @Nullable Object value) {
        org.springframework.util.ReflectionUtils.makeAccessible((Field)field);
        org.springframework.util.ReflectionUtils.setField((Field)field, (Object)target, (Object)value);
    }

    public static <T> @Nullable Constructor<T> findConstructor(Class<T> type, Object ... constructorArguments) {
        Assert.notNull(type, (String)"Target type must not be null");
        Assert.notNull((Object)constructorArguments, (String)"Constructor arguments must not be null");
        for (Constructor<?> declaredConstructor : type.getDeclaredConstructors()) {
            if (!ReflectionUtils.argumentsMatch(declaredConstructor.getParameterTypes(), constructorArguments)) continue;
            return declaredConstructor;
        }
        return null;
    }

    @Deprecated
    public static Method findRequiredMethod(Class<?> type, String name, Class<?> ... parameterTypes) {
        return ReflectionUtils.getRequiredMethod(type, name, parameterTypes);
    }

    public static Method getRequiredMethod(Class<?> type, String name, Class<?> ... parameterTypes) {
        Assert.notNull(type, (String)"Class must not be null");
        Assert.notNull((Object)name, (String)"Method name must not be null");
        Method result = null;
        for (Class<?> searchType = type; searchType != null; searchType = searchType.getSuperclass()) {
            Method[] methods;
            for (Method method : methods = searchType.isInterface() ? searchType.getMethods() : org.springframework.util.ReflectionUtils.getDeclaredMethods(searchType)) {
                if (!name.equals(method.getName()) || !ReflectionUtils.hasSameParams(method, parameterTypes) || result != null && !result.isSynthetic() && !result.isBridge()) continue;
                result = method;
            }
        }
        if (result == null) {
            String parameterTypeNames = Arrays.stream(parameterTypes).map(Object::toString).collect(Collectors.joining(", "));
            throw new IllegalArgumentException(String.format("Unable to find method %s(%s) on %s", name, parameterTypeNames, type));
        }
        return result;
    }

    private static boolean hasSameParams(Method method, Class<?>[] paramTypes) {
        return paramTypes.length == method.getParameterCount() && Arrays.equals(paramTypes, method.getParameterTypes());
    }

    public static Stream<Class<?>> returnTypeAndParameters(Method method) {
        Assert.notNull((Object)method, (String)"Method must not be null");
        Stream<Class<?>> returnType = Stream.of(method.getReturnType());
        Stream<Class<?>> parameterTypes = Arrays.stream(method.getParameterTypes());
        return Stream.concat(returnType, parameterTypes);
    }

    public static @Nullable Method findMethod(Class<?> type, String name, ResolvableType ... parameterTypes) {
        Assert.notNull(type, (String)"Type must not be null");
        Assert.hasText((String)name, (String)"Name must not be null or empty");
        Assert.notNull((Object)parameterTypes, (String)"Parameter types must not be null");
        ArrayList<Class> collect = parameterTypes.length == 0 ? Collections.emptyList() : new ArrayList<Class>(parameterTypes.length);
        for (ResolvableType parameterType : parameterTypes) {
            Class rawClass = parameterType.getRawClass();
            collect.add(rawClass);
        }
        Method method = org.springframework.util.ReflectionUtils.findMethod(type, (String)name, (Class[])collect.toArray(new Class[0]));
        if (method != null) {
            for (int i = 0; i < parameterTypes.length; ++i) {
                if (ResolvableType.forMethodParameter((Method)method, (int)i).equals((Object)parameterTypes[i])) continue;
                return null;
            }
            return method;
        }
        return null;
    }

    private static boolean argumentsMatch(Class<?>[] parameterTypes, Object[] arguments) {
        if (parameterTypes.length != arguments.length) {
            return false;
        }
        int index = 0;
        for (Class<?> argumentType : parameterTypes) {
            Object argument = arguments[index];
            if (argumentType.isPrimitive() && argument == null) {
                return false;
            }
            if (argument != null && !ClassUtils.isAssignableValue(argumentType, (Object)argument)) {
                return false;
            }
            ++index;
        }
        return true;
    }

    public static String toString(Method method) {
        return ReflectionUtils.toString(method, Type::getTypeName);
    }

    public static String toString(Method method, Function<Class<?>, String> typeNameMapper) {
        return method.getName() + Arrays.stream(method.getParameterTypes()).map(typeNameMapper).collect(Collectors.joining(",", "(", ")"));
    }

    public static boolean isNullable(MethodParameter parameter) {
        if (ReflectionUtils.isVoid(parameter.getParameterType())) {
            return true;
        }
        if (KotlinDetector.isKotlinPresent() && KotlinReflectionUtils.isSupportedKotlinClass(parameter.getDeclaringClass())) {
            return KotlinReflectionUtils.isNullable(parameter);
        }
        return !parameter.getParameterType().isPrimitive();
    }

    public static Object getPrimitiveDefault(Class<?> type) {
        if (type == Byte.TYPE || type == Byte.class) {
            return (byte)0;
        }
        if (type == Short.TYPE || type == Short.class) {
            return (short)0;
        }
        if (type == Integer.TYPE || type == Integer.class) {
            return 0;
        }
        if (type == Long.TYPE || type == Long.class) {
            return 0L;
        }
        if (type == Float.TYPE || type == Float.class) {
            return Float.valueOf(0.0f);
        }
        if (type == Double.TYPE || type == Double.class) {
            return 0.0;
        }
        if (type == Character.TYPE || type == Character.class) {
            return Character.valueOf('\u0000');
        }
        if (type == Boolean.TYPE) {
            return Boolean.FALSE;
        }
        throw new IllegalArgumentException(String.format("Primitive type %s not supported", type));
    }

    public static interface DescribedFieldFilter
    extends ReflectionUtils.FieldFilter {
        public String getDescription();
    }

    public static class AnnotationFieldFilter
    implements DescribedFieldFilter {
        private final Class<? extends Annotation> annotationType;

        public AnnotationFieldFilter(Class<? extends Annotation> annotationType) {
            this.annotationType = annotationType;
        }

        public boolean matches(Field field) {
            return AnnotationUtils.getAnnotation((AnnotatedElement)field, this.annotationType) != null;
        }

        @Override
        public String getDescription() {
            return String.format("Annotation filter for %s", this.annotationType.getName());
        }
    }
}

