/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.configuration;

import java.io.IOException;
import java.io.InputStream;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.UnrecoverableKeyException;
import javax.net.ssl.SSLContext;
import org.apache.hc.core5.ssl.SSLContextBuilder;
import org.springframework.cloud.configuration.TlsProperties;
import org.springframework.core.io.Resource;

public class SSLContextFactory {
    private TlsProperties properties;

    public SSLContextFactory(TlsProperties properties) {
        this.properties = properties;
    }

    public SSLContext createSSLContext() throws GeneralSecurityException, IOException {
        SSLContextBuilder builder = new SSLContextBuilder();
        char[] keyPassword = this.properties.keyPassword();
        KeyStore keyStore = this.createKeyStore();
        try {
            builder.loadKeyMaterial(keyStore, keyPassword);
        }
        catch (UnrecoverableKeyException e) {
            if (keyPassword.length == 0) {
                builder.loadKeyMaterial(keyStore, new char[]{'\u0000'});
            }
            throw e;
        }
        KeyStore trust = this.createTrustStore();
        if (trust != null) {
            builder.loadTrustMaterial(trust, null);
        }
        return builder.build();
    }

    public KeyStore createKeyStore() throws GeneralSecurityException, IOException {
        if (this.properties.getKeyStore() == null) {
            throw new KeyStoreException("Keystore not specified.");
        }
        if (!this.properties.getKeyStore().exists()) {
            throw new KeyStoreException("Keystore not exists: " + this.properties.getKeyStore());
        }
        KeyStore result = KeyStore.getInstance(this.properties.getKeyStoreType());
        char[] keyStorePassword = this.properties.keyStorePassword();
        try {
            SSLContextFactory.loadKeyStore(result, this.properties.getKeyStore(), keyStorePassword);
        }
        catch (IOException e) {
            if (keyStorePassword.length == 0) {
                SSLContextFactory.loadKeyStore(result, this.properties.getKeyStore(), new char[]{'\u0000'});
            }
            throw e;
        }
        return result;
    }

    private static void loadKeyStore(KeyStore keyStore, Resource keyStoreResource, char[] keyStorePassword) throws IOException, GeneralSecurityException {
        try (InputStream inputStream = keyStoreResource.getInputStream();){
            keyStore.load(inputStream, keyStorePassword);
        }
    }

    public KeyStore createTrustStore() throws GeneralSecurityException, IOException {
        if (this.properties.getTrustStore() == null) {
            return null;
        }
        if (!this.properties.getTrustStore().exists()) {
            throw new KeyStoreException("KeyStore not exists: " + this.properties.getTrustStore());
        }
        KeyStore result = KeyStore.getInstance(this.properties.getTrustStoreType());
        try (InputStream input = this.properties.getTrustStore().getInputStream();){
            result.load(input, this.properties.trustStorePassword());
        }
        return result;
    }
}

