/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.tracing.autoconfigure;

import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import org.springframework.boot.context.properties.ConfigurationProperties;

@ConfigurationProperties(value="management.tracing")
public class TracingProperties {
    private final Sampling sampling = new Sampling();
    private final Baggage baggage = new Baggage();
    private final Propagation propagation = new Propagation();
    private final Brave brave = new Brave();
    private final OpenTelemetry opentelemetry = new OpenTelemetry();

    public Sampling getSampling() {
        return this.sampling;
    }

    public Baggage getBaggage() {
        return this.baggage;
    }

    public Propagation getPropagation() {
        return this.propagation;
    }

    public Brave getBrave() {
        return this.brave;
    }

    public OpenTelemetry getOpentelemetry() {
        return this.opentelemetry;
    }

    public static class Sampling {
        private float probability = 0.1f;

        public float getProbability() {
            return this.probability;
        }

        public void setProbability(float probability) {
            this.probability = probability;
        }
    }

    public static class Baggage {
        private boolean enabled = true;
        private Correlation correlation = new Correlation();
        private List<String> remoteFields = new ArrayList<String>();
        private List<String> localFields = new ArrayList<String>();
        private List<String> tagFields = new ArrayList<String>();

        public boolean isEnabled() {
            return this.enabled;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        public Correlation getCorrelation() {
            return this.correlation;
        }

        public void setCorrelation(Correlation correlation) {
            this.correlation = correlation;
        }

        public List<String> getRemoteFields() {
            return this.remoteFields;
        }

        public List<String> getLocalFields() {
            return this.localFields;
        }

        public List<String> getTagFields() {
            return this.tagFields;
        }

        public void setRemoteFields(List<String> remoteFields) {
            this.remoteFields = remoteFields;
        }

        public void setLocalFields(List<String> localFields) {
            this.localFields = localFields;
        }

        public void setTagFields(List<String> tagFields) {
            this.tagFields = tagFields;
        }

        public static class Correlation {
            private boolean enabled = true;
            private List<String> fields = new ArrayList<String>();

            public boolean isEnabled() {
                return this.enabled;
            }

            public void setEnabled(boolean enabled) {
                this.enabled = enabled;
            }

            public List<String> getFields() {
                return this.fields;
            }

            public void setFields(List<String> fields) {
                this.fields = fields;
            }
        }
    }

    public static class Propagation {
        private List<PropagationType> type;
        private List<PropagationType> produce = List.of(PropagationType.W3C);
        private List<PropagationType> consume = List.of(PropagationType.values());

        public void setType(List<PropagationType> type) {
            this.type = type;
        }

        public void setProduce(List<PropagationType> produce) {
            this.produce = produce;
        }

        public void setConsume(List<PropagationType> consume) {
            this.consume = consume;
        }

        public List<PropagationType> getType() {
            return this.type;
        }

        public List<PropagationType> getProduce() {
            return this.produce;
        }

        public List<PropagationType> getConsume() {
            return this.consume;
        }

        List<PropagationType> getEffectiveProducedTypes() {
            return this.type != null ? this.type : this.produce;
        }

        List<PropagationType> getEffectiveConsumedTypes() {
            return this.type != null ? this.type : this.consume;
        }

        public static enum PropagationType {
            W3C,
            B3,
            B3_MULTI;

        }
    }

    public static class Brave {
        private boolean spanJoiningSupported = false;

        public boolean isSpanJoiningSupported() {
            return this.spanJoiningSupported;
        }

        public void setSpanJoiningSupported(boolean spanJoiningSupported) {
            this.spanJoiningSupported = spanJoiningSupported;
        }
    }

    public static class OpenTelemetry {
        private final Export export = new Export();

        public Export getExport() {
            return this.export;
        }

        public static class Export {
            private boolean includeUnsampled;
            private Duration timeout = Duration.ofSeconds(30L);
            private int maxBatchSize = 512;
            private int maxQueueSize = 2048;
            private Duration scheduleDelay = Duration.ofSeconds(5L);

            public boolean isIncludeUnsampled() {
                return this.includeUnsampled;
            }

            public void setIncludeUnsampled(boolean includeUnsampled) {
                this.includeUnsampled = includeUnsampled;
            }

            public Duration getTimeout() {
                return this.timeout;
            }

            public void setTimeout(Duration timeout) {
                this.timeout = timeout;
            }

            public int getMaxBatchSize() {
                return this.maxBatchSize;
            }

            public void setMaxBatchSize(int maxBatchSize) {
                this.maxBatchSize = maxBatchSize;
            }

            public int getMaxQueueSize() {
                return this.maxQueueSize;
            }

            public void setMaxQueueSize(int maxQueueSize) {
                this.maxQueueSize = maxQueueSize;
            }

            public Duration getScheduleDelay() {
                return this.scheduleDelay;
            }

            public void setScheduleDelay(Duration scheduleDelay) {
                this.scheduleDelay = scheduleDelay;
            }
        }
    }
}

