/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.servlet.autoconfigure;

import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBooleanProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.servlet.autoconfigure.ServletEncodingProperties;
import org.springframework.boot.servlet.filter.OrderedCharacterEncodingFilter;
import org.springframework.context.annotation.Bean;
import org.springframework.web.filter.CharacterEncodingFilter;

@AutoConfiguration
@EnableConfigurationProperties(value={ServletEncodingProperties.class})
@ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.SERVLET)
@ConditionalOnClass(value={CharacterEncodingFilter.class})
@ConditionalOnBooleanProperty(name={"spring.servlet.encoding.enabled"}, matchIfMissing=true)
public class HttpEncodingAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    public CharacterEncodingFilter characterEncodingFilter(ServletEncodingProperties properties) {
        OrderedCharacterEncodingFilter filter = new OrderedCharacterEncodingFilter();
        filter.setEncoding(properties.getCharset().name());
        filter.setForceRequestEncoding(properties.shouldForce(ServletEncodingProperties.HttpMessageType.REQUEST));
        filter.setForceResponseEncoding(properties.shouldForce(ServletEncodingProperties.HttpMessageType.RESPONSE));
        return filter;
    }
}

