/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.servlet.actuate.exchanges;

import jakarta.servlet.http.HttpServletResponse;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.springframework.boot.actuate.web.exchanges.RecordableHttpResponse;

final class RecordableServletHttpResponse
implements RecordableHttpResponse {
    private final HttpServletResponse delegate;
    private final int status;

    RecordableServletHttpResponse(HttpServletResponse response, int status) {
        this.delegate = response;
        this.status = status;
    }

    public int getStatus() {
        return this.status;
    }

    public Map<String, List<String>> getHeaders() {
        LinkedHashMap<String, List<String>> headers = new LinkedHashMap<String, List<String>>();
        for (String name : this.delegate.getHeaderNames()) {
            headers.put(name, new ArrayList(this.delegate.getHeaders(name)));
        }
        return headers;
    }
}

