/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.micrometer.observation.autoconfigure;

import io.micrometer.common.annotation.ValueExpressionResolver;
import org.jspecify.annotations.Nullable;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.ExpressionParser;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.SimpleEvaluationContext;
import org.springframework.util.Assert;

class SpelValueExpressionResolver
implements ValueExpressionResolver {
    private final ExpressionParser expressionParser = new SpelExpressionParser();

    SpelValueExpressionResolver() {
    }

    public String resolve(String expression, @Nullable Object parameter) {
        try {
            SimpleEvaluationContext context = SimpleEvaluationContext.forReadOnlyDataBinding().build();
            Expression expressionToEvaluate = this.expressionParser.parseExpression(expression);
            String value = (String)expressionToEvaluate.getValue((EvaluationContext)context, parameter, String.class);
            Assert.state((value != null ? 1 : 0) != 0, (String)"'value' must not be null");
            return value;
        }
        catch (Exception ex) {
            throw new IllegalStateException("Unable to evaluate SpEL expression '%s'".formatted(expression), ex);
        }
    }
}

