/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.metrics.autoconfigure.export.atlas;

import com.netflix.spectator.atlas.AtlasConfig;
import io.micrometer.atlas.AtlasMeterRegistry;
import io.micrometer.core.instrument.Clock;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.metrics.autoconfigure.CompositeMeterRegistryAutoConfiguration;
import org.springframework.boot.metrics.autoconfigure.MetricsAutoConfiguration;
import org.springframework.boot.metrics.autoconfigure.export.ConditionalOnEnabledMetricsExport;
import org.springframework.boot.metrics.autoconfigure.export.atlas.AtlasProperties;
import org.springframework.boot.metrics.autoconfigure.export.atlas.AtlasPropertiesConfigAdapter;
import org.springframework.boot.metrics.autoconfigure.export.simple.SimpleMetricsExportAutoConfiguration;
import org.springframework.context.annotation.Bean;

@AutoConfiguration(before={CompositeMeterRegistryAutoConfiguration.class, SimpleMetricsExportAutoConfiguration.class}, after={MetricsAutoConfiguration.class})
@ConditionalOnBean(value={Clock.class})
@ConditionalOnClass(value={AtlasMeterRegistry.class})
@ConditionalOnEnabledMetricsExport(value="atlas")
@EnableConfigurationProperties(value={AtlasProperties.class})
public class AtlasMetricsExportAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    public AtlasConfig atlasConfig(AtlasProperties atlasProperties) {
        return new AtlasPropertiesConfigAdapter(atlasProperties);
    }

    @Bean
    @ConditionalOnMissingBean
    public AtlasMeterRegistry atlasMeterRegistry(AtlasConfig atlasConfig, Clock clock) {
        return new AtlasMeterRegistry(atlasConfig, clock);
    }
}

