/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.health.contributor;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Stream;
import org.springframework.boot.health.contributor.CompositeReactiveHealthContributor;
import org.springframework.boot.health.contributor.ReactiveHealthContributor;
import org.springframework.boot.health.contributor.ReactiveHealthContributors;
import org.springframework.util.Assert;

class MapCompositeReactiveHealthContributor<V>
implements CompositeReactiveHealthContributor {
    private final Map<String, ReactiveHealthContributor> contributors;

    MapCompositeReactiveHealthContributor(Map<String, V> map, Function<V, ? extends ReactiveHealthContributor> valueAdapter) {
        Assert.notNull(map, (String)"'map' must not be null");
        Assert.notNull(valueAdapter, (String)"'valueAdapter' must not be null");
        LinkedHashMap contributors = new LinkedHashMap();
        map.forEach((? super K key, ? super V value) -> {
            Assert.notNull((Object)key, (String)"'map' must not contain null keys");
            Assert.notNull((Object)value, (String)"'map' must not contain null values");
            Assert.isTrue((!key.contains("/") ? 1 : 0) != 0, (String)"'map' keys must not contain a '/'");
            contributors.put(key, (ReactiveHealthContributor)valueAdapter.apply(value));
        });
        this.contributors = Collections.unmodifiableMap(contributors);
    }

    @Override
    public ReactiveHealthContributor getContributor(String name) {
        return this.contributors.get(name);
    }

    @Override
    public Stream<ReactiveHealthContributors.Entry> stream() {
        return this.contributors.entrySet().stream().map(entry -> new ReactiveHealthContributors.Entry((String)entry.getKey(), (ReactiveHealthContributor)entry.getValue()));
    }
}

