/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.data.redis.autoconfigure.health;

import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.data.redis.autoconfigure.RedisReactiveAutoConfiguration;
import org.springframework.boot.data.redis.health.RedisReactiveHealthIndicator;
import org.springframework.boot.health.autoconfigure.contributor.CompositeReactiveHealthContributorConfiguration;
import org.springframework.boot.health.autoconfigure.contributor.ConditionalOnEnabledHealthIndicator;
import org.springframework.boot.health.contributor.ReactiveHealthContributor;
import org.springframework.boot.health.contributor.ReactiveHealthIndicator;
import org.springframework.context.annotation.Bean;
import org.springframework.data.redis.connection.ReactiveRedisConnectionFactory;
import reactor.core.publisher.Flux;

@AutoConfiguration(after={RedisReactiveAutoConfiguration.class})
@ConditionalOnClass(value={ReactiveRedisConnectionFactory.class, Flux.class, ReactiveHealthIndicator.class, ConditionalOnEnabledHealthIndicator.class})
@ConditionalOnBean(value={ReactiveRedisConnectionFactory.class})
@ConditionalOnEnabledHealthIndicator(value="redis")
public class RedisReactiveHealthContributorAutoConfiguration
extends CompositeReactiveHealthContributorConfiguration<RedisReactiveHealthIndicator, ReactiveRedisConnectionFactory> {
    RedisReactiveHealthContributorAutoConfiguration() {
        super(RedisReactiveHealthIndicator::new);
    }

    @Bean
    @ConditionalOnMissingBean(name={"redisHealthIndicator", "redisHealthContributor"})
    public ReactiveHealthContributor redisHealthContributor(ConfigurableListableBeanFactory beanFactory) {
        return (ReactiveHealthContributor)this.createContributor(beanFactory, ReactiveRedisConnectionFactory.class);
    }
}

