/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v129.network.model;

import java.util.Objects;
import org.openqa.selenium.Beta;
import org.openqa.selenium.devtools.v129.network.model.MonotonicTime;
import org.openqa.selenium.devtools.v129.network.model.RequestId;
import org.openqa.selenium.devtools.v129.network.model.ResourcePriority;
import org.openqa.selenium.json.JsonInput;

@Beta
public class ResourceChangedPriority {
    private final RequestId requestId;
    private final ResourcePriority newPriority;
    private final MonotonicTime timestamp;

    public ResourceChangedPriority(RequestId requestId, ResourcePriority newPriority, MonotonicTime timestamp) {
        this.requestId = Objects.requireNonNull(requestId, "requestId is required");
        this.newPriority = Objects.requireNonNull(newPriority, "newPriority is required");
        this.timestamp = Objects.requireNonNull(timestamp, "timestamp is required");
    }

    public RequestId getRequestId() {
        return this.requestId;
    }

    public ResourcePriority getNewPriority() {
        return this.newPriority;
    }

    public MonotonicTime getTimestamp() {
        return this.timestamp;
    }

    private static ResourceChangedPriority fromJson(JsonInput input) {
        RequestId requestId = null;
        ResourcePriority newPriority = null;
        MonotonicTime timestamp = null;
        input.beginObject();
        block10: while (input.hasNext()) {
            switch (input.nextName()) {
                case "requestId": {
                    requestId = (RequestId)input.read(RequestId.class);
                    continue block10;
                }
                case "newPriority": {
                    newPriority = (ResourcePriority)((Object)input.read(ResourcePriority.class));
                    continue block10;
                }
                case "timestamp": {
                    timestamp = (MonotonicTime)input.read(MonotonicTime.class);
                    continue block10;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new ResourceChangedPriority(requestId, newPriority, timestamp);
    }
}

