/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v127.storage.model;

import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.openqa.selenium.devtools.v127.network.model.TimeSinceEpoch;
import org.openqa.selenium.devtools.v127.storage.model.InterestGroupAuctionEventType;
import org.openqa.selenium.devtools.v127.storage.model.InterestGroupAuctionId;
import org.openqa.selenium.json.JsonInput;

public class InterestGroupAuctionEventOccurred {
    private final TimeSinceEpoch eventTime;
    private final InterestGroupAuctionEventType type;
    private final InterestGroupAuctionId uniqueAuctionId;
    private final Optional<InterestGroupAuctionId> parentAuctionId;
    private final Optional<Map<String, Object>> auctionConfig;

    public InterestGroupAuctionEventOccurred(TimeSinceEpoch eventTime, InterestGroupAuctionEventType type, InterestGroupAuctionId uniqueAuctionId, Optional<InterestGroupAuctionId> parentAuctionId, Optional<Map<String, Object>> auctionConfig) {
        this.eventTime = Objects.requireNonNull(eventTime, "eventTime is required");
        this.type = Objects.requireNonNull(type, "type is required");
        this.uniqueAuctionId = Objects.requireNonNull(uniqueAuctionId, "uniqueAuctionId is required");
        this.parentAuctionId = parentAuctionId;
        this.auctionConfig = auctionConfig;
    }

    public TimeSinceEpoch getEventTime() {
        return this.eventTime;
    }

    public InterestGroupAuctionEventType getType() {
        return this.type;
    }

    public InterestGroupAuctionId getUniqueAuctionId() {
        return this.uniqueAuctionId;
    }

    public Optional<InterestGroupAuctionId> getParentAuctionId() {
        return this.parentAuctionId;
    }

    public Optional<Map<String, Object>> getAuctionConfig() {
        return this.auctionConfig;
    }

    private static InterestGroupAuctionEventOccurred fromJson(JsonInput input) {
        TimeSinceEpoch eventTime = null;
        InterestGroupAuctionEventType type = null;
        InterestGroupAuctionId uniqueAuctionId = null;
        Optional<InterestGroupAuctionId> parentAuctionId = Optional.empty();
        Optional<Map<String, Object>> auctionConfig = Optional.empty();
        input.beginObject();
        block14: while (input.hasNext()) {
            switch (input.nextName()) {
                case "eventTime": {
                    eventTime = (TimeSinceEpoch)input.read(TimeSinceEpoch.class);
                    continue block14;
                }
                case "type": {
                    type = (InterestGroupAuctionEventType)((Object)input.read(InterestGroupAuctionEventType.class));
                    continue block14;
                }
                case "uniqueAuctionId": {
                    uniqueAuctionId = (InterestGroupAuctionId)input.read(InterestGroupAuctionId.class);
                    continue block14;
                }
                case "parentAuctionId": {
                    parentAuctionId = Optional.ofNullable((InterestGroupAuctionId)input.read(InterestGroupAuctionId.class));
                    continue block14;
                }
                case "auctionConfig": {
                    auctionConfig = Optional.ofNullable((Map)input.read(Map.class));
                    continue block14;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new InterestGroupAuctionEventOccurred(eventTime, type, uniqueAuctionId, parentAuctionId, auctionConfig);
    }
}

