/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.commons.xml;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.xml.transform.Source;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.openehealth.ipf.commons.core.modules.api.ValidationException;
import org.openehealth.ipf.commons.xml.AbstractCachingXmlProcessor;
import org.openehealth.ipf.commons.xml.LSResourceResolverImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class XsdValidator
extends AbstractCachingXmlProcessor<Schema>
implements org.openehealth.ipf.commons.core.modules.api.Validator<Source, String> {
    private static final Logger log = LoggerFactory.getLogger(XsdValidator.class);
    private static final ConcurrentMap<String, AbstractCachingXmlProcessor.Loader<Schema>> XSD_CACHE = new ConcurrentHashMap<String, AbstractCachingXmlProcessor.Loader<Schema>>();
    private static final LSResourceResolverImpl RESOURCE_RESOLVER = new LSResourceResolverImpl();
    private String schemaLanguage = "http://www.w3.org/2001/XMLSchema";

    public XsdValidator() {
        super(null);
    }

    public XsdValidator(ClassLoader classloader) {
        super(classloader);
    }

    @Override
    protected ConcurrentMap<String, AbstractCachingXmlProcessor.Loader<Schema>> getCache() {
        return XSD_CACHE;
    }

    public void validate(Source message, String schema) {
        List<ValidationException> exceptions = this.doValidate(message, schema);
        if (!exceptions.isEmpty()) {
            throw new ValidationException(exceptions);
        }
    }

    protected List<ValidationException> doValidate(Source message, String schemaResource) {
        try {
            log.debug("Validating XML message");
            Schema schema = (Schema)this.resource(schemaResource);
            Validator validator = schema.newValidator();
            CollectingErrorHandler errorHandler = new CollectingErrorHandler();
            validator.setErrorHandler(errorHandler);
            validator.validate(message);
            List<ValidationException> exceptions = errorHandler.getExceptions();
            if (!exceptions.isEmpty()) {
                log.debug("Message validation found {} problems", (Object)exceptions.size());
            } else {
                log.debug("Message validation successful");
            }
            return exceptions;
        }
        catch (Exception e) {
            return Collections.singletonList(new ValidationException("Unexpected validation failure because " + e.getMessage(), (Throwable)e));
        }
    }

    @Override
    protected Schema createResource(Object ... params) {
        SchemaFactory factory = SchemaFactory.newInstance(this.getSchemaLanguage());
        factory.setResourceResolver(RESOURCE_RESOLVER);
        try {
            factory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
            return factory.newSchema(this.resourceContent(params));
        }
        catch (SAXException e) {
            throw new IllegalArgumentException("Could not initialize XSD schema", e);
        }
    }

    public String getSchemaLanguage() {
        return this.schemaLanguage;
    }

    public void setSchemaLanguage(String schemaLanguage) {
        this.schemaLanguage = schemaLanguage;
    }

    private static class CollectingErrorHandler
    implements ErrorHandler {
        private final List<ValidationException> exceptions = new ArrayList<ValidationException>();

        private CollectingErrorHandler() {
        }

        @Override
        public void error(SAXParseException exception) {
            this.add(exception);
        }

        @Override
        public void fatalError(SAXParseException exception) {
            this.add(exception);
        }

        @Override
        public void warning(SAXParseException exception) {
        }

        private void add(SAXParseException exception) {
            this.exceptions.add(new ValidationException((Throwable)exception));
        }

        public List<ValidationException> getExceptions() {
            return this.exceptions;
        }
    }
}

