/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.commons.xml;

import com.saxonica.xqj.SaxonXQConnection;
import com.saxonica.xqj.SaxonXQDataSource;
import java.io.InputStream;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.xml.namespace.QName;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.xquery.XQConstants;
import javax.xml.xquery.XQDynamicContext;
import javax.xml.xquery.XQException;
import javax.xml.xquery.XQPreparedExpression;
import javax.xml.xquery.XQResultSequence;
import lombok.Generated;
import net.sf.saxon.Configuration;
import net.sf.saxon.lib.ResourceResolver;
import org.openehealth.ipf.commons.core.modules.api.Transmogrifier;
import org.openehealth.ipf.commons.xml.AbstractCachingXmlProcessor;
import org.openehealth.ipf.commons.xml.ClasspathResourceResolver;
import org.openehealth.ipf.commons.xml.ResultHolder;
import org.openehealth.ipf.commons.xml.ResultHolderFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XqjTransmogrifier<T>
extends AbstractCachingXmlProcessor<XQPreparedExpression>
implements Transmogrifier<Source, T> {
    private static final Logger log = LoggerFactory.getLogger(XqjTransmogrifier.class);
    private static final ConcurrentMap<String, AbstractCachingXmlProcessor.Loader<XQPreparedExpression>> XQUERY_CACHE = new ConcurrentHashMap<String, AbstractCachingXmlProcessor.Loader<XQPreparedExpression>>();
    private static final Configuration XQUERY_GLOBAL_CONFIG = new Configuration();
    private static final SaxonXQDataSource DATA_SOURCE;
    private final Class<T> outputFormat;
    private SaxonXQConnection connection;
    private Map<String, Object> staticParams;

    public XqjTransmogrifier() {
        this(String.class);
    }

    public XqjTransmogrifier(Class<T> outputFormat) {
        this(outputFormat, null, null);
    }

    public XqjTransmogrifier(Class<T> outputFormat, ClassLoader classLoader) {
        this(outputFormat, classLoader, null);
    }

    public XqjTransmogrifier(Class<T> outputFormat, Map<String, Object> globalParams) {
        this(outputFormat, null, globalParams);
    }

    public XqjTransmogrifier(Class<T> outputFormat, ClassLoader classLoader, Map<String, Object> globalParams) {
        super(classLoader);
        this.outputFormat = outputFormat;
        if (globalParams != null) {
            for (Map.Entry<String, Object> entry : globalParams.entrySet()) {
                XQUERY_GLOBAL_CONFIG.setConfigurationProperty(entry.getKey(), entry.getValue());
            }
        }
    }

    @Override
    protected ConcurrentMap<String, AbstractCachingXmlProcessor.Loader<XQPreparedExpression>> getCache() {
        return XQUERY_CACHE;
    }

    public T zap(Source source, Object ... params) {
        ResultHolder<T> accessor = ResultHolderFactory.create(this.outputFormat);
        if (accessor == null) {
            throw new IllegalArgumentException("Format " + this.outputFormat + " is not supported");
        }
        Result result = accessor.createResult();
        this.doZap(source, result, params);
        return accessor.getResult();
    }

    private void doZap(Source source, Result result, Object ... params) {
        XQResultSequence seq = null;
        try {
            XQPreparedExpression expression = this.resource(params);
            expression.bindDocument(XQConstants.CONTEXT_ITEM, source, null);
            this.bindExpressionContext((XQDynamicContext)expression, this.staticParams);
            this.bindExpressionContext((XQDynamicContext)expression, this.resourceParameters(params));
            seq = expression.executeQuery();
            seq.writeSequenceToResult(result);
        }
        catch (Exception e) {
            throw new RuntimeException("XQuery processing failed", e);
        }
        finally {
            if (seq != null && !seq.isClosed()) {
                try {
                    seq.close();
                }
                catch (XQException e) {
                    log.trace("XQLTransmogrifier didn't return a value.", (Throwable)e);
                }
            }
        }
    }

    private void bindExpressionContext(XQDynamicContext exp, Map<String, Object> params) throws XQException {
        if (params == null) {
            return;
        }
        for (Map.Entry<String, Object> entry : params.entrySet()) {
            if (entry.getKey().equalsIgnoreCase("org.openehealth.ipf.commons.xml.ResourceLocation")) continue;
            Object value = entry.getValue();
            if (value instanceof String) {
                String s = (String)value;
                exp.bindString(new QName(entry.getKey()), s, null);
                continue;
            }
            if (value instanceof Source) {
                exp.bindDocument(new QName(entry.getKey()), (Source)entry.getValue(), null);
                continue;
            }
            if (value instanceof Boolean) {
                exp.bindBoolean(new QName(entry.getKey()), ((Boolean)entry.getValue()).booleanValue(), null);
                continue;
            }
            exp.bindAtomicValue(new QName(entry.getKey()), (String)entry.getValue(), null);
        }
    }

    @Override
    protected XQPreparedExpression resource(Object ... params) throws Exception {
        XQPreparedExpression expression = (XQPreparedExpression)super.resource(params);
        return this.getConnection().copyPreparedExpression(expression);
    }

    @Override
    public XQPreparedExpression createResource(Object ... params) {
        String resourceLocation = this.resourceLocation(params);
        log.debug("Create new template for {}", (Object)resourceLocation);
        try {
            InputStream stream = this.resourceContent(params).getInputStream();
            return this.getConnection().prepareExpression(stream);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("The resource " + resourceLocation + " is not valid", e);
        }
    }

    private synchronized SaxonXQConnection getConnection() {
        if (this.connection == null) {
            this.connection = (SaxonXQConnection)DATA_SOURCE.getConnection();
        }
        return this.connection;
    }

    @Generated
    public Map<String, Object> getStaticParams() {
        return this.staticParams;
    }

    @Generated
    public void setStaticParams(Map<String, Object> staticParams) {
        this.staticParams = staticParams;
    }

    static {
        XQUERY_GLOBAL_CONFIG.setResourceResolver((ResourceResolver)new ClasspathResourceResolver(XQUERY_GLOBAL_CONFIG.getResourceResolver()));
        DATA_SOURCE = new SaxonXQDataSource(XQUERY_GLOBAL_CONFIG);
    }
}

