/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.commons.xml;

import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.Marshaller;
import java.io.ByteArrayOutputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.w3c.dom.Node;

public abstract class XmlUtils {
    private static final Pattern ROOT_ELEMENT_PATTERN = Pattern.compile("(?:<\\?xml.+?\\?>)?(?:\\s*<!--.*?-->)*\\s*<(?:[\\w.-]+?:)?([\\w.-]+)(?:\\s|(?:/?>))", 32);

    private XmlUtils() {
        throw new IllegalStateException("Cannot instantiate helper class");
    }

    public static Source source(String s) {
        return new StreamSource(new StringReader(s));
    }

    public static String rootElementName(String s) {
        if (s == null) {
            return null;
        }
        Matcher matcher = ROOT_ELEMENT_PATTERN.matcher(s);
        return matcher.find() && matcher.start() == 0 ? matcher.group(1) : null;
    }

    public static String renderJaxb(JAXBContext jaxbContext, Object object, Boolean prettyPrint) {
        try {
            Marshaller marshaller = jaxbContext.createMarshaller();
            marshaller.setProperty("jaxb.fragment", (Object)Boolean.TRUE);
            marshaller.setProperty("jaxb.formatted.output", (Object)prettyPrint);
            marshaller.setProperty("jaxb.encoding", (Object)StandardCharsets.UTF_8.name());
            StringWriter writer = new StringWriter();
            marshaller.marshal(object, (Writer)writer);
            return writer.toString();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static byte[] serialize(Node inputNode) throws Exception {
        ByteArrayOutputStream serializerOutput = new ByteArrayOutputStream();
        DOMSource sourceObject = new DOMSource(inputNode);
        StreamResult targetObject = new StreamResult(serializerOutput);
        TransformerFactory serializerFactory = TransformerFactory.newInstance();
        Transformer serializer = serializerFactory.newTransformer();
        serializer.setOutputProperty("indent", "yes");
        serializer.setOutputProperty("omit-xml-declaration", "yes");
        serializer.transform(sourceObject, targetObject);
        return serializerOutput.toByteArray();
    }
}

