/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.commons.xml;

import java.io.StringReader;
import java.util.Map;
import javax.xml.transform.Source;
import javax.xml.transform.Templates;
import javax.xml.transform.stream.StreamSource;
import org.openehealth.ipf.commons.xml.SchematronProfile;
import org.openehealth.ipf.commons.xml.XsltTransmogrifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SchematronTransmogrifier<T>
extends XsltTransmogrifier<T> {
    private static final Logger log = LoggerFactory.getLogger(SchematronTransmogrifier.class);
    private final XsltTransmogrifier<String> xsltTransmogrifier;

    public SchematronTransmogrifier() {
        this(String.class);
    }

    public SchematronTransmogrifier(Class<T> outputFormat) {
        this(new XsltTransmogrifier<String>(String.class), outputFormat);
    }

    public SchematronTransmogrifier(Class<T> outputFormat, Map<String, Object> staticParams) {
        this(new XsltTransmogrifier<String>(String.class), outputFormat, staticParams);
    }

    public SchematronTransmogrifier(XsltTransmogrifier<String> t, Class<T> outputFormat) {
        super(outputFormat);
        this.xsltTransmogrifier = t;
    }

    public SchematronTransmogrifier(XsltTransmogrifier<String> t, Class<T> outputFormat, Map<String, Object> staticParams) {
        super(outputFormat, staticParams);
        this.xsltTransmogrifier = t;
    }

    @Override
    protected String resourceCacheKey(Object ... params) {
        SchematronProfile schematronProfile;
        Map<String, Object> parameters;
        String phase = null;
        Object object = params[0];
        if (object instanceof SchematronProfile && (parameters = (schematronProfile = (SchematronProfile)object).getParameters()) != null) {
            phase = (String)parameters.get("phase");
        }
        return phase != null ? this.resourceLocation(params) + "\n" + phase : this.resourceLocation(params);
    }

    @Override
    protected Templates createResource(Object ... params) {
        try {
            log.debug("Creating new Schematron stylesheet");
            StreamSource rules = this.resourceContent(params);
            Map<String, Object> parameters = this.resourceParameters(params);
            log.debug("step 1 of 3");
            Source source = SchematronTransmogrifier.step(this.xsltTransmogrifier, rules, "/schematron/iso_dsdl_include.xsl", parameters);
            log.debug("step 2 of 3");
            source = SchematronTransmogrifier.step(this.xsltTransmogrifier, source, "/schematron/iso_abstract_expand.xsl", parameters);
            log.debug("step 3 of 3");
            source = SchematronTransmogrifier.step(this.xsltTransmogrifier, source, "/schematron/iso_svrl_for_xslt2.xsl", parameters);
            Templates template = this.getFactory().newTemplates(source);
            log.debug("done!");
            return template;
        }
        catch (Exception e) {
            throw new IllegalArgumentException("The schematron rules resource " + this.resourceLocation(params) + " is not valid", e);
        }
    }

    private static Source step(XsltTransmogrifier<String> t, Source input, String stylesheet, Map<String, Object> params) {
        String s = t.zap(input, stylesheet, params);
        return new StreamSource(new StringReader(s));
    }
}

