/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.commons.xml;

import java.io.InputStream;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.URIResolver;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamSource;

class ClasspathUriResolver
implements URIResolver {
    private final URIResolver standardResolver;

    public ClasspathUriResolver(URIResolver resolver) {
        this.standardResolver = resolver;
    }

    @Override
    public Source resolve(String href, String base) throws TransformerException {
        InputStream inputStream = this.getClass().getClassLoader().getResourceAsStream(href);
        if (inputStream != null) {
            return new StreamSource(inputStream);
        }
        Source source = this.standardResolver.resolve(href, base);
        if (source instanceof SAXSource) {
            SAXSource saxSource = (SAXSource)source;
            return new StreamSource(saxSource.getInputSource().getByteStream());
        }
        return source;
    }
}

