/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.commons.ihe.xds.core.validate.requests;

import jakarta.activation.DataHandler;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import lombok.Generated;
import org.openehealth.ipf.commons.core.modules.api.Validator;
import org.openehealth.ipf.commons.ihe.xds.core.ebxml.EbXMLProvideAndRegisterDocumentSetRequest;
import org.openehealth.ipf.commons.ihe.xds.core.ebxml.EbXMLRegistryObject;
import org.openehealth.ipf.commons.ihe.xds.core.ebxml.ebxml30.ProvideAndRegisterDocumentSetRequestType;
import org.openehealth.ipf.commons.ihe.xds.core.metadata.DocumentEntryType;
import org.openehealth.ipf.commons.ihe.xds.core.validate.ValidationMessage;
import org.openehealth.ipf.commons.ihe.xds.core.validate.ValidationProfile;
import org.openehealth.ipf.commons.ihe.xds.core.validate.ValidatorAssertions;
import org.openehealth.ipf.commons.ihe.xds.core.validate.requests.SubmitObjectsRequestValidator;

public class ProvideAndRegisterDocumentSetRequestValidator
implements Validator<EbXMLProvideAndRegisterDocumentSetRequest<ProvideAndRegisterDocumentSetRequestType>, ValidationProfile> {
    private final SubmitObjectsRequestValidator submitObjectsRequestValidator = SubmitObjectsRequestValidator.getInstance();
    private static final ProvideAndRegisterDocumentSetRequestValidator instance = new ProvideAndRegisterDocumentSetRequestValidator();

    private ProvideAndRegisterDocumentSetRequestValidator() {
    }

    public void validate(EbXMLProvideAndRegisterDocumentSetRequest<ProvideAndRegisterDocumentSetRequestType> request, ValidationProfile profile) {
        Objects.requireNonNull(request, "request cannot be null");
        this.submitObjectsRequestValidator.validate(request, profile);
        this.validateDocuments(request);
    }

    private void validateDocuments(EbXMLProvideAndRegisterDocumentSetRequest<ProvideAndRegisterDocumentSetRequestType> request) {
        Map<String, DataHandler> documents = request.getDocuments();
        HashSet docEntryIds = new HashSet();
        request.getExtrinsicObjects(DocumentEntryType.STABLE.getUuid()).stream().map(EbXMLRegistryObject::getId).filter(Objects::nonNull).forEach(docId -> {
            docEntryIds.add(docId);
            ValidatorAssertions.metaDataAssert(documents.get(docId) != null, ValidationMessage.MISSING_DOCUMENT_FOR_DOC_ENTRY, docId);
        });
        documents.keySet().forEach(docId -> ValidatorAssertions.metaDataAssert(docEntryIds.contains(docId), ValidationMessage.MISSING_DOC_ENTRY_FOR_DOCUMENT, docId));
    }

    @Generated
    public static ProvideAndRegisterDocumentSetRequestValidator getInstance() {
        return instance;
    }
}

