/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.commons.ihe.xds.core.validate.requests;

import java.util.Objects;
import lombok.Generated;
import org.openehealth.ipf.commons.core.modules.api.Validator;
import org.openehealth.ipf.commons.ihe.xds.XdsIntegrationProfile;
import org.openehealth.ipf.commons.ihe.xds.core.ebxml.EbXMLNonconstructiveDocumentSetRequest;
import org.openehealth.ipf.commons.ihe.xds.core.validate.HomeCommunityIdValidator;
import org.openehealth.ipf.commons.ihe.xds.core.validate.ValidationMessage;
import org.openehealth.ipf.commons.ihe.xds.core.validate.ValidationProfile;
import org.openehealth.ipf.commons.ihe.xds.core.validate.ValidatorAssertions;

public class NonconstructiveDocumentSetRequestValidator
implements Validator<EbXMLNonconstructiveDocumentSetRequest<?>, ValidationProfile> {
    private final HomeCommunityIdValidator hcValidator = new HomeCommunityIdValidator(true);
    private static final NonconstructiveDocumentSetRequestValidator instance = new NonconstructiveDocumentSetRequestValidator();

    private NonconstructiveDocumentSetRequestValidator() {
    }

    public void validate(EbXMLNonconstructiveDocumentSetRequest<?> request, ValidationProfile profile) {
        Objects.requireNonNull(request, "request cannot be null");
        request.getDocuments().forEach(document -> {
            String repoId = document.getRepositoryUniqueId();
            ValidatorAssertions.metaDataAssert(repoId != null && !repoId.isEmpty(), ValidationMessage.REPO_ID_MUST_BE_SPECIFIED, new Object[0]);
            String docId = document.getDocumentUniqueId();
            ValidatorAssertions.metaDataAssert(docId != null && !docId.isEmpty(), ValidationMessage.DOC_ID_MUST_BE_SPECIFIED, new Object[0]);
            if (profile.getInteractionProfile().getHomeCommunityIdOptionality() != XdsIntegrationProfile.HomeCommunityIdOptionality.NEVER) {
                this.hcValidator.validate(document.getHomeCommunityId());
            }
        });
    }

    @Generated
    public static NonconstructiveDocumentSetRequestValidator getInstance() {
        return instance;
    }
}

