/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.commons.ihe.xds.core.validate.requests;

import java.util.Arrays;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.openehealth.ipf.commons.core.modules.api.Validator;
import org.openehealth.ipf.commons.ihe.core.InteractionId;
import org.openehealth.ipf.commons.ihe.xds.CMPD;
import org.openehealth.ipf.commons.ihe.xds.XCA;
import org.openehealth.ipf.commons.ihe.xds.XCF;
import org.openehealth.ipf.commons.ihe.xds.XDS;
import org.openehealth.ipf.commons.ihe.xds.XdsIntegrationProfile;
import org.openehealth.ipf.commons.ihe.xds.core.ebxml.EbXMLAdhocQueryRequest;
import org.openehealth.ipf.commons.ihe.xds.core.requests.query.QueryReturnType;
import org.openehealth.ipf.commons.ihe.xds.core.requests.query.QueryType;
import org.openehealth.ipf.commons.ihe.xds.core.stub.ebrs30.query.AdhocQueryRequest;
import org.openehealth.ipf.commons.ihe.xds.core.transform.requests.QueryParameter;
import org.openehealth.ipf.commons.ihe.xds.core.validate.CXValidator;
import org.openehealth.ipf.commons.ihe.xds.core.validate.NopValidator;
import org.openehealth.ipf.commons.ihe.xds.core.validate.OIDValidator;
import org.openehealth.ipf.commons.ihe.xds.core.validate.SlotLengthAndNameUniquenessValidator;
import org.openehealth.ipf.commons.ihe.xds.core.validate.ValidationMessage;
import org.openehealth.ipf.commons.ihe.xds.core.validate.ValidationProfile;
import org.openehealth.ipf.commons.ihe.xds.core.validate.ValidatorAssertions;
import org.openehealth.ipf.commons.ihe.xds.core.validate.XDSMetaDataException;
import org.openehealth.ipf.commons.ihe.xds.core.validate.query.AssociationValidation;
import org.openehealth.ipf.commons.ihe.xds.core.validate.query.ChoiceValidation;
import org.openehealth.ipf.commons.ihe.xds.core.validate.query.CodeValidation;
import org.openehealth.ipf.commons.ihe.xds.core.validate.query.DocumentEntryTypeValidation;
import org.openehealth.ipf.commons.ihe.xds.core.validate.query.HomeCommunityIdValidation;
import org.openehealth.ipf.commons.ihe.xds.core.validate.query.QueryListCodeValidation;
import org.openehealth.ipf.commons.ihe.xds.core.validate.query.QueryParameterValidation;
import org.openehealth.ipf.commons.ihe.xds.core.validate.query.StatusValidation;
import org.openehealth.ipf.commons.ihe.xds.core.validate.query.StringListValidation;
import org.openehealth.ipf.commons.ihe.xds.core.validate.query.StringValidation;
import org.openehealth.ipf.commons.ihe.xds.core.validate.query.TimestampValidation;

public class AdhocQueryRequestValidator
implements Validator<EbXMLAdhocQueryRequest<AdhocQueryRequest>, ValidationProfile> {
    private static final AdhocQueryRequestValidator instance = new AdhocQueryRequestValidator();
    private static final CXValidator cxValidator = new CXValidator(true);
    private static final OIDValidator oidValidator = new OIDValidator();
    private static final NopValidator nopValidator = new NopValidator();
    private static final Map<QueryType, Set<String>> ALLOWED_MULTIPLE_SLOTS = new EnumMap<QueryType, Set<String>>(QueryType.class);
    private static final Map<InteractionId, Set<QueryType>> ALLOWED_QUERY_TYPES;
    private final Map<String, QueryParameterValidation[]> validations = new ConcurrentHashMap<String, QueryParameterValidation[]>();

    private static void addAllowedMultipleSlots(QueryType queryType, QueryParameter ... parameters) {
        Set slotNames = Arrays.stream(parameters).map(QueryParameter::getSlotName).collect(Collectors.toSet());
        ALLOWED_MULTIPLE_SLOTS.put(queryType, slotNames);
    }

    private AdhocQueryRequestValidator() {
    }

    private QueryParameterValidation[] getValidators(QueryType queryType, ValidationProfile profile) {
        XdsIntegrationProfile.HomeCommunityIdOptionality homeCommunityIdOptionality = profile.getInteractionProfile().getHomeCommunityIdOptionality();
        return this.validations.computeIfAbsent(queryType.name() + homeCommunityIdOptionality.name(), s -> this.instantiateValidators(queryType, homeCommunityIdOptionality));
    }

    private QueryParameterValidation[] instantiateValidators(QueryType queryType, XdsIntegrationProfile.HomeCommunityIdOptionality homeCommunityIdOptionality) {
        QueryParameterValidation[] queryParameterValidationArray;
        switch (queryType) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case FETCH: {
                QueryParameterValidation[] queryParameterValidationArray2 = new QueryParameterValidation[16];
                queryParameterValidationArray2[0] = new StringValidation(QueryParameter.DOC_ENTRY_PATIENT_ID, cxValidator, false);
                queryParameterValidationArray2[1] = new CodeValidation(QueryParameter.DOC_ENTRY_CLASS_CODE, false);
                queryParameterValidationArray2[2] = new CodeValidation(QueryParameter.DOC_ENTRY_TYPE_CODE);
                queryParameterValidationArray2[3] = new CodeValidation(QueryParameter.DOC_ENTRY_PRACTICE_SETTING_CODE);
                queryParameterValidationArray2[4] = new CodeValidation(QueryParameter.DOC_ENTRY_HEALTHCARE_FACILITY_TYPE_CODE);
                queryParameterValidationArray2[5] = new CodeValidation(QueryParameter.DOC_ENTRY_FORMAT_CODE);
                queryParameterValidationArray2[6] = new TimestampValidation(QueryParameter.DOC_ENTRY_CREATION_TIME_FROM);
                queryParameterValidationArray2[7] = new TimestampValidation(QueryParameter.DOC_ENTRY_CREATION_TIME_TO);
                queryParameterValidationArray2[8] = new TimestampValidation(QueryParameter.DOC_ENTRY_SERVICE_START_TIME_FROM);
                queryParameterValidationArray2[9] = new TimestampValidation(QueryParameter.DOC_ENTRY_SERVICE_START_TIME_TO);
                queryParameterValidationArray2[10] = new TimestampValidation(QueryParameter.DOC_ENTRY_SERVICE_STOP_TIME_FROM);
                queryParameterValidationArray2[11] = new TimestampValidation(QueryParameter.DOC_ENTRY_SERVICE_STOP_TIME_TO);
                queryParameterValidationArray2[12] = new QueryListCodeValidation(QueryParameter.DOC_ENTRY_EVENT_CODE, QueryParameter.DOC_ENTRY_EVENT_CODE_SCHEME);
                queryParameterValidationArray2[13] = new QueryListCodeValidation(QueryParameter.DOC_ENTRY_CONFIDENTIALITY_CODE, QueryParameter.DOC_ENTRY_CONFIDENTIALITY_CODE_SCHEME);
                queryParameterValidationArray2[14] = new StringListValidation(QueryParameter.DOC_ENTRY_AUTHOR_PERSON, nopValidator);
                queryParameterValidationArray = queryParameterValidationArray2;
                queryParameterValidationArray2[15] = new HomeCommunityIdValidation(homeCommunityIdOptionality);
                break;
            }
            case FIND_DOCUMENTS: 
            case FIND_DOCUMENTS_MPQ: {
                QueryParameterValidation[] queryParameterValidationArray3 = new QueryParameterValidation[18];
                queryParameterValidationArray3[0] = queryType.equals((Object)QueryType.FIND_DOCUMENTS) ? new StringValidation(QueryParameter.DOC_ENTRY_PATIENT_ID, cxValidator, false) : new StringListValidation(QueryParameter.DOC_ENTRY_PATIENT_ID, cxValidator);
                queryParameterValidationArray3[1] = new CodeValidation(QueryParameter.DOC_ENTRY_CLASS_CODE);
                queryParameterValidationArray3[2] = new CodeValidation(QueryParameter.DOC_ENTRY_TYPE_CODE);
                queryParameterValidationArray3[3] = new CodeValidation(QueryParameter.DOC_ENTRY_PRACTICE_SETTING_CODE);
                queryParameterValidationArray3[4] = new CodeValidation(QueryParameter.DOC_ENTRY_HEALTHCARE_FACILITY_TYPE_CODE);
                queryParameterValidationArray3[5] = new CodeValidation(QueryParameter.DOC_ENTRY_FORMAT_CODE);
                queryParameterValidationArray3[6] = new TimestampValidation(QueryParameter.DOC_ENTRY_CREATION_TIME_FROM);
                queryParameterValidationArray3[7] = new TimestampValidation(QueryParameter.DOC_ENTRY_CREATION_TIME_TO);
                queryParameterValidationArray3[8] = new TimestampValidation(QueryParameter.DOC_ENTRY_SERVICE_START_TIME_FROM);
                queryParameterValidationArray3[9] = new TimestampValidation(QueryParameter.DOC_ENTRY_SERVICE_START_TIME_TO);
                queryParameterValidationArray3[10] = new TimestampValidation(QueryParameter.DOC_ENTRY_SERVICE_STOP_TIME_FROM);
                queryParameterValidationArray3[11] = new TimestampValidation(QueryParameter.DOC_ENTRY_SERVICE_STOP_TIME_TO);
                queryParameterValidationArray3[12] = new QueryListCodeValidation(QueryParameter.DOC_ENTRY_EVENT_CODE, QueryParameter.DOC_ENTRY_EVENT_CODE_SCHEME);
                queryParameterValidationArray3[13] = new QueryListCodeValidation(QueryParameter.DOC_ENTRY_CONFIDENTIALITY_CODE, QueryParameter.DOC_ENTRY_CONFIDENTIALITY_CODE_SCHEME);
                queryParameterValidationArray3[14] = new StringListValidation(QueryParameter.DOC_ENTRY_AUTHOR_PERSON, nopValidator);
                queryParameterValidationArray3[15] = new StatusValidation(QueryParameter.DOC_ENTRY_STATUS);
                queryParameterValidationArray3[16] = new DocumentEntryTypeValidation();
                queryParameterValidationArray = queryParameterValidationArray3;
                queryParameterValidationArray3[17] = new HomeCommunityIdValidation(homeCommunityIdOptionality);
                break;
            }
            case FIND_DOCUMENTS_BY_TITLE: {
                QueryParameterValidation[] queryParameterValidationArray4 = new QueryParameterValidation[19];
                queryParameterValidationArray4[0] = new StringValidation(QueryParameter.DOC_ENTRY_PATIENT_ID, cxValidator, false);
                queryParameterValidationArray4[1] = new CodeValidation(QueryParameter.DOC_ENTRY_CLASS_CODE);
                queryParameterValidationArray4[2] = new CodeValidation(QueryParameter.DOC_ENTRY_TYPE_CODE);
                queryParameterValidationArray4[3] = new CodeValidation(QueryParameter.DOC_ENTRY_PRACTICE_SETTING_CODE);
                queryParameterValidationArray4[4] = new CodeValidation(QueryParameter.DOC_ENTRY_HEALTHCARE_FACILITY_TYPE_CODE);
                queryParameterValidationArray4[5] = new CodeValidation(QueryParameter.DOC_ENTRY_FORMAT_CODE);
                queryParameterValidationArray4[6] = new TimestampValidation(QueryParameter.DOC_ENTRY_CREATION_TIME_FROM);
                queryParameterValidationArray4[7] = new TimestampValidation(QueryParameter.DOC_ENTRY_CREATION_TIME_TO);
                queryParameterValidationArray4[8] = new TimestampValidation(QueryParameter.DOC_ENTRY_SERVICE_START_TIME_FROM);
                queryParameterValidationArray4[9] = new TimestampValidation(QueryParameter.DOC_ENTRY_SERVICE_START_TIME_TO);
                queryParameterValidationArray4[10] = new TimestampValidation(QueryParameter.DOC_ENTRY_SERVICE_STOP_TIME_FROM);
                queryParameterValidationArray4[11] = new TimestampValidation(QueryParameter.DOC_ENTRY_SERVICE_STOP_TIME_TO);
                queryParameterValidationArray4[12] = new QueryListCodeValidation(QueryParameter.DOC_ENTRY_EVENT_CODE, QueryParameter.DOC_ENTRY_EVENT_CODE_SCHEME);
                queryParameterValidationArray4[13] = new QueryListCodeValidation(QueryParameter.DOC_ENTRY_CONFIDENTIALITY_CODE, QueryParameter.DOC_ENTRY_CONFIDENTIALITY_CODE_SCHEME);
                queryParameterValidationArray4[14] = new StringListValidation(QueryParameter.DOC_ENTRY_AUTHOR_PERSON, nopValidator);
                queryParameterValidationArray4[15] = new StringListValidation(QueryParameter.DOC_ENTRY_TITLE, nopValidator);
                queryParameterValidationArray4[16] = new StatusValidation(QueryParameter.DOC_ENTRY_STATUS);
                queryParameterValidationArray4[17] = new DocumentEntryTypeValidation();
                queryParameterValidationArray = queryParameterValidationArray4;
                queryParameterValidationArray4[18] = new HomeCommunityIdValidation(homeCommunityIdOptionality);
                break;
            }
            case FIND_DOCUMENTS_BY_REFERENCE_ID: 
            case FIND_DOCUMENTS_BY_REFERENCE_ID_MPQ: {
                QueryParameterValidation[] queryParameterValidationArray5 = new QueryParameterValidation[19];
                queryParameterValidationArray5[0] = queryType.equals((Object)QueryType.FIND_DOCUMENTS_BY_REFERENCE_ID) ? new StringValidation(QueryParameter.DOC_ENTRY_PATIENT_ID, cxValidator, false) : new StringListValidation(QueryParameter.DOC_ENTRY_PATIENT_ID, cxValidator);
                queryParameterValidationArray5[1] = new CodeValidation(QueryParameter.DOC_ENTRY_CLASS_CODE);
                queryParameterValidationArray5[2] = new CodeValidation(QueryParameter.DOC_ENTRY_TYPE_CODE);
                queryParameterValidationArray5[3] = new CodeValidation(QueryParameter.DOC_ENTRY_PRACTICE_SETTING_CODE);
                queryParameterValidationArray5[4] = new CodeValidation(QueryParameter.DOC_ENTRY_HEALTHCARE_FACILITY_TYPE_CODE);
                queryParameterValidationArray5[5] = new CodeValidation(QueryParameter.DOC_ENTRY_FORMAT_CODE);
                queryParameterValidationArray5[6] = new TimestampValidation(QueryParameter.DOC_ENTRY_CREATION_TIME_FROM);
                queryParameterValidationArray5[7] = new TimestampValidation(QueryParameter.DOC_ENTRY_CREATION_TIME_TO);
                queryParameterValidationArray5[8] = new TimestampValidation(QueryParameter.DOC_ENTRY_SERVICE_START_TIME_FROM);
                queryParameterValidationArray5[9] = new TimestampValidation(QueryParameter.DOC_ENTRY_SERVICE_START_TIME_TO);
                queryParameterValidationArray5[10] = new TimestampValidation(QueryParameter.DOC_ENTRY_SERVICE_STOP_TIME_FROM);
                queryParameterValidationArray5[11] = new TimestampValidation(QueryParameter.DOC_ENTRY_SERVICE_STOP_TIME_TO);
                queryParameterValidationArray5[12] = new QueryListCodeValidation(QueryParameter.DOC_ENTRY_EVENT_CODE, QueryParameter.DOC_ENTRY_EVENT_CODE_SCHEME);
                queryParameterValidationArray5[13] = new QueryListCodeValidation(QueryParameter.DOC_ENTRY_CONFIDENTIALITY_CODE, QueryParameter.DOC_ENTRY_CONFIDENTIALITY_CODE_SCHEME);
                queryParameterValidationArray5[14] = new StringListValidation(QueryParameter.DOC_ENTRY_AUTHOR_PERSON, nopValidator);
                queryParameterValidationArray5[15] = new StatusValidation(QueryParameter.DOC_ENTRY_STATUS);
                queryParameterValidationArray5[16] = new DocumentEntryTypeValidation();
                queryParameterValidationArray5[17] = new StringListValidation(QueryParameter.DOC_ENTRY_REFERENCE_IDS, nopValidator);
                queryParameterValidationArray = queryParameterValidationArray5;
                queryParameterValidationArray5[18] = new HomeCommunityIdValidation(homeCommunityIdOptionality);
                break;
            }
            case FIND_SUBMISSION_SETS: {
                QueryParameterValidation[] queryParameterValidationArray6 = new QueryParameterValidation[7];
                queryParameterValidationArray6[0] = new StringValidation(QueryParameter.SUBMISSION_SET_PATIENT_ID, cxValidator, false);
                queryParameterValidationArray6[1] = new TimestampValidation(QueryParameter.SUBMISSION_SET_SUBMISSION_TIME_FROM);
                queryParameterValidationArray6[2] = new TimestampValidation(QueryParameter.SUBMISSION_SET_SUBMISSION_TIME_TO);
                queryParameterValidationArray6[3] = new StringValidation(QueryParameter.SUBMISSION_SET_AUTHOR_PERSON, nopValidator, true);
                queryParameterValidationArray6[4] = new CodeValidation(QueryParameter.SUBMISSION_SET_CONTENT_TYPE_CODE);
                queryParameterValidationArray6[5] = new StatusValidation(QueryParameter.SUBMISSION_SET_STATUS);
                queryParameterValidationArray = queryParameterValidationArray6;
                queryParameterValidationArray6[6] = new HomeCommunityIdValidation(homeCommunityIdOptionality);
                break;
            }
            case FIND_FOLDERS: 
            case FIND_FOLDERS_MPQ: {
                QueryParameterValidation[] queryParameterValidationArray7 = new QueryParameterValidation[6];
                queryParameterValidationArray7[0] = queryType.equals((Object)QueryType.FIND_FOLDERS) ? new StringValidation(QueryParameter.FOLDER_PATIENT_ID, cxValidator, false) : new StringListValidation(QueryParameter.FOLDER_PATIENT_ID, cxValidator);
                queryParameterValidationArray7[1] = new TimestampValidation(QueryParameter.FOLDER_LAST_UPDATE_TIME_FROM);
                queryParameterValidationArray7[2] = new TimestampValidation(QueryParameter.FOLDER_LAST_UPDATE_TIME_TO);
                queryParameterValidationArray7[3] = new QueryListCodeValidation(QueryParameter.FOLDER_CODES, QueryParameter.FOLDER_CODES_SCHEME);
                queryParameterValidationArray7[4] = new StatusValidation(QueryParameter.FOLDER_STATUS);
                queryParameterValidationArray = queryParameterValidationArray7;
                queryParameterValidationArray7[5] = new HomeCommunityIdValidation(homeCommunityIdOptionality);
                break;
            }
            case GET_ALL: {
                QueryParameterValidation[] queryParameterValidationArray8 = new QueryParameterValidation[7];
                queryParameterValidationArray8[0] = new StringValidation(QueryParameter.PATIENT_ID, cxValidator, false);
                queryParameterValidationArray8[1] = new StatusValidation(QueryParameter.DOC_ENTRY_STATUS);
                queryParameterValidationArray8[2] = new StatusValidation(QueryParameter.SUBMISSION_SET_STATUS);
                queryParameterValidationArray8[3] = new StatusValidation(QueryParameter.FOLDER_STATUS);
                queryParameterValidationArray8[4] = new QueryListCodeValidation(QueryParameter.DOC_ENTRY_FORMAT_CODE, QueryParameter.DOC_ENTRY_FORMAT_CODE_SCHEME);
                queryParameterValidationArray8[5] = new DocumentEntryTypeValidation();
                queryParameterValidationArray = queryParameterValidationArray8;
                queryParameterValidationArray8[6] = new HomeCommunityIdValidation(homeCommunityIdOptionality);
                break;
            }
            case GET_DOCUMENTS: {
                QueryParameterValidation[] queryParameterValidationArray9 = new QueryParameterValidation[4];
                queryParameterValidationArray9[0] = new HomeCommunityIdValidation(homeCommunityIdOptionality);
                queryParameterValidationArray9[1] = new ChoiceValidation(false, QueryParameter.DOC_ENTRY_UUID, QueryParameter.DOC_ENTRY_UNIQUE_ID, QueryParameter.DOC_ENTRY_LOGICAL_ID);
                queryParameterValidationArray9[2] = new StringListValidation(QueryParameter.DOC_ENTRY_UUID, nopValidator);
                queryParameterValidationArray = queryParameterValidationArray9;
                queryParameterValidationArray9[3] = new StringListValidation(QueryParameter.DOC_ENTRY_UNIQUE_ID, nopValidator);
                break;
            }
            case GET_DOCUMENTS_AND_ASSOCIATIONS: {
                QueryParameterValidation[] queryParameterValidationArray10 = new QueryParameterValidation[4];
                queryParameterValidationArray10[0] = new HomeCommunityIdValidation(homeCommunityIdOptionality);
                queryParameterValidationArray10[1] = new ChoiceValidation(false, QueryParameter.DOC_ENTRY_UUID, QueryParameter.DOC_ENTRY_UNIQUE_ID);
                queryParameterValidationArray10[2] = new StringListValidation(QueryParameter.DOC_ENTRY_UUID, nopValidator);
                queryParameterValidationArray = queryParameterValidationArray10;
                queryParameterValidationArray10[3] = new StringListValidation(QueryParameter.DOC_ENTRY_UNIQUE_ID, nopValidator);
                break;
            }
            case GET_FOLDERS_FOR_DOCUMENT: {
                QueryParameterValidation[] queryParameterValidationArray11 = new QueryParameterValidation[4];
                queryParameterValidationArray11[0] = new HomeCommunityIdValidation(homeCommunityIdOptionality);
                queryParameterValidationArray11[1] = new ChoiceValidation(false, QueryParameter.DOC_ENTRY_UUID, QueryParameter.DOC_ENTRY_UNIQUE_ID);
                queryParameterValidationArray11[2] = new StringValidation(QueryParameter.DOC_ENTRY_UUID, nopValidator, true);
                queryParameterValidationArray = queryParameterValidationArray11;
                queryParameterValidationArray11[3] = new StringValidation(QueryParameter.DOC_ENTRY_UNIQUE_ID, nopValidator, true);
                break;
            }
            case GET_FOLDERS: {
                QueryParameterValidation[] queryParameterValidationArray12 = new QueryParameterValidation[4];
                queryParameterValidationArray12[0] = new HomeCommunityIdValidation(homeCommunityIdOptionality);
                queryParameterValidationArray12[1] = new ChoiceValidation(false, QueryParameter.FOLDER_UUID, QueryParameter.FOLDER_UNIQUE_ID, QueryParameter.FOLDER_LOGICAL_ID);
                queryParameterValidationArray12[2] = new StringListValidation(QueryParameter.FOLDER_UUID, nopValidator);
                queryParameterValidationArray = queryParameterValidationArray12;
                queryParameterValidationArray12[3] = new StringListValidation(QueryParameter.FOLDER_UNIQUE_ID, nopValidator);
                break;
            }
            case GET_ASSOCIATIONS: 
            case GET_SUBMISSION_SETS: {
                QueryParameterValidation[] queryParameterValidationArray13 = new QueryParameterValidation[2];
                queryParameterValidationArray13[0] = new HomeCommunityIdValidation(homeCommunityIdOptionality);
                queryParameterValidationArray = queryParameterValidationArray13;
                queryParameterValidationArray13[1] = new StringListValidation(QueryParameter.UUID, nopValidator);
                break;
            }
            case GET_SUBMISSION_SET_AND_CONTENTS: {
                QueryParameterValidation[] queryParameterValidationArray14 = new QueryParameterValidation[7];
                queryParameterValidationArray14[0] = new HomeCommunityIdValidation(homeCommunityIdOptionality);
                queryParameterValidationArray14[1] = new ChoiceValidation(false, QueryParameter.SUBMISSION_SET_UUID, QueryParameter.SUBMISSION_SET_UNIQUE_ID);
                queryParameterValidationArray14[2] = new StringValidation(QueryParameter.SUBMISSION_SET_UUID, nopValidator, true);
                queryParameterValidationArray14[3] = new StringValidation(QueryParameter.SUBMISSION_SET_UNIQUE_ID, nopValidator, true);
                queryParameterValidationArray14[4] = new QueryListCodeValidation(QueryParameter.DOC_ENTRY_CONFIDENTIALITY_CODE, QueryParameter.DOC_ENTRY_CONFIDENTIALITY_CODE_SCHEME);
                queryParameterValidationArray14[5] = new QueryListCodeValidation(QueryParameter.DOC_ENTRY_FORMAT_CODE, QueryParameter.DOC_ENTRY_FORMAT_CODE_SCHEME);
                queryParameterValidationArray = queryParameterValidationArray14;
                queryParameterValidationArray14[6] = new DocumentEntryTypeValidation();
                break;
            }
            case GET_FOLDER_AND_CONTENTS: {
                QueryParameterValidation[] queryParameterValidationArray15 = new QueryParameterValidation[7];
                queryParameterValidationArray15[0] = new HomeCommunityIdValidation(homeCommunityIdOptionality);
                queryParameterValidationArray15[1] = new ChoiceValidation(false, QueryParameter.FOLDER_UUID, QueryParameter.FOLDER_UNIQUE_ID);
                queryParameterValidationArray15[2] = new StringValidation(QueryParameter.FOLDER_UUID, nopValidator, true);
                queryParameterValidationArray15[3] = new StringValidation(QueryParameter.FOLDER_UNIQUE_ID, nopValidator, true);
                queryParameterValidationArray15[4] = new QueryListCodeValidation(QueryParameter.DOC_ENTRY_CONFIDENTIALITY_CODE, QueryParameter.DOC_ENTRY_CONFIDENTIALITY_CODE_SCHEME);
                queryParameterValidationArray15[5] = new QueryListCodeValidation(QueryParameter.DOC_ENTRY_FORMAT_CODE, QueryParameter.DOC_ENTRY_FORMAT_CODE_SCHEME);
                queryParameterValidationArray = queryParameterValidationArray15;
                queryParameterValidationArray15[6] = new DocumentEntryTypeValidation();
                break;
            }
            case GET_RELATED_DOCUMENTS: {
                QueryParameterValidation[] queryParameterValidationArray16 = new QueryParameterValidation[6];
                queryParameterValidationArray16[0] = new HomeCommunityIdValidation(homeCommunityIdOptionality);
                queryParameterValidationArray16[1] = new ChoiceValidation(false, QueryParameter.DOC_ENTRY_UUID, QueryParameter.DOC_ENTRY_UNIQUE_ID);
                queryParameterValidationArray16[2] = new StringValidation(QueryParameter.DOC_ENTRY_UUID, nopValidator, true);
                queryParameterValidationArray16[3] = new StringValidation(QueryParameter.DOC_ENTRY_UNIQUE_ID, nopValidator, true);
                queryParameterValidationArray16[4] = new AssociationValidation(QueryParameter.ASSOCIATION_TYPE);
                queryParameterValidationArray = queryParameterValidationArray16;
                queryParameterValidationArray16[5] = new DocumentEntryTypeValidation();
                break;
            }
            case FIND_MEDICATION_TREATMENT_PLANS: 
            case FIND_PRESCRIPTIONS: 
            case FIND_DISPENSES: 
            case FIND_MEDICATION_ADMINISTRATIONS: 
            case FIND_PRESCRIPTIONS_FOR_VALIDATION: 
            case FIND_PRESCRIPTIONS_FOR_DISPENSE: {
                QueryParameterValidation[] queryParameterValidationArray17 = new QueryParameterValidation[16];
                queryParameterValidationArray17[0] = new StringValidation(QueryParameter.DOC_ENTRY_PATIENT_ID, cxValidator, false);
                queryParameterValidationArray17[1] = new ChoiceValidation(true, QueryParameter.DOC_ENTRY_UUID, QueryParameter.DOC_ENTRY_UNIQUE_ID);
                queryParameterValidationArray17[2] = new StringListValidation(QueryParameter.FOLDER_UUID, nopValidator);
                queryParameterValidationArray17[3] = new StringListValidation(QueryParameter.FOLDER_UNIQUE_ID, nopValidator);
                queryParameterValidationArray17[4] = new CodeValidation(QueryParameter.DOC_ENTRY_PRACTICE_SETTING_CODE);
                queryParameterValidationArray17[5] = new TimestampValidation(QueryParameter.DOC_ENTRY_CREATION_TIME_FROM);
                queryParameterValidationArray17[6] = new TimestampValidation(QueryParameter.DOC_ENTRY_CREATION_TIME_TO);
                queryParameterValidationArray17[7] = new TimestampValidation(QueryParameter.DOC_ENTRY_SERVICE_START_TIME_FROM);
                queryParameterValidationArray17[8] = new TimestampValidation(QueryParameter.DOC_ENTRY_SERVICE_START_TIME_TO);
                queryParameterValidationArray17[9] = new TimestampValidation(QueryParameter.DOC_ENTRY_SERVICE_STOP_TIME_FROM);
                queryParameterValidationArray17[10] = new TimestampValidation(QueryParameter.DOC_ENTRY_SERVICE_STOP_TIME_TO);
                queryParameterValidationArray17[11] = new CodeValidation(QueryParameter.DOC_ENTRY_HEALTHCARE_FACILITY_TYPE_CODE);
                queryParameterValidationArray17[12] = new CodeValidation(QueryParameter.DOC_ENTRY_EVENT_CODE);
                queryParameterValidationArray17[13] = new CodeValidation(QueryParameter.DOC_ENTRY_CONFIDENTIALITY_CODE);
                queryParameterValidationArray17[14] = new StringListValidation(QueryParameter.DOC_ENTRY_AUTHOR_PERSON, nopValidator);
                queryParameterValidationArray = queryParameterValidationArray17;
                queryParameterValidationArray17[15] = new StatusValidation(QueryParameter.DOC_ENTRY_STATUS);
                break;
            }
            case FIND_MEDICATION_LIST: {
                QueryParameterValidation[] queryParameterValidationArray18 = new QueryParameterValidation[8];
                queryParameterValidationArray18[0] = new StringValidation(QueryParameter.DOC_ENTRY_PATIENT_ID, cxValidator, false);
                queryParameterValidationArray18[1] = new TimestampValidation(QueryParameter.DOC_ENTRY_SERVICE_START_FROM);
                queryParameterValidationArray18[2] = new TimestampValidation(QueryParameter.DOC_ENTRY_SERVICE_START_TO);
                queryParameterValidationArray18[3] = new TimestampValidation(QueryParameter.DOC_ENTRY_SERVICE_END_FROM);
                queryParameterValidationArray18[4] = new TimestampValidation(QueryParameter.DOC_ENTRY_SERVICE_END_TO);
                queryParameterValidationArray18[5] = new CodeValidation(QueryParameter.DOC_ENTRY_FORMAT_CODE);
                queryParameterValidationArray18[6] = new StatusValidation(QueryParameter.DOC_ENTRY_STATUS);
                queryParameterValidationArray = queryParameterValidationArray18;
                queryParameterValidationArray18[7] = new DocumentEntryTypeValidation();
                break;
            }
            case SUBSCRIPTION_FOR_DOCUMENT_ENTRY: {
                QueryParameterValidation[] queryParameterValidationArray19 = new QueryParameterValidation[11];
                queryParameterValidationArray19[0] = new StringValidation(QueryParameter.DOC_ENTRY_PATIENT_ID, cxValidator, false);
                queryParameterValidationArray19[1] = new CodeValidation(QueryParameter.DOC_ENTRY_CLASS_CODE);
                queryParameterValidationArray19[2] = new CodeValidation(QueryParameter.DOC_ENTRY_TYPE_CODE);
                queryParameterValidationArray19[3] = new StringListValidation(QueryParameter.DOC_ENTRY_REFERENCE_IDS, nopValidator);
                queryParameterValidationArray19[4] = new CodeValidation(QueryParameter.DOC_ENTRY_PRACTICE_SETTING_CODE);
                queryParameterValidationArray19[5] = new CodeValidation(QueryParameter.DOC_ENTRY_HEALTHCARE_FACILITY_TYPE_CODE);
                queryParameterValidationArray19[6] = new CodeValidation(QueryParameter.DOC_ENTRY_FORMAT_CODE);
                queryParameterValidationArray19[7] = new QueryListCodeValidation(QueryParameter.DOC_ENTRY_EVENT_CODE, QueryParameter.DOC_ENTRY_EVENT_CODE_SCHEME);
                queryParameterValidationArray19[8] = new QueryListCodeValidation(QueryParameter.DOC_ENTRY_CONFIDENTIALITY_CODE, QueryParameter.DOC_ENTRY_CONFIDENTIALITY_CODE_SCHEME);
                queryParameterValidationArray19[9] = new CodeValidation(QueryParameter.DOC_ENTRY_FORMAT_CODE);
                queryParameterValidationArray = queryParameterValidationArray19;
                queryParameterValidationArray19[10] = new StringListValidation(QueryParameter.DOC_ENTRY_AUTHOR_PERSON, nopValidator);
                break;
            }
            case SUBSCRIPTION_FOR_FOLDER: {
                QueryParameterValidation[] queryParameterValidationArray20 = new QueryParameterValidation[3];
                queryParameterValidationArray20[0] = new StringValidation(QueryParameter.FOLDER_PATIENT_ID, cxValidator, false);
                queryParameterValidationArray20[1] = new StringListValidation(QueryParameter.FOLDER_UNIQUE_ID, nopValidator);
                queryParameterValidationArray = queryParameterValidationArray20;
                queryParameterValidationArray20[2] = new QueryListCodeValidation(QueryParameter.FOLDER_CODES, QueryParameter.FOLDER_CODES_SCHEME);
                break;
            }
            case SUBSCRIPTION_FOR_SUBMISSION_SET: {
                QueryParameterValidation[] queryParameterValidationArray21 = new QueryParameterValidation[4];
                queryParameterValidationArray21[0] = new StringValidation(QueryParameter.SUBMISSION_SET_PATIENT_ID, cxValidator, false);
                queryParameterValidationArray21[1] = new StringListValidation(QueryParameter.SUBMISSION_SET_SOURCE_ID, oidValidator);
                queryParameterValidationArray21[2] = new StringValidation(QueryParameter.SUBMISSION_SET_AUTHOR_PERSON, nopValidator, true);
                queryParameterValidationArray = queryParameterValidationArray21;
                queryParameterValidationArray21[3] = new StringListValidation(QueryParameter.SUBMISSION_SET_INTENDED_RECIPIENT, nopValidator);
                break;
            }
            case SUBSCRIPTION_FOR_PATIENT_INDEPENDENT_DOCUMENT_ENTRY: {
                QueryParameterValidation[] queryParameterValidationArray22 = new QueryParameterValidation[8];
                queryParameterValidationArray22[0] = new CodeValidation(QueryParameter.DOC_ENTRY_CLASS_CODE);
                queryParameterValidationArray22[1] = new CodeValidation(QueryParameter.DOC_ENTRY_TYPE_CODE);
                queryParameterValidationArray22[2] = new CodeValidation(QueryParameter.DOC_ENTRY_PRACTICE_SETTING_CODE);
                queryParameterValidationArray22[3] = new CodeValidation(QueryParameter.DOC_ENTRY_HEALTHCARE_FACILITY_TYPE_CODE);
                queryParameterValidationArray22[4] = new QueryListCodeValidation(QueryParameter.DOC_ENTRY_EVENT_CODE, QueryParameter.DOC_ENTRY_EVENT_CODE_SCHEME);
                queryParameterValidationArray22[5] = new QueryListCodeValidation(QueryParameter.DOC_ENTRY_CONFIDENTIALITY_CODE, QueryParameter.DOC_ENTRY_CONFIDENTIALITY_CODE_SCHEME);
                queryParameterValidationArray22[6] = new CodeValidation(QueryParameter.DOC_ENTRY_FORMAT_CODE);
                queryParameterValidationArray = queryParameterValidationArray22;
                queryParameterValidationArray22[7] = new StringListValidation(QueryParameter.DOC_ENTRY_AUTHOR_PERSON, nopValidator);
                break;
            }
            case SUBSCRIPTION_FOR_PATIENT_INDEPENDENT_SUBMISSION_SET: {
                QueryParameterValidation[] queryParameterValidationArray23 = new QueryParameterValidation[3];
                queryParameterValidationArray23[0] = new StringListValidation(QueryParameter.SUBMISSION_SET_SOURCE_ID, oidValidator);
                queryParameterValidationArray23[1] = new StringValidation(QueryParameter.SUBMISSION_SET_AUTHOR_PERSON, nopValidator, true);
                queryParameterValidationArray = queryParameterValidationArray23;
                queryParameterValidationArray23[2] = new StringListValidation(QueryParameter.SUBMISSION_SET_INTENDED_RECIPIENT, nopValidator);
            }
        }
        return queryParameterValidationArray;
    }

    public void validate(EbXMLAdhocQueryRequest<AdhocQueryRequest> request, ValidationProfile profile) {
        Objects.requireNonNull(request, "request cannot be null");
        if (profile == XCF.Interactions.ITI_63) {
            ValidatorAssertions.metaDataAssert(QueryReturnType.LEAF_CLASS_WITH_REPOSITORY_ITEM.getCode().equals(request.getReturnType()), ValidationMessage.UNKNOWN_RETURN_TYPE, request.getReturnType());
        } else {
            ValidatorAssertions.metaDataAssert(QueryReturnType.LEAF_CLASS.getCode().equals(request.getReturnType()) || QueryReturnType.OBJECT_REF.getCode().equals(request.getReturnType()), ValidationMessage.UNKNOWN_RETURN_TYPE, request.getReturnType());
        }
        QueryType queryType = QueryType.valueOfId(request.getId());
        ValidatorAssertions.metaDataAssert(queryType != null, ValidationMessage.UNKNOWN_QUERY_TYPE, request.getId());
        Set allowedQueryTypes = ALLOWED_QUERY_TYPES.getOrDefault(profile.getInteractionId(), Collections.emptySet());
        ValidatorAssertions.metaDataAssert(allowedQueryTypes.contains((Object)queryType), ValidationMessage.UNSUPPORTED_QUERY_TYPE, new Object[]{queryType});
        SlotLengthAndNameUniquenessValidator.validateQuerySlots(request.getSlots(), ALLOWED_MULTIPLE_SLOTS.getOrDefault((Object)queryType, Collections.emptySet()));
        QueryParameterValidation[] validations = this.getValidators(queryType, profile);
        if (validations != null) {
            Arrays.stream(validations).forEach(validation -> validation.validate(request));
        }
        switch (queryType) {
            case FIND_DOCUMENTS_MPQ: {
                this.checkAtLeastOnePresent(request, QueryParameter.DOC_ENTRY_PATIENT_ID, QueryParameter.DOC_ENTRY_CLASS_CODE, QueryParameter.DOC_ENTRY_EVENT_CODE, QueryParameter.DOC_ENTRY_HEALTHCARE_FACILITY_TYPE_CODE);
                break;
            }
            case FIND_FOLDERS_MPQ: {
                this.checkAtLeastOnePresent(request, QueryParameter.FOLDER_PATIENT_ID, QueryParameter.FOLDER_CODES);
                break;
            }
            case SUBSCRIPTION_FOR_PATIENT_INDEPENDENT_DOCUMENT_ENTRY: {
                this.checkAtLeastOnePresent(request, QueryParameter.DOC_ENTRY_CLASS_CODE, QueryParameter.DOC_ENTRY_TYPE_CODE, QueryParameter.DOC_ENTRY_PRACTICE_SETTING_CODE, QueryParameter.DOC_ENTRY_HEALTHCARE_FACILITY_TYPE_CODE);
                break;
            }
            case SUBSCRIPTION_FOR_PATIENT_INDEPENDENT_SUBMISSION_SET: {
                this.checkAtLeastOnePresent(request, QueryParameter.SUBMISSION_SET_SOURCE_ID, QueryParameter.SUBMISSION_SET_AUTHOR_PERSON, QueryParameter.SUBMISSION_SET_INTENDED_RECIPIENT);
            }
        }
    }

    private void checkAtLeastOnePresent(EbXMLAdhocQueryRequest<AdhocQueryRequest> request, QueryParameter ... params) {
        List<String> slotNames = Arrays.stream(params).map(QueryParameter::getSlotName).toList();
        slotNames.stream().map(request::getSlotValues).filter(slotList -> !slotList.isEmpty()).findAny().orElseThrow(() -> new XDSMetaDataException(ValidationMessage.MISSING_REQUIRED_QUERY_PARAMETER, "one of " + StringUtils.join((Iterable)slotNames, (String)", ")));
    }

    @Generated
    public static AdhocQueryRequestValidator getInstance() {
        return instance;
    }

    static {
        AdhocQueryRequestValidator.addAllowedMultipleSlots(QueryType.FIND_DOCUMENTS, QueryParameter.DOC_ENTRY_EVENT_CODE, QueryParameter.DOC_ENTRY_CONFIDENTIALITY_CODE);
        AdhocQueryRequestValidator.addAllowedMultipleSlots(QueryType.FIND_DOCUMENTS_BY_REFERENCE_ID, QueryParameter.DOC_ENTRY_REFERENCE_IDS, QueryParameter.DOC_ENTRY_EVENT_CODE, QueryParameter.DOC_ENTRY_CONFIDENTIALITY_CODE);
        AdhocQueryRequestValidator.addAllowedMultipleSlots(QueryType.FIND_DOCUMENTS_MPQ, QueryParameter.DOC_ENTRY_EVENT_CODE, QueryParameter.DOC_ENTRY_CONFIDENTIALITY_CODE);
        AdhocQueryRequestValidator.addAllowedMultipleSlots(QueryType.FIND_DOCUMENTS_BY_REFERENCE_ID_MPQ, QueryParameter.DOC_ENTRY_REFERENCE_IDS, QueryParameter.DOC_ENTRY_EVENT_CODE, QueryParameter.DOC_ENTRY_CONFIDENTIALITY_CODE);
        AdhocQueryRequestValidator.addAllowedMultipleSlots(QueryType.FIND_FOLDERS, QueryParameter.FOLDER_CODES);
        AdhocQueryRequestValidator.addAllowedMultipleSlots(QueryType.FIND_FOLDERS_MPQ, QueryParameter.FOLDER_CODES);
        AdhocQueryRequestValidator.addAllowedMultipleSlots(QueryType.GET_ALL, QueryParameter.DOC_ENTRY_CONFIDENTIALITY_CODE);
        AdhocQueryRequestValidator.addAllowedMultipleSlots(QueryType.GET_SUBMISSION_SET_AND_CONTENTS, QueryParameter.DOC_ENTRY_CONFIDENTIALITY_CODE);
        AdhocQueryRequestValidator.addAllowedMultipleSlots(QueryType.GET_FOLDER_AND_CONTENTS, QueryParameter.DOC_ENTRY_CONFIDENTIALITY_CODE);
        AdhocQueryRequestValidator.addAllowedMultipleSlots(QueryType.FETCH, QueryParameter.DOC_ENTRY_EVENT_CODE, QueryParameter.DOC_ENTRY_CONFIDENTIALITY_CODE);
        AdhocQueryRequestValidator.addAllowedMultipleSlots(QueryType.FIND_MEDICATION_TREATMENT_PLANS, QueryParameter.DOC_ENTRY_EVENT_CODE, QueryParameter.DOC_ENTRY_CONFIDENTIALITY_CODE);
        AdhocQueryRequestValidator.addAllowedMultipleSlots(QueryType.FIND_PRESCRIPTIONS, QueryParameter.DOC_ENTRY_EVENT_CODE, QueryParameter.DOC_ENTRY_CONFIDENTIALITY_CODE);
        AdhocQueryRequestValidator.addAllowedMultipleSlots(QueryType.FIND_DISPENSES, QueryParameter.DOC_ENTRY_EVENT_CODE, QueryParameter.DOC_ENTRY_CONFIDENTIALITY_CODE);
        AdhocQueryRequestValidator.addAllowedMultipleSlots(QueryType.FIND_MEDICATION_ADMINISTRATIONS, QueryParameter.DOC_ENTRY_EVENT_CODE, QueryParameter.DOC_ENTRY_CONFIDENTIALITY_CODE);
        AdhocQueryRequestValidator.addAllowedMultipleSlots(QueryType.FIND_PRESCRIPTIONS_FOR_VALIDATION, QueryParameter.DOC_ENTRY_EVENT_CODE, QueryParameter.DOC_ENTRY_CONFIDENTIALITY_CODE);
        AdhocQueryRequestValidator.addAllowedMultipleSlots(QueryType.FIND_PRESCRIPTIONS_FOR_DISPENSE, QueryParameter.DOC_ENTRY_EVENT_CODE, QueryParameter.DOC_ENTRY_CONFIDENTIALITY_CODE);
        EnumSet<QueryType[]> itiStoredQueryTypes = EnumSet.of(QueryType.FIND_DOCUMENTS, new QueryType[]{QueryType.FIND_DOCUMENTS_BY_REFERENCE_ID, QueryType.FIND_SUBMISSION_SETS, QueryType.FIND_FOLDERS, QueryType.GET_ALL, QueryType.GET_DOCUMENTS, QueryType.GET_FOLDERS, QueryType.GET_ASSOCIATIONS, QueryType.GET_DOCUMENTS_AND_ASSOCIATIONS, QueryType.GET_SUBMISSION_SETS, QueryType.GET_SUBMISSION_SET_AND_CONTENTS, QueryType.GET_FOLDER_AND_CONTENTS, QueryType.GET_FOLDERS_FOR_DOCUMENT, QueryType.GET_RELATED_DOCUMENTS});
        EnumSet<QueryType[]> pharmStoredQueryTypes = EnumSet.of(QueryType.FIND_MEDICATION_TREATMENT_PLANS, new QueryType[]{QueryType.FIND_PRESCRIPTIONS, QueryType.FIND_DISPENSES, QueryType.FIND_MEDICATION_ADMINISTRATIONS, QueryType.FIND_PRESCRIPTIONS_FOR_VALIDATION, QueryType.FIND_PRESCRIPTIONS_FOR_DISPENSE, QueryType.FIND_MEDICATION_LIST});
        ALLOWED_QUERY_TYPES = new HashMap<InteractionId, Set<QueryType>>(5);
        ALLOWED_QUERY_TYPES.put((InteractionId)XDS.Interactions.ITI_18, itiStoredQueryTypes);
        ALLOWED_QUERY_TYPES.put((InteractionId)XCA.Interactions.ITI_38, itiStoredQueryTypes);
        ALLOWED_QUERY_TYPES.put((InteractionId)XDS.Interactions.ITI_51, EnumSet.of(QueryType.FIND_DOCUMENTS_MPQ, QueryType.FIND_FOLDERS_MPQ, QueryType.FIND_DOCUMENTS_BY_REFERENCE_ID_MPQ));
        ALLOWED_QUERY_TYPES.put((InteractionId)XCF.Interactions.ITI_63, EnumSet.of(QueryType.FETCH));
        ALLOWED_QUERY_TYPES.put((InteractionId)CMPD.Interactions.PHARM_1, pharmStoredQueryTypes);
    }
}

