/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.commons.ihe.xds.core.validate.query;

import java.util.List;
import java.util.Objects;
import java.util.regex.Pattern;
import org.openehealth.ipf.commons.ihe.xds.core.ebxml.EbXMLAdhocQueryRequest;
import org.openehealth.ipf.commons.ihe.xds.core.metadata.AvailabilityStatus;
import org.openehealth.ipf.commons.ihe.xds.core.stub.ebrs30.query.AdhocQueryRequest;
import org.openehealth.ipf.commons.ihe.xds.core.transform.requests.QueryParameter;
import org.openehealth.ipf.commons.ihe.xds.core.transform.requests.query.QuerySlotHelper;
import org.openehealth.ipf.commons.ihe.xds.core.validate.ValidationMessage;
import org.openehealth.ipf.commons.ihe.xds.core.validate.ValidatorAssertions;
import org.openehealth.ipf.commons.ihe.xds.core.validate.XDSMetaDataException;
import org.openehealth.ipf.commons.ihe.xds.core.validate.query.QueryParameterValidation;

public class StatusValidation
implements QueryParameterValidation {
    private static final Pattern PATTERN = Pattern.compile("\\s*\\(\\s*'.*'(\\s*,\\s*'.*')*\\s*\\)\\s*");
    private final QueryParameter param;

    public StatusValidation(QueryParameter param) {
        this.param = Objects.requireNonNull(param, "param cannot be null");
    }

    @Override
    public void validate(EbXMLAdhocQueryRequest<AdhocQueryRequest> request) throws XDSMetaDataException {
        List<String> slotValues = request.getSlotValues(this.param.getSlotName());
        ValidatorAssertions.metaDataAssert(!slotValues.isEmpty(), ValidationMessage.MISSING_REQUIRED_QUERY_PARAMETER, new Object[]{this.param});
        slotValues.forEach(slotValue -> {
            ValidatorAssertions.metaDataAssert(slotValue != null, ValidationMessage.MISSING_REQUIRED_QUERY_PARAMETER, new Object[]{this.param});
            ValidatorAssertions.metaDataAssert(PATTERN.matcher((CharSequence)slotValue).matches(), ValidationMessage.PARAMETER_VALUE_NOT_STRING_LIST, new Object[]{this.param});
        });
        QuerySlotHelper slots = new QuerySlotHelper(request);
        List<AvailabilityStatus> list = slots.toStatus(this.param);
        if (list.isEmpty()) {
            slots.toStringList(this.param).forEach(value -> ValidatorAssertions.metaDataAssert(AvailabilityStatus.valueOfOpcode(value) != null, ValidationMessage.INVALID_QUERY_PARAMETER_VALUE, value));
        }
        ValidatorAssertions.metaDataAssert(!list.isEmpty(), ValidationMessage.MISSING_REQUIRED_QUERY_PARAMETER, slotValues);
    }
}

