/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.commons.ihe.xds.core.validate.query;

import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.openehealth.ipf.commons.ihe.xds.XdsIntegrationProfile;
import org.openehealth.ipf.commons.ihe.xds.core.ebxml.EbXMLAdhocQueryRequest;
import org.openehealth.ipf.commons.ihe.xds.core.stub.ebrs30.query.AdhocQueryRequest;
import org.openehealth.ipf.commons.ihe.xds.core.transform.requests.QueryParameter;
import org.openehealth.ipf.commons.ihe.xds.core.transform.requests.query.QuerySlotHelper;
import org.openehealth.ipf.commons.ihe.xds.core.validate.HomeCommunityIdValidator;
import org.openehealth.ipf.commons.ihe.xds.core.validate.ValidationMessage;
import org.openehealth.ipf.commons.ihe.xds.core.validate.XDSMetaDataException;
import org.openehealth.ipf.commons.ihe.xds.core.validate.query.QueryParameterValidation;

public class HomeCommunityIdValidation
implements QueryParameterValidation {
    private static final QueryParameter[] PATIENT_ID_PARAMETERS = new QueryParameter[]{QueryParameter.DOC_ENTRY_PATIENT_ID, QueryParameter.SUBMISSION_SET_PATIENT_ID, QueryParameter.FOLDER_PATIENT_ID, QueryParameter.PATIENT_ID};
    private final XdsIntegrationProfile.HomeCommunityIdOptionality optionality;

    public HomeCommunityIdValidation(XdsIntegrationProfile.HomeCommunityIdOptionality optionality) {
        this.optionality = optionality;
    }

    @Override
    public void validate(EbXMLAdhocQueryRequest<AdhocQueryRequest> request) throws XDSMetaDataException {
        List<String> targetCommunityIds = new QuerySlotHelper(request).toStringList(QueryParameter.TARGET_COMMUNITY_IDS);
        if (StringUtils.isNotEmpty((CharSequence)request.getHome()) && targetCommunityIds != null) {
            throw new XDSMetaDataException(ValidationMessage.QUERY_PARAMETERS_CANNOT_BE_SET_TOGETHER, "home, " + QueryParameter.TARGET_COMMUNITY_IDS.getSlotName());
        }
        boolean homeCommunityRequired = switch (this.optionality) {
            default -> throw new IncompatibleClassChangeError();
            case XdsIntegrationProfile.HomeCommunityIdOptionality.NEVER -> false;
            case XdsIntegrationProfile.HomeCommunityIdOptionality.ALWAYS -> true;
            case XdsIntegrationProfile.HomeCommunityIdOptionality.ON_MISSING_PATIENT_ID -> HomeCommunityIdValidation.patientIdMissing(request);
        };
        HomeCommunityIdValidator validator = new HomeCommunityIdValidator(homeCommunityRequired);
        if (targetCommunityIds != null) {
            targetCommunityIds.forEach(validator::validate);
        } else {
            validator.validate(request.getHome());
        }
    }

    private static boolean patientIdMissing(EbXMLAdhocQueryRequest<AdhocQueryRequest> request) {
        return Arrays.stream(PATIENT_ID_PARAMETERS).allMatch(parameter -> request.getSlotValues(parameter.getSlotName()).isEmpty());
    }
}

