/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.commons.ihe.xds.core.validate.query;

import java.util.List;
import java.util.Objects;
import java.util.regex.Pattern;
import org.openehealth.ipf.commons.ihe.xds.core.ebxml.EbXMLAdhocQueryRequest;
import org.openehealth.ipf.commons.ihe.xds.core.metadata.Code;
import org.openehealth.ipf.commons.ihe.xds.core.stub.ebrs30.query.AdhocQueryRequest;
import org.openehealth.ipf.commons.ihe.xds.core.transform.requests.QueryParameter;
import org.openehealth.ipf.commons.ihe.xds.core.transform.requests.query.QuerySlotHelper;
import org.openehealth.ipf.commons.ihe.xds.core.validate.ValidationMessage;
import org.openehealth.ipf.commons.ihe.xds.core.validate.ValidatorAssertions;
import org.openehealth.ipf.commons.ihe.xds.core.validate.XDSMetaDataException;
import org.openehealth.ipf.commons.ihe.xds.core.validate.query.QueryParameterValidation;

public class CodeValidation
implements QueryParameterValidation {
    private static final Pattern PATTERN = Pattern.compile("\\s*\\(\\s*'.*'(\\s*,\\s*'.*')*\\s*\\)\\s*");
    private final QueryParameter param;
    private final boolean optional;

    public CodeValidation(QueryParameter param, boolean optional) {
        this.param = Objects.requireNonNull(param, "param cannot be null");
        this.optional = optional;
    }

    public CodeValidation(QueryParameter param) {
        this(param, true);
    }

    @Override
    public void validate(EbXMLAdhocQueryRequest<AdhocQueryRequest> request) throws XDSMetaDataException {
        List<String> slotValues = request.getSlotValues(this.param.getSlotName());
        slotValues.forEach(slotValue -> {
            ValidatorAssertions.metaDataAssert(slotValue != null, ValidationMessage.MISSING_REQUIRED_QUERY_PARAMETER, new Object[]{this.param});
            ValidatorAssertions.metaDataAssert(PATTERN.matcher((CharSequence)slotValue).matches(), ValidationMessage.PARAMETER_VALUE_NOT_STRING_LIST, new Object[]{this.param});
        });
        QuerySlotHelper slots = new QuerySlotHelper(request);
        List<Code> codes = slots.toCodeList(this.param);
        if (codes != null) {
            codes.forEach(code -> {
                ValidatorAssertions.metaDataAssert(code != null, ValidationMessage.INVALID_QUERY_PARAMETER_VALUE, new Object[]{this.param});
                ValidatorAssertions.metaDataAssert(code.getCode() != null, ValidationMessage.INVALID_QUERY_PARAMETER_VALUE, new Object[]{this.param});
                ValidatorAssertions.metaDataAssert(code.getSchemeName() != null, ValidationMessage.INVALID_QUERY_PARAMETER_VALUE, new Object[]{this.param});
            });
        } else {
            ValidatorAssertions.metaDataAssert(this.optional, ValidationMessage.MISSING_REQUIRED_QUERY_PARAMETER, new Object[]{this.param});
        }
    }
}

