/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.commons.ihe.xds.core.validate;

import org.apache.commons.lang3.StringUtils;
import org.openehealth.ipf.commons.ihe.xds.core.metadata.Telecom;
import org.openehealth.ipf.commons.ihe.xds.core.validate.ValidationMessage;
import org.openehealth.ipf.commons.ihe.xds.core.validate.ValidatorAssertions;
import org.openehealth.ipf.commons.ihe.xds.core.validate.ValueValidator;
import org.openehealth.ipf.commons.ihe.xds.core.validate.XDSMetaDataException;

public class XTNValidator
implements ValueValidator {
    @Override
    public void validate(String hl7XTN) throws XDSMetaDataException {
        Telecom telecom = Telecom.parse(hl7XTN);
        ValidatorAssertions.metaDataAssert(telecom != null, ValidationMessage.MISSING_TELECOM_PARAM, hl7XTN);
        if ("Internet".equals(telecom.getType())) {
            ValidatorAssertions.metaDataAssert(StringUtils.isBlank((CharSequence)telecom.getUse()) || "NET".equals(telecom.getUse()), ValidationMessage.WRONG_TELECOM_USE, hl7XTN);
            ValidatorAssertions.metaDataAssert(StringUtils.isNotBlank((CharSequence)telecom.getEmail()), ValidationMessage.MISSING_TELECOM_PARAM, hl7XTN);
            ValidatorAssertions.metaDataAssert(telecom.getCountryCode() == null, ValidationMessage.INCONSISTENT_TELECOM_PARAM, hl7XTN);
            ValidatorAssertions.metaDataAssert(telecom.getAreaCityCode() == null, ValidationMessage.INCONSISTENT_TELECOM_PARAM, hl7XTN);
            ValidatorAssertions.metaDataAssert(telecom.getLocalNumber() == null, ValidationMessage.INCONSISTENT_TELECOM_PARAM, hl7XTN);
            ValidatorAssertions.metaDataAssert(telecom.getExtension() == null, ValidationMessage.INCONSISTENT_TELECOM_PARAM, hl7XTN);
            ValidatorAssertions.metaDataAssert(StringUtils.isBlank((CharSequence)telecom.getUnformattedPhoneNumber()), ValidationMessage.INCONSISTENT_TELECOM_PARAM, hl7XTN);
        } else if ("PH".equals(telecom.getType()) || "CP".equals(telecom.getType())) {
            ValidatorAssertions.metaDataAssert(!"NET".equals(telecom.getUse()), ValidationMessage.WRONG_TELECOM_USE, hl7XTN);
            ValidatorAssertions.metaDataAssert(StringUtils.isBlank((CharSequence)telecom.getEmail()), ValidationMessage.INCONSISTENT_TELECOM_PARAM, hl7XTN);
            boolean localPresent = telecom.getLocalNumber() != null;
            boolean unformattedPresent = StringUtils.isNotBlank((CharSequence)telecom.getUnformattedPhoneNumber());
            ValidatorAssertions.metaDataAssert(localPresent || unformattedPresent, ValidationMessage.MISSING_TELECOM_PARAM, hl7XTN);
            ValidatorAssertions.metaDataAssert(!localPresent || !unformattedPresent, ValidationMessage.INCONSISTENT_TELECOM_PARAM, hl7XTN);
        } else {
            throw new XDSMetaDataException(ValidationMessage.WRONG_TELECOM_TYPE, hl7XTN);
        }
    }
}

