/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.commons.ihe.xds.core.validate;

import ca.uhn.hl7v2.model.v25.datatype.HD;
import ca.uhn.hl7v2.model.v25.datatype.XON;
import org.apache.commons.lang3.StringUtils;
import org.openehealth.ipf.commons.ihe.xds.core.metadata.Organization;
import org.openehealth.ipf.commons.ihe.xds.core.validate.HDValidator;
import org.openehealth.ipf.commons.ihe.xds.core.validate.HL7ValidationUtils;
import org.openehealth.ipf.commons.ihe.xds.core.validate.OIDValidator;
import org.openehealth.ipf.commons.ihe.xds.core.validate.ValidationMessage;
import org.openehealth.ipf.commons.ihe.xds.core.validate.ValidatorAssertions;
import org.openehealth.ipf.commons.ihe.xds.core.validate.ValueValidator;
import org.openehealth.ipf.commons.ihe.xds.core.validate.XDSMetaDataException;

public class XONValidator
implements ValueValidator {
    private static final OIDValidator OID_VALIDATOR = new OIDValidator();
    private static final HDValidator HD_VALIDATOR = new HDValidator();

    @Override
    public void validate(String hl7XON) throws XDSMetaDataException {
        Organization organization = Organization.parse(hl7XON);
        ValidatorAssertions.metaDataAssert(organization != null, ValidationMessage.ORGANIZATION_NAME_MISSING, hl7XON);
        XON xon = (XON)organization.getHapiObject();
        ValidatorAssertions.metaDataAssert(StringUtils.isNotEmpty((CharSequence)xon.getXon1_OrganizationName().getValue()), ValidationMessage.ORGANIZATION_NAME_MISSING, hl7XON);
        HD hd = xon.getXon6_AssigningAuthority();
        if (HL7ValidationUtils.isEmptyField(hd)) {
            String idNumber = xon.getXon10_OrganizationIdentifier().getValue();
            if (StringUtils.isNotEmpty((CharSequence)idNumber)) {
                OID_VALIDATOR.validate(idNumber);
            }
        } else {
            HD_VALIDATOR.validate(hd, hl7XON);
        }
        ValidatorAssertions.metaDataAssert(StringUtils.countMatches((CharSequence)hl7XON, (CharSequence)"^") <= 9, ValidationMessage.ORGANIZATION_TOO_MANY_COMPONENTS, new Object[0]);
        ValidatorAssertions.metaDataAssert(StringUtils.isEmpty((CharSequence)xon.getXon2_OrganizationNameTypeCode().getValue()), ValidationMessage.ORGANIZATION_TOO_MANY_COMPONENTS, new Object[0]);
        ValidatorAssertions.metaDataAssert(StringUtils.isEmpty((CharSequence)xon.getXon3_IDNumber().getValue()), ValidationMessage.ORGANIZATION_TOO_MANY_COMPONENTS, new Object[0]);
        ValidatorAssertions.metaDataAssert(StringUtils.isEmpty((CharSequence)xon.getXon4_CheckDigit().getValue()), ValidationMessage.ORGANIZATION_TOO_MANY_COMPONENTS, new Object[0]);
        ValidatorAssertions.metaDataAssert(StringUtils.isEmpty((CharSequence)xon.getXon5_CheckDigitScheme().getValue()), ValidationMessage.ORGANIZATION_TOO_MANY_COMPONENTS, new Object[0]);
        ValidatorAssertions.metaDataAssert(StringUtils.isEmpty((CharSequence)xon.getXon7_IdentifierTypeCode().getValue()), ValidationMessage.ORGANIZATION_TOO_MANY_COMPONENTS, new Object[0]);
        ValidatorAssertions.metaDataAssert(HL7ValidationUtils.isEmptyField(xon.getXon8_AssigningFacility()), ValidationMessage.ORGANIZATION_TOO_MANY_COMPONENTS, new Object[0]);
        ValidatorAssertions.metaDataAssert(StringUtils.isEmpty((CharSequence)xon.getXon9_NameRepresentationCode().getValue()), ValidationMessage.ORGANIZATION_TOO_MANY_COMPONENTS, new Object[0]);
    }
}

