/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.commons.ihe.xds.core.validate;

import org.openehealth.ipf.commons.core.modules.api.ValidationException;
import org.openehealth.ipf.commons.ihe.xds.core.transform.requests.QueryParameter;
import org.openehealth.ipf.commons.ihe.xds.core.validate.ValidationMessage;

public class XDSMetaDataException
extends ValidationException {
    private final ValidationMessage validationMessage;

    public XDSMetaDataException(ValidationMessage validationMessage, Object ... details) {
        super(String.format(validationMessage.getText(), XDSMetaDataException.unwrapQueryParameterNames(details)));
        this.validationMessage = validationMessage;
    }

    public ValidationMessage getValidationMessage() {
        return this.validationMessage;
    }

    private static Object[] unwrapQueryParameterNames(Object[] array) {
        for (int i = 0; i < array.length; ++i) {
            QueryParameter[] params;
            Object object = array[i];
            if (object instanceof QueryParameter) {
                QueryParameter param = (QueryParameter)((Object)object);
                array[i] = param.getSlotName();
                continue;
            }
            object = array[i];
            if (!(object instanceof QueryParameter[]) || (params = (QueryParameter[])object).length <= 0) continue;
            StringBuilder sb = new StringBuilder();
            for (QueryParameter param : params) {
                sb.append(", ").append(param.getSlotName());
            }
            array[i] = sb.replace(0, 2, "[").append(']').toString();
        }
        return array;
    }
}

