/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.commons.ihe.xds.core.validate;

import java.util.Objects;
import java.util.regex.Pattern;
import org.openehealth.ipf.commons.ihe.xds.core.validate.ValidationMessage;
import org.openehealth.ipf.commons.ihe.xds.core.validate.ValidatorAssertions;
import org.openehealth.ipf.commons.ihe.xds.core.validate.ValueValidator;
import org.openehealth.ipf.commons.ihe.xds.core.validate.XDSMetaDataException;

public class TimeValidator
implements ValueValidator {
    private static final String YEAR = "[0-9]{4}";
    private static final String MONTH = "(0[1-9]|1[012])";
    private static final String DAY = "(0[1-9]|[12][0-9]|3[01])";
    private static final String HOUR = "([01][0-9]|2[0123])";
    private static final String MIN_SEC = "[0-5][0-9]";
    private static final String REG_EX = "[0-9]{4}((0[1-9]|1[012])((0[1-9]|[12][0-9]|3[01])(([01][0-9]|2[0123])([0-5][0-9]([0-5][0-9])?)?)?)?)?";
    private static final Pattern TIME_PATTERN = Pattern.compile("[0-9]{4}((0[1-9]|1[012])((0[1-9]|[12][0-9]|3[01])(([01][0-9]|2[0123])([0-5][0-9]([0-5][0-9])?)?)?)?)?");
    private final int minLen;

    public TimeValidator(int minLen) {
        this.minLen = minLen;
    }

    public TimeValidator() {
        this(-1);
    }

    @Override
    public void validate(String time) throws XDSMetaDataException {
        Objects.requireNonNull(time, "time cannot be null");
        ValidatorAssertions.metaDataAssert(TIME_PATTERN.matcher(time).matches(), ValidationMessage.INVALID_TIME, time);
        ValidatorAssertions.metaDataAssert(this.minLen < 0 || time.length() >= this.minLen, ValidationMessage.TIME_PRECISION_TOO_LOW, time);
    }
}

