/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.commons.ihe.xds.core.validate;

import java.util.Objects;
import java.util.regex.Pattern;
import org.openehealth.ipf.commons.ihe.xds.core.validate.ValidationMessage;
import org.openehealth.ipf.commons.ihe.xds.core.validate.ValidatorAssertions;
import org.openehealth.ipf.commons.ihe.xds.core.validate.ValueValidator;
import org.openehealth.ipf.commons.ihe.xds.core.validate.XDSMetaDataException;

public class MimeTypeValidator
implements ValueValidator {
    private static final Pattern MIME_PATTERN = Pattern.compile("\\w+\\/[-+.\\w]+");

    @Override
    public void validate(String mimeType) throws XDSMetaDataException {
        Objects.requireNonNull(mimeType, "mimeType cannot be null");
        ValidatorAssertions.metaDataAssert(MIME_PATTERN.matcher(mimeType).matches(), ValidationMessage.MIME_TYPE_FORMAT, mimeType);
    }
}

