/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.commons.ihe.xds.core.validate;

import java.util.Objects;
import java.util.regex.Pattern;
import org.openehealth.ipf.commons.ihe.xds.core.validate.ValidationMessage;
import org.openehealth.ipf.commons.ihe.xds.core.validate.ValidatorAssertions;
import org.openehealth.ipf.commons.ihe.xds.core.validate.ValueValidator;
import org.openehealth.ipf.commons.ihe.xds.core.validate.XDSMetaDataException;

public class IdentifierValidator
implements ValueValidator {
    private static final Pattern PATTERN = Pattern.compile("[\\x21-\\x7E]+");

    @Override
    public void validate(String identifier) throws XDSMetaDataException {
        Objects.requireNonNull(identifier, "identifier cannot be null");
        ValidatorAssertions.metaDataAssert(PATTERN.matcher(identifier).matches(), ValidationMessage.INVALID_IDENTIFIER, identifier);
    }
}

