/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.commons.ihe.xds.core.validate;

import java.util.Objects;
import java.util.regex.Pattern;
import org.openehealth.ipf.commons.ihe.xds.core.validate.ValidationMessage;
import org.openehealth.ipf.commons.ihe.xds.core.validate.ValidatorAssertions;
import org.openehealth.ipf.commons.ihe.xds.core.validate.ValueValidator;
import org.openehealth.ipf.commons.ihe.xds.core.validate.XDSMetaDataException;

public class HashValidator
implements ValueValidator {
    private static final Pattern HASH_PATTERN = Pattern.compile("[a-fA-F0-9]{40}");

    @Override
    public void validate(String value) throws XDSMetaDataException {
        Objects.requireNonNull(value, "value cannot be null");
        ValidatorAssertions.metaDataAssert(HASH_PATTERN.matcher(value).matches(), ValidationMessage.INVALID_HASH_CODE, value);
    }
}

