/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.commons.ihe.xds.core.validate;

import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.openehealth.ipf.commons.ihe.xds.core.ebxml.EbXMLClassification;
import org.openehealth.ipf.commons.ihe.xds.core.ebxml.EbXMLRegistryObject;
import org.openehealth.ipf.commons.ihe.xds.core.metadata.Vocabulary;
import org.openehealth.ipf.commons.ihe.xds.core.validate.RegistryObjectValidator;
import org.openehealth.ipf.commons.ihe.xds.core.validate.SlotValueValidation;
import org.openehealth.ipf.commons.ihe.xds.core.validate.ValidationMessage;
import org.openehealth.ipf.commons.ihe.xds.core.validate.ValidatorAssertions;
import org.openehealth.ipf.commons.ihe.xds.core.validate.XDSMetaDataException;

public class ClassificationValidation
implements RegistryObjectValidator {
    protected final String classScheme;
    private final int min;
    private final int max;
    private final Vocabulary.DisplayNameUsage displayNameUsage;
    private final Vocabulary.NodeRepresentationUsage nodeRepresentationUsage;
    private final SlotValueValidation[] slotValidations;

    public ClassificationValidation(String classScheme, int min, int max, Vocabulary.DisplayNameUsage displayNameUsage, SlotValueValidation[] slotValidations) {
        this(classScheme, min, max, displayNameUsage, Vocabulary.NodeRepresentationUsage.REQUIRED, slotValidations);
    }

    public ClassificationValidation(String classScheme, int min, int max, Vocabulary.DisplayNameUsage displayNameUsage, Vocabulary.NodeRepresentationUsage nodeRepresentationUsage, SlotValueValidation[] slotValidations) {
        this.classScheme = Objects.requireNonNull(classScheme);
        this.min = min;
        this.max = max;
        this.displayNameUsage = Objects.requireNonNull(displayNameUsage);
        this.nodeRepresentationUsage = nodeRepresentationUsage;
        this.slotValidations = slotValidations;
    }

    @Override
    public void validate(EbXMLRegistryObject obj) throws XDSMetaDataException {
        List<EbXMLClassification> classifications = obj.getClassifications(this.classScheme);
        ValidatorAssertions.metaDataAssert(classifications.size() >= this.min && classifications.size() <= this.max, ValidationMessage.WRONG_NUMBER_OF_CLASSIFICATIONS, this.classScheme, this.min, this.max, classifications.size());
        for (EbXMLClassification classification : classifications) {
            ValidatorAssertions.metaDataAssert(classification.getClassifiedObject() != null, ValidationMessage.NO_CLASSIFIED_OBJ, this.classScheme);
            ValidatorAssertions.metaDataAssert(classification.getClassifiedObject().equals(obj.getId()), ValidationMessage.WRONG_CLASSIFIED_OBJ, obj.getId(), classification.getClassifiedObject());
            switch (this.nodeRepresentationUsage) {
                case REQUIRED: {
                    ValidatorAssertions.metaDataAssert(StringUtils.isNotEmpty((CharSequence)classification.getNodeRepresentation()), ValidationMessage.NODE_REPRESENTATION_MISSING, this.classScheme);
                    break;
                }
                case PROHIBITED: {
                    ValidatorAssertions.metaDataAssert(StringUtils.isEmpty((CharSequence)classification.getNodeRepresentation()), ValidationMessage.NODE_REPRESENTATION_PROHIBITED, this.classScheme);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unsupported node representation optionality " + this.nodeRepresentationUsage);
                }
            }
            switch (this.displayNameUsage) {
                case OPTIONAL: {
                    break;
                }
                case REQUIRED: {
                    ClassificationValidation.assertDisplayNamePresent(classification, this.classScheme);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unsupported display name usage " + this.displayNameUsage);
                }
            }
            if (this.slotValidations == null) continue;
            for (SlotValueValidation slotValidation : this.slotValidations) {
                slotValidation.validate(classification);
            }
        }
    }

    public static void assertDisplayNamePresent(EbXMLClassification classification, String classificationScheme) {
        ValidatorAssertions.metaDataAssert(classification.getName() != null, ValidationMessage.NO_CLASSIFICATION_NAME_OBJ, classificationScheme, classification.getClassifiedObject());
        ValidatorAssertions.metaDataAssert(classification.getName().getValue() != null, ValidationMessage.NO_CLASSIFICATION_NAME_OBJ, classificationScheme, classification.getClassifiedObject());
    }
}

