/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.commons.ihe.xds.core.transform.responses;

import java.util.Objects;
import org.openehealth.ipf.commons.ihe.xds.core.ebxml.EbXMLFactory;
import org.openehealth.ipf.commons.ihe.xds.core.ebxml.EbXMLRetrieveDocumentSetResponse;
import org.openehealth.ipf.commons.ihe.xds.core.ebxml.ebxml30.RetrieveDocumentSetResponseType;
import org.openehealth.ipf.commons.ihe.xds.core.responses.RetrievedDocumentSet;
import org.openehealth.ipf.commons.ihe.xds.core.transform.responses.ErrorInfoListTransformer;

public class RetrieveDocumentSetResponseTransformer {
    private final EbXMLFactory factory;
    private final ErrorInfoListTransformer errorInfoListTransformer;

    public RetrieveDocumentSetResponseTransformer(EbXMLFactory factory) {
        this.factory = Objects.requireNonNull(factory, "factory cannot be null");
        this.errorInfoListTransformer = new ErrorInfoListTransformer(factory);
    }

    public EbXMLRetrieveDocumentSetResponse<RetrieveDocumentSetResponseType> toEbXML(RetrievedDocumentSet response) {
        if (response == null) {
            return null;
        }
        EbXMLRetrieveDocumentSetResponse<RetrieveDocumentSetResponseType> ebXML = this.factory.createRetrieveDocumentSetResponse();
        if (!response.getErrors().isEmpty()) {
            ebXML.setErrors(this.errorInfoListTransformer.toEbXML(response.getErrors()));
        }
        ebXML.setStatus(response.getStatus());
        ebXML.setDocuments(response.getDocuments());
        return ebXML;
    }

    public RetrievedDocumentSet fromEbXML(EbXMLRetrieveDocumentSetResponse<RetrieveDocumentSetResponseType> ebXML) {
        if (ebXML == null) {
            return null;
        }
        RetrievedDocumentSet response = new RetrievedDocumentSet();
        response.getDocuments().addAll(ebXML.getDocuments());
        if (!ebXML.getErrors().isEmpty()) {
            response.setErrors(this.errorInfoListTransformer.fromEbXML(ebXML.getErrors()));
        }
        response.setStatus(ebXML.getStatus());
        return response;
    }
}

