/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.commons.ihe.xds.core.transform.responses;

import java.util.Objects;
import org.openehealth.ipf.commons.ihe.xds.core.ebxml.EbXMLFactory;
import org.openehealth.ipf.commons.ihe.xds.core.ebxml.EbXMLRegistryResponse;
import org.openehealth.ipf.commons.ihe.xds.core.responses.Response;
import org.openehealth.ipf.commons.ihe.xds.core.stub.ebrs30.rs.RegistryResponseType;
import org.openehealth.ipf.commons.ihe.xds.core.transform.responses.ErrorInfoListTransformer;

public class ResponseTransformer {
    private final EbXMLFactory factory;
    private final ErrorInfoListTransformer errorInfoListTransformer;

    public ResponseTransformer(EbXMLFactory factory) {
        this.factory = Objects.requireNonNull(factory, "factory cannot be null");
        this.errorInfoListTransformer = new ErrorInfoListTransformer(factory);
    }

    public EbXMLRegistryResponse<RegistryResponseType> toEbXML(Response response) {
        Objects.requireNonNull(response, "response cannot be null");
        EbXMLRegistryResponse<RegistryResponseType> ebXML = this.factory.createRegistryResponse();
        ebXML.setStatus(response.getStatus());
        if (!response.getErrors().isEmpty()) {
            ebXML.setErrors(this.errorInfoListTransformer.toEbXML(response.getErrors()));
        }
        return ebXML;
    }

    public Response fromEbXML(EbXMLRegistryResponse<RegistryResponseType> ebXML) {
        Objects.requireNonNull(ebXML, "ebXML cannot be null");
        Response response = new Response();
        response.setStatus(ebXML.getStatus());
        if (!ebXML.getErrors().isEmpty()) {
            response.setErrors(this.errorInfoListTransformer.fromEbXML(ebXML.getErrors()));
        }
        return response;
    }
}

