/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.commons.ihe.xds.core.transform.requests.query;

import lombok.Generated;
import org.openehealth.ipf.commons.ihe.xds.core.metadata.Hl7v2Based;
import org.openehealth.ipf.commons.ihe.xds.core.metadata.Identifiable;
import org.openehealth.ipf.commons.ihe.xds.core.requests.query.FindSubmissionSetsQuery;
import org.openehealth.ipf.commons.ihe.xds.core.transform.requests.QueryParameter;
import org.openehealth.ipf.commons.ihe.xds.core.transform.requests.query.AbstractStoredQueryTransformer;
import org.openehealth.ipf.commons.ihe.xds.core.transform.requests.query.QuerySlotHelper;

public class FindSubmissionSetsQueryTransformer
extends AbstractStoredQueryTransformer<FindSubmissionSetsQuery> {
    private static final FindSubmissionSetsQueryTransformer instance = new FindSubmissionSetsQueryTransformer();

    private FindSubmissionSetsQueryTransformer() {
    }

    @Override
    protected void toEbXML(FindSubmissionSetsQuery query, QuerySlotHelper slots) {
        super.toEbXML(query, slots);
        slots.fromString(QueryParameter.SUBMISSION_SET_PATIENT_ID, Hl7v2Based.render(query.getPatientId()));
        slots.fromStringList(QueryParameter.SUBMISSION_SET_SOURCE_ID, query.getSourceIds());
        slots.fromTimestamp(QueryParameter.SUBMISSION_SET_SUBMISSION_TIME_FROM, query.getSubmissionTime().getFrom());
        slots.fromTimestamp(QueryParameter.SUBMISSION_SET_SUBMISSION_TIME_TO, query.getSubmissionTime().getTo());
        slots.fromString(QueryParameter.SUBMISSION_SET_AUTHOR_PERSON, query.getAuthorPerson());
        slots.fromCode(QueryParameter.SUBMISSION_SET_CONTENT_TYPE_CODE, query.getContentTypeCodes());
        slots.fromStatus(QueryParameter.SUBMISSION_SET_STATUS, query.getStatus());
    }

    @Override
    protected void fromEbXML(FindSubmissionSetsQuery query, QuerySlotHelper slots) {
        super.fromEbXML(query, slots);
        String patientId = slots.toString(QueryParameter.SUBMISSION_SET_PATIENT_ID);
        query.setPatientId(Identifiable.parse(patientId));
        query.setSourceIds(slots.toStringList(QueryParameter.SUBMISSION_SET_SOURCE_ID));
        query.getSubmissionTime().setFrom(slots.toTimestamp(QueryParameter.SUBMISSION_SET_SUBMISSION_TIME_FROM));
        query.getSubmissionTime().setTo(slots.toTimestamp(QueryParameter.SUBMISSION_SET_SUBMISSION_TIME_TO));
        query.setAuthorPerson(slots.toString(QueryParameter.SUBMISSION_SET_AUTHOR_PERSON));
        query.setContentTypeCodes(slots.toCodeList(QueryParameter.SUBMISSION_SET_CONTENT_TYPE_CODE));
        query.setStatus(slots.toStatus(QueryParameter.SUBMISSION_SET_STATUS));
    }

    @Generated
    public static FindSubmissionSetsQueryTransformer getInstance() {
        return instance;
    }
}

