/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.commons.ihe.xds.core.transform.requests.query;

import lombok.Generated;
import org.openehealth.ipf.commons.ihe.xds.core.metadata.Hl7v2Based;
import org.openehealth.ipf.commons.ihe.xds.core.metadata.Identifiable;
import org.openehealth.ipf.commons.ihe.xds.core.requests.query.FindFoldersQuery;
import org.openehealth.ipf.commons.ihe.xds.core.transform.requests.QueryParameter;
import org.openehealth.ipf.commons.ihe.xds.core.transform.requests.query.AbstractStoredQueryTransformer;
import org.openehealth.ipf.commons.ihe.xds.core.transform.requests.query.QuerySlotHelper;

public class FindFoldersQueryTransformer
extends AbstractStoredQueryTransformer<FindFoldersQuery> {
    private static final FindFoldersQueryTransformer instance = new FindFoldersQueryTransformer();

    private FindFoldersQueryTransformer() {
    }

    @Override
    protected void toEbXML(FindFoldersQuery query, QuerySlotHelper slots) {
        super.toEbXML(query, slots);
        slots.fromString(QueryParameter.FOLDER_PATIENT_ID, Hl7v2Based.render(query.getPatientId()));
        slots.fromTimestamp(QueryParameter.FOLDER_LAST_UPDATE_TIME_FROM, query.getLastUpdateTime().getFrom());
        slots.fromTimestamp(QueryParameter.FOLDER_LAST_UPDATE_TIME_TO, query.getLastUpdateTime().getTo());
        slots.fromCode(QueryParameter.FOLDER_CODES, query.getCodes());
        slots.fromStatus(QueryParameter.FOLDER_STATUS, query.getStatus());
        slots.fromInteger(QueryParameter.METADATA_LEVEL, query.getMetadataLevel());
    }

    @Override
    protected void fromEbXML(FindFoldersQuery query, QuerySlotHelper slots) {
        super.fromEbXML(query, slots);
        String patientId = slots.toString(QueryParameter.FOLDER_PATIENT_ID);
        query.setPatientId(Identifiable.parse(patientId));
        query.setCodes(slots.toCodeQueryList(QueryParameter.FOLDER_CODES, QueryParameter.FOLDER_CODES_SCHEME));
        query.getLastUpdateTime().setFrom(slots.toTimestamp(QueryParameter.FOLDER_LAST_UPDATE_TIME_FROM));
        query.getLastUpdateTime().setTo(slots.toTimestamp(QueryParameter.FOLDER_LAST_UPDATE_TIME_TO));
        query.setStatus(slots.toStatus(QueryParameter.FOLDER_STATUS));
        query.setMetadataLevel(slots.toInteger(QueryParameter.METADATA_LEVEL));
    }

    @Generated
    public static FindFoldersQueryTransformer getInstance() {
        return instance;
    }
}

