/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.commons.ihe.xds.core.transform.requests.query;

import org.openehealth.ipf.commons.ihe.xds.core.ebxml.EbXMLAdhocQueryRequest;
import org.openehealth.ipf.commons.ihe.xds.core.ebxml.EbXMLSlot;
import org.openehealth.ipf.commons.ihe.xds.core.requests.query.Query;
import org.openehealth.ipf.commons.ihe.xds.core.requests.query.QueryList;
import org.openehealth.ipf.commons.ihe.xds.core.requests.query.StoredQuery;
import org.openehealth.ipf.commons.ihe.xds.core.requests.query.TargetCommunityIdListBasedStoredQuery;
import org.openehealth.ipf.commons.ihe.xds.core.stub.ebrs30.query.AdhocQueryRequest;
import org.openehealth.ipf.commons.ihe.xds.core.transform.requests.QueryParameter;
import org.openehealth.ipf.commons.ihe.xds.core.transform.requests.query.QuerySlotHelper;

abstract class AbstractStoredQueryTransformer<T extends StoredQuery> {
    AbstractStoredQueryTransformer() {
    }

    public void toEbXML(T query, EbXMLAdhocQueryRequest<AdhocQueryRequest> ebXML) {
        if (query == null || ebXML == null) {
            return;
        }
        ebXML.setId(((Query)query).getType().getId());
        ebXML.setHome(((StoredQuery)query).getHomeCommunityId());
        this.toEbXML(query, new QuerySlotHelper(ebXML));
    }

    public void fromEbXML(T query, EbXMLAdhocQueryRequest<AdhocQueryRequest> ebXML) {
        if (query == null || ebXML == null) {
            return;
        }
        ((StoredQuery)query).setHomeCommunityId(ebXML.getHome());
        this.fromEbXML(query, new QuerySlotHelper(ebXML));
    }

    protected void toEbXML(T query, QuerySlotHelper slots) {
        ((StoredQuery)query).getExtraParameters().forEach(slots::fromStringList);
        if (query instanceof TargetCommunityIdListBasedStoredQuery) {
            TargetCommunityIdListBasedStoredQuery query2 = (TargetCommunityIdListBasedStoredQuery)query;
            slots.fromStringList(QueryParameter.TARGET_COMMUNITY_IDS, query2.getTargetCommunityIds());
        }
    }

    protected void fromEbXML(T query, QuerySlotHelper slots) {
        slots.getSlots().stream().map(EbXMLSlot::getName).filter(slotName -> QueryParameter.valueOfSlotName(slotName) == null && !query.getExtraParameters().containsKey(slotName)).forEach(slotName -> {
            QueryList<String> queryList = slots.toStringQueryList((String)slotName);
            if (queryList != null) {
                query.getExtraParameters().put((String)slotName, queryList);
            }
        });
        if (query instanceof TargetCommunityIdListBasedStoredQuery) {
            TargetCommunityIdListBasedStoredQuery query2 = (TargetCommunityIdListBasedStoredQuery)query;
            query2.setTargetCommunityIds(slots.toStringList(QueryParameter.TARGET_COMMUNITY_IDS));
        }
    }
}

