/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.commons.ihe.xds.core.transform.requests;

import java.util.List;
import java.util.Objects;
import org.openehealth.ipf.commons.ihe.xds.core.ebxml.EbXMLAssociation;
import org.openehealth.ipf.commons.ihe.xds.core.ebxml.EbXMLExtrinsicObject;
import org.openehealth.ipf.commons.ihe.xds.core.ebxml.EbXMLFactory;
import org.openehealth.ipf.commons.ihe.xds.core.ebxml.EbXMLObjectLibrary;
import org.openehealth.ipf.commons.ihe.xds.core.ebxml.EbXMLRegistryPackage;
import org.openehealth.ipf.commons.ihe.xds.core.ebxml.EbXMLSubmitObjectsRequest;
import org.openehealth.ipf.commons.ihe.xds.core.metadata.Association;
import org.openehealth.ipf.commons.ihe.xds.core.metadata.DocumentEntry;
import org.openehealth.ipf.commons.ihe.xds.core.metadata.DocumentEntryType;
import org.openehealth.ipf.commons.ihe.xds.core.metadata.Folder;
import org.openehealth.ipf.commons.ihe.xds.core.metadata.SubmissionSet;
import org.openehealth.ipf.commons.ihe.xds.core.requests.RegisterDocumentSet;
import org.openehealth.ipf.commons.ihe.xds.core.stub.ebrs30.lcm.SubmitObjectsRequest;
import org.openehealth.ipf.commons.ihe.xds.core.transform.ebxml.LeafClassTransformer;

public class RegisterDocumentSetTransformer
extends LeafClassTransformer {
    public RegisterDocumentSetTransformer(EbXMLFactory factory) {
        super(factory);
    }

    public EbXMLSubmitObjectsRequest<SubmitObjectsRequest> toEbXML(RegisterDocumentSet request) {
        Objects.requireNonNull(request, "request cannot be null");
        EbXMLSubmitObjectsRequest<SubmitObjectsRequest> ebXML = this.factory.createSubmitObjectsRequest();
        EbXMLObjectLibrary library = ebXML.getObjectLibrary();
        for (DocumentEntry docEntry : request.getDocumentEntries()) {
            ebXML.addExtrinsicObject((EbXMLExtrinsicObject)this.documentEntryTransformer.toEbXML(docEntry, library));
        }
        for (Folder folder : request.getFolders()) {
            this.handleFolder(folder, ebXML, library);
        }
        this.handleSubmissionSet(request.getSubmissionSet(), ebXML, library);
        for (Association association : request.getAssociations()) {
            ebXML.addAssociation(this.associationTransformer.toEbXML(association, library));
        }
        return ebXML;
    }

    public RegisterDocumentSet fromEbXML(EbXMLSubmitObjectsRequest<SubmitObjectsRequest> ebXML) {
        Objects.requireNonNull(ebXML, "ebXML cannot be null");
        RegisterDocumentSet request = new RegisterDocumentSet();
        for (EbXMLExtrinsicObject extrinsic : ebXML.getExtrinsicObjects(DocumentEntryType.STABLE_OR_ON_DEMAND)) {
            request.getDocumentEntries().add((DocumentEntry)this.documentEntryTransformer.fromEbXML(extrinsic));
        }
        for (EbXMLRegistryPackage regPackage : ebXML.getRegistryPackages("urn:uuid:d9d542f3-6cc4-48b6-8870-ea235fbc94c2")) {
            request.getFolders().add((Folder)this.folderTransformer.fromEbXML(regPackage));
        }
        List<EbXMLRegistryPackage> regPackages = ebXML.getRegistryPackages("urn:uuid:a54d6aa5-d40d-43f9-88c5-b4633d873bdd");
        if (!regPackages.isEmpty()) {
            request.setSubmissionSet((SubmissionSet)this.submissionSetTransformer.fromEbXML(regPackages.get(0)));
        }
        for (EbXMLAssociation association : ebXML.getAssociations()) {
            request.getAssociations().add(this.associationTransformer.fromEbXML(association));
        }
        return request;
    }
}

