/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.commons.ihe.xds.core.transform.requests;

import jakarta.activation.DataHandler;
import java.util.List;
import java.util.Map;
import org.openehealth.ipf.commons.ihe.xds.core.ebxml.EbXMLAssociation;
import org.openehealth.ipf.commons.ihe.xds.core.ebxml.EbXMLExtrinsicObject;
import org.openehealth.ipf.commons.ihe.xds.core.ebxml.EbXMLFactory;
import org.openehealth.ipf.commons.ihe.xds.core.ebxml.EbXMLObjectLibrary;
import org.openehealth.ipf.commons.ihe.xds.core.ebxml.EbXMLProvideAndRegisterDocumentSetRequest;
import org.openehealth.ipf.commons.ihe.xds.core.ebxml.EbXMLRegistryPackage;
import org.openehealth.ipf.commons.ihe.xds.core.ebxml.ebxml30.ProvideAndRegisterDocumentSetRequestType;
import org.openehealth.ipf.commons.ihe.xds.core.metadata.Association;
import org.openehealth.ipf.commons.ihe.xds.core.metadata.Document;
import org.openehealth.ipf.commons.ihe.xds.core.metadata.DocumentEntry;
import org.openehealth.ipf.commons.ihe.xds.core.metadata.DocumentEntryType;
import org.openehealth.ipf.commons.ihe.xds.core.metadata.Folder;
import org.openehealth.ipf.commons.ihe.xds.core.metadata.SubmissionSet;
import org.openehealth.ipf.commons.ihe.xds.core.requests.ProvideAndRegisterDocumentSet;
import org.openehealth.ipf.commons.ihe.xds.core.transform.ebxml.LeafClassTransformer;

public class ProvideAndRegisterDocumentSetTransformer
extends LeafClassTransformer {
    public ProvideAndRegisterDocumentSetTransformer(EbXMLFactory factory) {
        super(factory);
    }

    public EbXMLProvideAndRegisterDocumentSetRequest<ProvideAndRegisterDocumentSetRequestType> toEbXML(ProvideAndRegisterDocumentSet request) {
        if (request == null) {
            return null;
        }
        EbXMLObjectLibrary library = this.factory.createObjectLibrary();
        EbXMLProvideAndRegisterDocumentSetRequest<ProvideAndRegisterDocumentSetRequestType> ebXML = this.factory.createProvideAndRegisterDocumentSetRequest(library);
        for (Document doc : request.getDocuments()) {
            DocumentEntry docEntry = doc.getDocumentEntry();
            if (docEntry == null) continue;
            ebXML.addExtrinsicObject((EbXMLExtrinsicObject)this.documentEntryTransformer.toEbXML(docEntry, library));
            ebXML.addDocument(docEntry.getEntryUuid(), (DataHandler)doc.getContent(DataHandler.class));
        }
        for (Folder folder : request.getFolders()) {
            this.handleFolder(folder, ebXML, library);
        }
        this.handleSubmissionSet(request.getSubmissionSet(), ebXML, library);
        for (Association association : request.getAssociations()) {
            ebXML.addAssociation(this.associationTransformer.toEbXML(association, library));
        }
        if (request.getTargetHomeCommunityId() != null) {
            ebXML.addSlot("homeCommunityId", request.getTargetHomeCommunityId());
        }
        return ebXML;
    }

    public ProvideAndRegisterDocumentSet fromEbXML(EbXMLProvideAndRegisterDocumentSetRequest<ProvideAndRegisterDocumentSetRequestType> ebXML) {
        if (ebXML == null) {
            return null;
        }
        ProvideAndRegisterDocumentSet request = new ProvideAndRegisterDocumentSet();
        Map<String, DataHandler> documents = ebXML.getDocuments();
        for (EbXMLExtrinsicObject extrinsic : ebXML.getExtrinsicObjects(DocumentEntryType.STABLE.getUuid())) {
            DocumentEntry docEntry = (DocumentEntry)this.documentEntryTransformer.fromEbXML(extrinsic);
            if (docEntry == null) continue;
            Document document = new Document();
            document.setDocumentEntry(docEntry);
            if (docEntry.getEntryUuid() != null) {
                String id = docEntry.getEntryUuid();
                DataHandler data = documents.get(id);
                document.setContent(DataHandler.class, data);
            }
            request.getDocuments().add(document);
        }
        for (EbXMLRegistryPackage regPackage : ebXML.getRegistryPackages("urn:uuid:d9d542f3-6cc4-48b6-8870-ea235fbc94c2")) {
            request.getFolders().add((Folder)this.folderTransformer.fromEbXML(regPackage));
        }
        List<EbXMLRegistryPackage> regPackages = ebXML.getRegistryPackages("urn:uuid:a54d6aa5-d40d-43f9-88c5-b4633d873bdd");
        if (!regPackages.isEmpty()) {
            request.setSubmissionSet((SubmissionSet)this.submissionSetTransformer.fromEbXML(regPackages.get(0)));
        }
        for (EbXMLAssociation association : ebXML.getAssociations()) {
            request.getAssociations().add(this.associationTransformer.fromEbXML(association));
        }
        request.setTargetHomeCommunityId(ebXML.getSingleSlotValue("homeCommunityId"));
        return request;
    }
}

