/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.commons.ihe.xds.core.transform.ebxml;

import java.util.Objects;
import org.openehealth.ipf.commons.ihe.xds.core.ebxml.EbXMLClassification;
import org.openehealth.ipf.commons.ihe.xds.core.ebxml.EbXMLFactory;
import org.openehealth.ipf.commons.ihe.xds.core.ebxml.EbXMLObjectContainer;
import org.openehealth.ipf.commons.ihe.xds.core.ebxml.EbXMLObjectLibrary;
import org.openehealth.ipf.commons.ihe.xds.core.ebxml.EbXMLRegistryPackage;
import org.openehealth.ipf.commons.ihe.xds.core.metadata.Folder;
import org.openehealth.ipf.commons.ihe.xds.core.metadata.SubmissionSet;
import org.openehealth.ipf.commons.ihe.xds.core.metadata.XDSMetaClass;
import org.openehealth.ipf.commons.ihe.xds.core.transform.ebxml.AssociationTransformer;
import org.openehealth.ipf.commons.ihe.xds.core.transform.ebxml.DocumentEntryTransformer;
import org.openehealth.ipf.commons.ihe.xds.core.transform.ebxml.FolderTransformer;
import org.openehealth.ipf.commons.ihe.xds.core.transform.ebxml.SubmissionSetTransformer;
import org.openehealth.ipf.commons.ihe.xds.core.transform.ebxml.XDSMetaClassTransformer;

public class LeafClassTransformer {
    public static final String PROPERTY_SUBMISSION_SET_CLASSIFICATION_INSIDE = LeafClassTransformer.class.getName() + ".ss-cl-inside";
    public static final String PROPERTY_FOLDER_CLASSIFICATION_INSIDE = LeafClassTransformer.class.getName() + ".f-cl-inside";
    protected final EbXMLFactory factory;
    protected final SubmissionSetTransformer submissionSetTransformer;
    protected final DocumentEntryTransformer documentEntryTransformer;
    protected final FolderTransformer folderTransformer;
    protected final AssociationTransformer associationTransformer;

    protected LeafClassTransformer(EbXMLFactory factory) {
        this.factory = Objects.requireNonNull(factory, "factory cannot be null");
        this.submissionSetTransformer = new SubmissionSetTransformer(factory);
        this.documentEntryTransformer = new DocumentEntryTransformer(factory);
        this.folderTransformer = new FolderTransformer(factory);
        this.associationTransformer = new AssociationTransformer(factory);
    }

    protected void handleSubmissionSet(SubmissionSet submissionSet, EbXMLObjectContainer container, EbXMLObjectLibrary library) {
        this.handleRegistryPackage(submissionSet, this.submissionSetTransformer, container, library, PROPERTY_SUBMISSION_SET_CLASSIFICATION_INSIDE, "urn:uuid:a54d6aa5-d40d-43f9-88c5-b4633d873bdd");
    }

    protected void handleFolder(Folder folder, EbXMLObjectContainer container, EbXMLObjectLibrary library) {
        this.handleRegistryPackage(folder, this.folderTransformer, container, library, PROPERTY_FOLDER_CLASSIFICATION_INSIDE, "urn:uuid:d9d542f3-6cc4-48b6-8870-ea235fbc94c2");
    }

    private <T extends XDSMetaClass> void handleRegistryPackage(T object, XDSMetaClassTransformer<EbXMLRegistryPackage, T> transformer, EbXMLObjectContainer container, EbXMLObjectLibrary library, String classificationInsidePropertyName, String classificationNodeName) {
        if (object != null) {
            EbXMLRegistryPackage ebXmlObject = transformer.toEbXML(object, library);
            if (Boolean.getBoolean(classificationInsidePropertyName)) {
                EbXMLClassification classification = this.createClassification(object.getEntryUuid(), classificationNodeName, library);
                ebXmlObject.addClassification(classification, "");
            } else {
                this.addClassification(container, object.getEntryUuid(), classificationNodeName, library);
            }
            container.addRegistryPackage(ebXmlObject);
        }
    }

    protected EbXMLClassification createClassification(String classified, String node, EbXMLObjectLibrary library) {
        EbXMLClassification classification = this.factory.createClassification(library);
        classification.setClassifiedObject(classified);
        classification.setClassificationNode(node);
        classification.assignUniqueId();
        return classification;
    }

    protected void addClassification(EbXMLObjectContainer ebXML, String classified, String node, EbXMLObjectLibrary library) {
        EbXMLClassification classification = this.createClassification(classified, node, library);
        ebXML.addClassification(classification);
    }
}

