/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.commons.ihe.xds.core.transform.ebxml;

import java.util.List;
import java.util.Objects;
import org.openehealth.ipf.commons.ihe.xds.core.ebxml.EbXMLClassification;
import org.openehealth.ipf.commons.ihe.xds.core.ebxml.EbXMLFactory;
import org.openehealth.ipf.commons.ihe.xds.core.ebxml.EbXMLObjectLibrary;
import org.openehealth.ipf.commons.ihe.xds.core.metadata.Code;

public class CodeTransformer {
    private final EbXMLFactory factory;

    public CodeTransformer(EbXMLFactory ebXMLFactory) {
        this.factory = Objects.requireNonNull(ebXMLFactory, "ebXMLFactory cannot be null");
    }

    public EbXMLClassification toEbXML(Code code, EbXMLObjectLibrary objectLibrary) {
        if (code == null) {
            return null;
        }
        EbXMLClassification classification = this.factory.createClassification(objectLibrary);
        classification.setNodeRepresentation(code.getCode());
        classification.setName(code.getDisplayName());
        if (code.getSchemeName() != null) {
            classification.addSlot("codingScheme", code.getSchemeName());
        }
        return classification;
    }

    public Code fromEbXML(EbXMLClassification classification) {
        if (classification == null) {
            return null;
        }
        Code code = new Code();
        code.setCode(classification.getNodeRepresentation());
        code.setDisplayName(classification.getName());
        List<String> slotValues = classification.getSlotValues("codingScheme");
        if (!slotValues.isEmpty()) {
            code.setSchemeName(slotValues.get(0));
        }
        return code;
    }
}

