/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.commons.ihe.xds.core.transform.ebxml;

import ca.uhn.hl7v2.model.Composite;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.openehealth.ipf.commons.ihe.xds.core.ebxml.EbXMLClassification;
import org.openehealth.ipf.commons.ihe.xds.core.ebxml.EbXMLFactory;
import org.openehealth.ipf.commons.ihe.xds.core.ebxml.EbXMLObjectLibrary;
import org.openehealth.ipf.commons.ihe.xds.core.metadata.Author;
import org.openehealth.ipf.commons.ihe.xds.core.metadata.Hl7v2Based;
import org.openehealth.ipf.commons.ihe.xds.core.metadata.Identifiable;
import org.openehealth.ipf.commons.ihe.xds.core.metadata.Organization;
import org.openehealth.ipf.commons.ihe.xds.core.metadata.Person;
import org.openehealth.ipf.commons.ihe.xds.core.metadata.Telecom;

public class AuthorTransformer {
    private final EbXMLFactory factory;

    public AuthorTransformer(EbXMLFactory ebXMLFactory) {
        this.factory = Objects.requireNonNull(ebXMLFactory, "ebXMLFactory cannot be null");
    }

    public EbXMLClassification toEbXML(Author author, EbXMLObjectLibrary objectLibrary) {
        Objects.requireNonNull(objectLibrary, "objectLibrary cannot be null");
        if (author == null) {
            return null;
        }
        EbXMLClassification classification = this.factory.createClassification(objectLibrary);
        classification.setNodeRepresentation("");
        String hl7XCN = Hl7v2Based.render(author.getAuthorPerson());
        if (hl7XCN != null) {
            classification.addSlot("authorPerson", hl7XCN);
        }
        AuthorTransformer.transformToHl7Slots(author.getAuthorInstitution(), classification, "authorInstitution");
        AuthorTransformer.transformToHl7Slots(author.getAuthorRole(), classification, "authorRole");
        AuthorTransformer.transformToHl7Slots(author.getAuthorSpecialty(), classification, "authorSpecialty");
        AuthorTransformer.transformToHl7Slots(author.getAuthorTelecom(), classification, "authorTelecommunication");
        return classification;
    }

    public Author fromEbXML(EbXMLClassification classification) {
        if (classification == null) {
            return null;
        }
        Author author = new Author();
        List<String> persons = classification.getSlotValues("authorPerson");
        if (!persons.isEmpty()) {
            Person person = Person.parse(persons.get(0));
            author.setAuthorPerson(person);
        }
        AuthorTransformer.transformFromHl7Slots(classification, "authorInstitution", author.getAuthorInstitution(), Organization.class);
        AuthorTransformer.transformFromHl7Slots(classification, "authorRole", author.getAuthorRole(), Identifiable.class);
        AuthorTransformer.transformFromHl7Slots(classification, "authorSpecialty", author.getAuthorSpecialty(), Identifiable.class);
        AuthorTransformer.transformFromHl7Slots(classification, "authorTelecommunication", author.getAuthorTelecom(), Telecom.class);
        return author;
    }

    private static <C extends Composite, T extends Hl7v2Based<C>> void transformFromHl7Slots(EbXMLClassification sourceClassification, String sourceSlotName, List<T> targetCollection, Class<T> targetClass) {
        sourceClassification.getSlotValues(sourceSlotName).stream().map(source -> Hl7v2Based.parse(source, targetClass)).filter(Objects::nonNull).forEach(targetCollection::add);
    }

    private static <T extends Hl7v2Based<?>> void transformToHl7Slots(List<T> sourceCollection, EbXMLClassification targetClassification, String targetSlotName) {
        ArrayList targetCollection = new ArrayList();
        sourceCollection.forEach(source -> {
            String target = Hl7v2Based.render(source);
            if (source != null) {
                targetCollection.add(target);
            }
        });
        String[] array = new String[targetCollection.size()];
        targetClassification.addSlot(targetSlotName, targetCollection.toArray(array));
    }
}

