/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.commons.ihe.xds.core.requests.builder;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Function;
import lombok.NonNull;
import org.openehealth.ipf.commons.core.URN;
import org.openehealth.ipf.commons.ihe.xds.core.metadata.Association;
import org.openehealth.ipf.commons.ihe.xds.core.metadata.AssociationLabel;
import org.openehealth.ipf.commons.ihe.xds.core.metadata.AssociationType;
import org.openehealth.ipf.commons.ihe.xds.core.metadata.DocumentEntry;
import org.openehealth.ipf.commons.ihe.xds.core.metadata.Folder;
import org.openehealth.ipf.commons.ihe.xds.core.metadata.SubmissionSet;
import org.openehealth.ipf.commons.ihe.xds.core.metadata.Timestamp;
import org.openehealth.ipf.commons.ihe.xds.core.metadata.XDSMetaClass;

abstract class AbstractSubmissionRequestBuilder<T extends AbstractSubmissionRequestBuilder<T, R, D>, R, D> {
    private final SubmissionSet submissionSet;
    private final boolean autoGenerate;
    private final Function<D, DocumentEntry> documentMapper;
    private final List<Folder> folders = new ArrayList<Folder>();
    private final List<D> documents = new ArrayList<D>();
    private final List<Association> associations = new ArrayList<Association>();

    public AbstractSubmissionRequestBuilder(boolean autoGenerate, @NonNull SubmissionSet submissionSet, Function<D, DocumentEntry> documentMapper) {
        if (submissionSet == null) {
            throw new NullPointerException("submissionSet is marked non-null but is null");
        }
        this.autoGenerate = autoGenerate;
        this.submissionSet = submissionSet;
        this.documentMapper = documentMapper;
    }

    public T withDocument(D doc) {
        this.documents.add(doc);
        return (T)this;
    }

    public T withDocuments(List<D> docs) {
        this.documents.addAll(docs);
        return (T)this;
    }

    public T withFolder(Folder folder) {
        this.folders.add(folder);
        return (T)this;
    }

    public T withFolders(List<Folder> folders) {
        this.folders.addAll(folders);
        return (T)this;
    }

    public T withAssociation(Association association) {
        this.associations.add(association);
        return (T)this;
    }

    public T withAssociations(List<Association> associations) {
        this.associations.addAll(associations);
        return (T)this;
    }

    abstract R doBuild(SubmissionSet var1, List<Folder> var2, List<D> var3, List<Association> var4);

    public R build() {
        if (this.autoGenerate) {
            this.supportivePostProcess();
        }
        return this.doBuild(this.submissionSet, this.folders, this.documents, this.associations);
    }

    private void supportivePostProcess() {
        List<DocumentEntry> docEntries = this.documents.stream().map(this.documentMapper).toList();
        AbstractSubmissionRequestBuilder.assignDefault(this.folders, XDSMetaClass::getUniqueId, XDSMetaClass::assignUniqueId);
        AbstractSubmissionRequestBuilder.assignDefault(this.folders, XDSMetaClass::getEntryUuid, XDSMetaClass::assignEntryUuid);
        AbstractSubmissionRequestBuilder.assignDefault(docEntries, XDSMetaClass::getUniqueId, XDSMetaClass::assignUniqueId);
        AbstractSubmissionRequestBuilder.assignDefault(docEntries, XDSMetaClass::getEntryUuid, XDSMetaClass::assignEntryUuid);
        AbstractSubmissionRequestBuilder.assignDefault(this.associations, Association::getEntryUuid, Association::assignEntryUuid);
        AbstractSubmissionRequestBuilder.assignDefault(this.submissionSet, XDSMetaClass::getUniqueId, XDSMetaClass::assignUniqueId);
        AbstractSubmissionRequestBuilder.assignDefault(this.submissionSet, XDSMetaClass::getEntryUuid, XDSMetaClass::assignEntryUuid);
        AbstractSubmissionRequestBuilder.assignDefault(this.submissionSet, SubmissionSet::getSubmissionTime, (T set) -> set.setSubmissionTime(Timestamp.now()));
        this.associations.addAll(docEntries.stream().filter(metadata -> !this.hasAssociationFromSubmissionSetWithHasMemberTo(metadata.getEntryUuid())).map(metadata -> this.createHasMemberAssocationWithOriginalLabel(metadata.getEntryUuid())).toList());
        this.associations.addAll(this.folders.stream().filter(metadata -> !this.hasAssociationFromSubmissionSetWithHasMemberTo(metadata.getEntryUuid())).map(metadata -> this.createHasMemberAssocation(metadata.getEntryUuid())).toList());
        this.associations.addAll(this.associations.stream().filter(assoc -> AssociationType.HAS_MEMBER.equals((Object)assoc.getAssociationType())).filter(assoc -> !Objects.equals(assoc.getSourceUuid(), this.submissionSet.getEntryUuid())).filter(assoc -> !this.hasAssociationFromSubmissionSetWithHasMemberTo(assoc.getEntryUuid())).map(assoc -> this.createHasMemberAssocation(assoc.getEntryUuid())).toList());
    }

    private Association createHasMemberAssocationWithOriginalLabel(String entryUuid) {
        Association assoc = this.createHasMemberAssocation(entryUuid);
        assoc.setLabel(AssociationLabel.ORIGINAL);
        return assoc;
    }

    private Association createHasMemberAssocation(String entryUuid) {
        return new Association(AssociationType.HAS_MEMBER, new URN(UUID.randomUUID()).toString(), this.submissionSet.getEntryUuid(), entryUuid);
    }

    private boolean hasAssociationFromSubmissionSetWithHasMemberTo(String entryUuid) {
        return this.associations.stream().anyMatch(assoc -> AssociationType.HAS_MEMBER.equals((Object)assoc.getAssociationType()) && Objects.equals(assoc.getSourceUuid(), this.submissionSet.getEntryUuid()) && Objects.equals(assoc.getTargetUuid(), entryUuid));
    }

    protected static <T> void assignDefault(T objectToCheck, Function<T, Object> nullCheck, Consumer<T> defaultAssignment) {
        if (nullCheck.apply(objectToCheck) == null) {
            defaultAssignment.accept(objectToCheck);
        }
    }

    private static <T> void assignDefault(List<T> listToCheck, Function<T, Object> nullCheck, Consumer<T> defaultAssignment) {
        listToCheck.stream().filter(l -> nullCheck.apply(l) == null).forEach(defaultAssignment);
    }
}

