/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.commons.ihe.xds.core.metadata.jaxbadapters;

import jakarta.xml.bind.annotation.adapters.XmlAdapter;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import org.openehealth.ipf.commons.ihe.xds.core.metadata.PatientInfo;
import org.openehealth.ipf.commons.ihe.xds.core.metadata.jaxbadapters.PatientInfoXml;

public class PatientInfoAdapter
extends XmlAdapter<PatientInfoXml, PatientInfo> {
    public PatientInfoXml marshal(PatientInfo patientInfo) {
        if (patientInfo == null) {
            return null;
        }
        PatientInfoXml xml = new PatientInfoXml();
        PatientInfoAdapter.marshalList(patientInfo.getIds(), xml.getIds());
        PatientInfoAdapter.marshalList(patientInfo.getNames(), xml.getNames());
        xml.setDateOfBirth(patientInfo.getDateOfBirth());
        xml.setGender(patientInfo.getGender());
        PatientInfoAdapter.marshalList(patientInfo.getAddresses(), xml.getAddresses());
        patientInfo.getCustomFieldIds().forEach(fieldId -> {
            List target = xml.getOther().computeIfAbsent((String)fieldId, dummy -> new ArrayList());
            PatientInfoAdapter.marshalList(patientInfo.getHl7FieldIterator((String)fieldId), target);
        });
        return xml;
    }

    public PatientInfo unmarshal(PatientInfoXml xml) {
        if (xml == null) {
            return null;
        }
        PatientInfo patientInfo = new PatientInfo();
        PatientInfoAdapter.unmarshalList(xml.getIds(), patientInfo.getIds());
        PatientInfoAdapter.unmarshalList(xml.getNames(), patientInfo.getNames());
        patientInfo.setDateOfBirth(xml.getDateOfBirth());
        patientInfo.setGender(xml.getGender());
        PatientInfoAdapter.unmarshalList(xml.getAddresses(), patientInfo.getAddresses());
        xml.getOther().forEach((fieldId, repetitions) -> PatientInfoAdapter.unmarshalList(repetitions, patientInfo.getHl7FieldIterator((String)fieldId)));
        return patientInfo;
    }

    private static <T> void marshalList(ListIterator<T> source, List<T> target) {
        while (source.hasNext()) {
            target.add(source.next());
        }
    }

    private static <T> void unmarshalList(List<T> source, ListIterator<T> target) {
        for (int i = source.size() - 1; i >= 0; --i) {
            target.add(source.get(i));
        }
    }
}

