/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.commons.ihe.xds.core.metadata.jaxbadapters;

import jakarta.xml.bind.annotation.adapters.XmlAdapter;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.openehealth.ipf.commons.ihe.xds.core.ebxml.EbXMLClassification;
import org.openehealth.ipf.commons.ihe.xds.core.ebxml.ebxml30.EbXMLClassification30;
import org.openehealth.ipf.commons.ihe.xds.core.metadata.jaxbadapters.ClassificationList;
import org.openehealth.ipf.commons.ihe.xds.core.stub.ebrs30.rim.ClassificationType;

public class ClassificationListAdapter
extends XmlAdapter<ClassificationList, List<EbXMLClassification>> {
    public List<EbXMLClassification> unmarshal(ClassificationList classificationList) {
        if (classificationList == null) {
            return null;
        }
        return classificationList.classifications.stream().map(EbXMLClassification30::new).collect(Collectors.toList());
    }

    public ClassificationList marshal(List<EbXMLClassification> ebXMLClassifications) {
        if (ebXMLClassifications == null) {
            return null;
        }
        ArrayList<ClassificationType> classifications = new ArrayList<ClassificationType>();
        for (EbXMLClassification ebXml : ebXMLClassifications) {
            if (ebXml instanceof EbXMLClassification30) {
                EbXMLClassification30 ebxml30 = (EbXMLClassification30)ebXml;
                classifications.add(ebxml30.getInternal());
                continue;
            }
            throw new UnsupportedOperationException("Only ebXML 3.0 is supported at the moment");
        }
        ClassificationList result = new ClassificationList();
        result.setClassifications(classifications);
        return result;
    }
}

